/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm.op;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.impl.BaseOperator;
import cz.vutbr.fit.layout.impl.ParameterBoolean;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

public class SortByPositionOperator
extends BaseOperator {
    protected boolean columnFirst;

    public SortByPositionOperator() {
        this.columnFirst = false;
    }

    public SortByPositionOperator(boolean columnFirst) {
        this.columnFirst = columnFirst;
    }

    public String getId() {
        return "FitLayout.Segm.SortByPosition";
    }

    public String getName() {
        return "Sort by position";
    }

    public String getDescription() {
        return "Sorts the visual areas by their position (x,y coordinates).";
    }

    public String getCategory() {
        return "Sorting";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(1);
        ret.add((Parameter)new ParameterBoolean("columnFirst"));
        return ret;
    }

    public boolean getColumnFirst() {
        return this.columnFirst;
    }

    public void setColumnFirst(boolean columnFirst) {
        this.columnFirst = columnFirst;
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.recursivelySortChildAreas(root, this.columnFirst);
    }

    protected void recursivelySortChildAreas(Area root, final boolean columnFirst) {
        if (root.getChildCount() > 1) {
            Vector list = new Vector(root.getChildren());
            Collections.sort(list, new Comparator<Area>(){

                @Override
                public int compare(Area a1, Area a2) {
                    if (!columnFirst) {
                        return a1.getY1() == a2.getY1() ? a1.getX1() - a2.getX1() : a1.getY1() - a2.getY1();
                    }
                    return a1.getX1() == a2.getX1() ? a1.getY1() - a2.getY1() : a1.getX1() - a2.getX1();
                }
            });
            root.removeAllChildren();
            root.appendChildren(list);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursivelySortChildAreas((Area)root.getChildAt(i), columnFirst);
        }
    }
}

