/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm;

import cz.vutbr.fit.layout.impl.DefaultAreaTree;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import java.util.HashSet;
import java.util.Set;

public class SegmentationAreaTree
extends DefaultAreaTree {
    private Page page;
    private boolean preserveAuxAreas;

    public SegmentationAreaTree(Page srcPage, boolean preserveAuxAreas) {
        super(srcPage.getIri());
        this.page = srcPage;
        this.preserveAuxAreas = preserveAuxAreas;
        Area rootarea = this.createArea(new Rectangular(0, 0, 0, 0));
        rootarea.setAreaTree((AreaTree)this);
        this.setRoot(rootarea);
    }

    public Area findBasicAreas() {
        Area rootarea = this.createArea(new Rectangular(0, 0, 0, 0));
        this.setRoot(rootarea);
        rootarea.setAreaTree((AreaTree)this);
        for (int i = 0; i < this.page.getRoot().getChildCount(); ++i) {
            Box cbox = (Box)this.page.getRoot().getChildAt(i);
            Area sub = this.createArea(cbox);
            if (sub.getWidth() <= 1 && sub.getHeight() <= 1) continue;
            this.findStandaloneAreas((Box)this.page.getRoot().getChildAt(i), sub);
            rootarea.appendChild((GenericTreeNode)sub);
        }
        this.createGrids(rootarea);
        return rootarea;
    }

    private void findStandaloneAreas(Box boxroot, Area arearoot) {
        if (boxroot.isVisible()) {
            for (int i = 0; i < boxroot.getChildCount(); ++i) {
                Box child = (Box)boxroot.getChildAt(i);
                if (!child.isVisible()) continue;
                if (this.isVisuallySeparated(child)) {
                    Area newnode = this.createArea(child);
                    if (newnode.getWidth() <= 1 && newnode.getHeight() <= 1) continue;
                    this.findStandaloneAreas(child, newnode);
                    arearoot.appendChild((GenericTreeNode)newnode);
                    continue;
                }
                this.findStandaloneAreas(child, arearoot);
            }
        }
    }

    public void updateTopologies() {
        this.createGrids(this.getRoot());
    }

    protected void createGrids(Area root) {
        root.updateTopologies();
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.createGrids((Area)root.getChildAt(i));
        }
    }

    protected boolean isVisuallySeparated(Box box) {
        return this.preserveAuxAreas || box.isRoot() || box.isVisuallySeparated();
    }

    public Set<Tag> getUsedTags() {
        HashSet<Tag> ret = new HashSet<Tag>();
        this.recursiveGetTags(this.getRoot(), ret);
        return ret;
    }

    private void recursiveGetTags(Area root, Set<Tag> dest) {
        dest.addAll(root.getTags().keySet());
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveGetTags((Area)root.getChildAt(i), dest);
        }
    }
}

