/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Border;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.segm.AreaStyle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeOp {
    private static Logger log = LoggerFactory.getLogger(TreeOp.class);

    public static void joinArea(Area target, Area other, Rectangular pos, boolean horizontal) {
        target.setGridPosition(pos);
        if (other.getChildCount() > 0) {
            ArrayList adopt = new ArrayList(other.getChildren());
            Iterator it = adopt.iterator();
            while (it.hasNext()) {
                target.appendChild((GenericTreeNode)((Area)it.next()));
            }
        }
        TreeOp.join(target, other, horizontal);
        for (Map.Entry entry : other.getTags().entrySet()) {
            if (target.getTags().containsKey(entry.getKey()) && !(((Float)entry.getValue()).floatValue() > ((Float)target.getTags().get(entry.getKey())).floatValue())) continue;
            target.getTags().put((Tag)entry.getKey(), (Float)entry.getValue());
        }
    }

    public static void join(Area target, Area other, boolean horizontal) {
        target.getBounds().expandToEnclose(other.getBounds());
        target.setName(target.getName() + " . " + other.getName());
        if (horizontal) {
            if (target.getX1() <= other.getX1()) {
                if (other.hasRightBorder()) {
                    target.setBorderStyle(Border.Side.RIGHT, other.getBorderStyle(Border.Side.RIGHT));
                }
            } else if (other.hasLeftBorder()) {
                target.setBorderStyle(Border.Side.LEFT, other.getBorderStyle(Border.Side.LEFT));
            }
        } else if (target.getY1() <= other.getY1()) {
            if (other.hasBottomBorder()) {
                target.setBorderStyle(Border.Side.BOTTOM, other.getBorderStyle(Border.Side.BOTTOM));
            }
        } else if (other.hasTopBorder()) {
            target.setBorderStyle(Border.Side.TOP, other.getBorderStyle(Border.Side.TOP));
        }
        target.getBoxes().addAll(other.getBoxes());
        target.getTextStyle().updateAverages(other.getTextStyle());
        if (!AreaStyle.hasEqualBackground(target, other)) {
            log.error("Area: Warning: joining areas {} and {} of different background colors {} x {}", new Object[]{target.getName(), other.getName(), target.getBackgroundColor(), other.getBackgroundColor()});
        }
    }

    public static void joinChild(Area target, Area other) {
        for (Box box : other.getBoxes()) {
            target.addBox(box);
        }
        target.getBounds().expandToEnclose(other.getBounds());
        target.setName(target.getName() + " . " + other.getName());
    }
}

