/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm.op;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.impl.BaseOperator;
import cz.vutbr.fit.layout.impl.ParameterBoolean;
import cz.vutbr.fit.layout.impl.ParameterFloat;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTopology;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.segm.AreaStyle;
import cz.vutbr.fit.layout.segm.TreeOp;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindLineOperator
extends BaseOperator {
    private static Logger log = LoggerFactory.getLogger(FindLineOperator.class);
    public static final String LINE_NEXT = "core.line.next";
    public static final String LINE_PREV = "core.line.prev";
    protected boolean useConsistentStyle;
    protected float maxLineEmSpace;

    public FindLineOperator() {
        this.useConsistentStyle = false;
        this.maxLineEmSpace = 1.5f;
    }

    public FindLineOperator(boolean useConsistentStyle, float maxLineEmSpace) {
        this.useConsistentStyle = useConsistentStyle;
        this.maxLineEmSpace = maxLineEmSpace;
    }

    public String getId() {
        return "FitLayout.Segm.FindLines";
    }

    public String getName() {
        return "Find lines";
    }

    public String getDescription() {
        return "Detects the basic lines in the area tree and joins the appropriate areas so that a line is the smallest visual area.";
    }

    public String getCategory() {
        return "Lines";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>();
        ret.add((Parameter)new ParameterBoolean("useConsistentStyle"));
        ret.add((Parameter)new ParameterFloat("maxLineEmSpace"));
        return ret;
    }

    public boolean getUseConsistentStyle() {
        return this.useConsistentStyle;
    }

    public void setUseConsistentStyle(boolean useConsistentStyle) {
        this.useConsistentStyle = useConsistentStyle;
    }

    public float getMaxLineEmSpace() {
        return this.maxLineEmSpace;
    }

    public void setMaxLineEmSpace(float maxLineEmSpace) {
        this.maxLineEmSpace = maxLineEmSpace;
    }

    public void apply(AreaTree atree) {
        this.recursiveJoinAreas(atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.recursiveJoinAreas(root);
    }

    protected void recursiveJoinAreas(Area root) {
        this.joinAreas(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveJoinAreas((Area)root.getChildAt(i));
        }
    }

    protected void joinAreas(Area a) {
        AreaTopology t = a.getTopology();
        boolean change = true;
        block0: while (change) {
            change = false;
            for (int i = 0; i < a.getChildCount(); ++i) {
                Area node = (Area)a.getChildAt(i);
                Rectangular pos = t.getPosition((ContentRect)node);
                int ny1 = pos.getY1();
                int nx2 = pos.getX2();
                int ny2 = pos.getY2();
                Area neigh = null;
                int dist = 1;
                while (neigh == null && nx2 + dist < t.getTopologyWidth()) {
                    for (int y = ny1; neigh == null && y <= ny2; ++y) {
                        neigh = (Area)t.findAreaAt(nx2 + dist, y);
                        if (neigh == null) continue;
                        if (!this.useConsistentStyle || AreaStyle.hasSameStyle(node, neigh)) {
                            if (!this.horizontalJoin(a, node, neigh, true)) continue;
                            node.updateTopologies();
                            change = true;
                            continue;
                        }
                        if (!this.horizontalJoin(a, node, neigh, false)) continue;
                        node.addUserAttribute(LINE_NEXT, (Object)neigh);
                        neigh.addUserAttribute(LINE_PREV, (Object)node);
                    }
                    ++dist;
                }
                if (change) continue block0;
            }
        }
    }

    private boolean horizontalJoin(Area parent, Area n1, Area n2, boolean affect) {
        int dist = Math.min(Math.abs(n2.getX1() - n1.getX2()), Math.abs(n1.getX1() - n2.getX2()));
        if ((float)dist > n1.getTextStyle().getFontSize() * this.maxLineEmSpace) {
            return false;
        }
        if (n1.hasRightBorder() || n2.hasLeftBorder() || !AreaStyle.hasEqualBackground(n1, n2)) {
            return false;
        }
        int sy1 = n1.getGridPosition().getY1();
        int sy2 = n2.getGridPosition().getY1();
        while (sy1 != sy2) {
            if (sy1 < sy2) {
                if (sy2 > 0 && this.canExpandY(parent, n2, sy2 - 1, n1)) {
                    --sy2;
                    continue;
                }
                return false;
            }
            if (sy1 <= sy2) continue;
            if (sy1 > 0 && this.canExpandY(parent, n1, sy1 - 1, n2)) {
                --sy1;
                continue;
            }
            return false;
        }
        int ey1 = n1.getGridPosition().getY2();
        int ey2 = n2.getGridPosition().getY2();
        while (ey1 != ey2) {
            if (ey1 < ey2) {
                if (ey1 < parent.getTopology().getTopologyWidth() - 1 && this.canExpandY(parent, n1, ey1 + 1, n2)) {
                    ++ey1;
                    continue;
                }
                return false;
            }
            if (ey1 <= ey2) continue;
            if (ey2 < parent.getTopology().getTopologyWidth() - 1 && this.canExpandY(parent, n2, ey2 + 1, n1)) {
                ++ey2;
                continue;
            }
            return false;
        }
        if (affect) {
            log.debug("Join: {} + {}", (Object)n1, (Object)n2);
            Rectangular newpos = new Rectangular(n1.getGridPosition().getX1(), sy1, n2.getGridPosition().getX2(), ey1);
            TreeOp.joinArea(n1, n2, newpos, true);
            parent.removeChild((GenericTreeNode)n2);
        }
        return true;
    }

    private boolean canExpandY(Area parent, Area node, int y, Area except) {
        AreaTopology t = parent.getTopology();
        int gx = t.getPosition((ContentRect)node).getX1();
        int gw = t.getTopologyWidth();
        for (int x = gx; x < gx + gw; ++x) {
            Area cand = (Area)t.findAreaAt(x, y);
            if (cand == null || cand == except) continue;
            return false;
        }
        return true;
    }
}

