/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm.op;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.segm.op.GroupAnalyzer;
import cz.vutbr.fit.layout.segm.op.GroupAnalyzerByDOM;
import cz.vutbr.fit.layout.segm.op.SuperAreaOperator;

public class GroupByDOMOperator
extends SuperAreaOperator {
    public GroupByDOMOperator() {
        super(1);
    }

    @Override
    public String getId() {
        return "FitLayout.Segm.GroupByDOM";
    }

    @Override
    public String getName() {
        return "Group by DOM nodes";
    }

    @Override
    public String getDescription() {
        return "Creates groups of areas that share the same source DOM node.";
    }

    @Override
    public void apply(AreaTree atree) {
        this.groupByDOM(atree.getRoot());
    }

    @Override
    public void apply(AreaTree atree, Area root) {
        this.groupByDOM(root);
    }

    @Override
    protected GroupAnalyzer createGroupAnalyzer(Area root) {
        return new GroupAnalyzerByDOM(root);
    }

    private void groupByDOM(Area root) {
        if (root.getChildCount() > 1) {
            this.findSuperAreas(root, 1);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.groupByDOM((Area)root.getChildAt(i));
        }
    }
}

