/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm.op;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.segm.op.GroupAnalyzer;
import cz.vutbr.fit.layout.segm.op.GroupAnalyzerByStyles;
import cz.vutbr.fit.layout.segm.op.SuperAreaOperator;

public class HomogeneousLeafOperator
extends SuperAreaOperator {
    public HomogeneousLeafOperator() {
        super(10);
    }

    @Override
    public String getId() {
        return "FitLayout.Segm.HomogeneousLeaves";
    }

    @Override
    public String getName() {
        return "Homogeneous leaves";
    }

    @Override
    public String getDescription() {
        return "Detects sequences of leaf areas with a consistent style that are not visually separated from each other and groups them to new areas.";
    }

    @Override
    public void apply(AreaTree atree) {
        this.findHomogeneousLeaves(atree.getRoot());
    }

    @Override
    public void apply(AreaTree atree, Area root) {
        this.findHomogeneousLeaves(root);
    }

    @Override
    protected GroupAnalyzer createGroupAnalyzer(Area root) {
        return new GroupAnalyzerByStyles(root, 1, true);
    }

    private void findHomogeneousLeaves(Area root) {
        if (root.getChildCount() > 1) {
            this.findSuperAreas(root, 1);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.findHomogeneousLeaves((Area)root.getChildAt(i));
        }
    }
}

