/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm.op;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTopology;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.segm.AreaUtils;
import cz.vutbr.fit.layout.segm.op.SortByPositionOperator;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class SortByLinesOperator
extends SortByPositionOperator {
    public SortByLinesOperator() {
        super(false);
    }

    @Override
    public String getId() {
        return "FitLayout.Segm.SortByLines";
    }

    @Override
    public String getName() {
        return "Sort by lines";
    }

    @Override
    public String getDescription() {
        return "Sorts the visual areas roughly according to the text lines detected in the file.";
    }

    @Override
    public List<Parameter> defineParams() {
        return Collections.emptyList();
    }

    @Override
    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    @Override
    public void apply(AreaTree atree, Area root) {
        this.recursivelySortChildAreas(root, false);
        this.recursiveSortLines(root);
    }

    protected void recursiveSortLines(Area root) {
        this.sortChildLines(root);
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveSortLines((Area)root.getChildAt(i));
        }
    }

    protected void sortChildLines(Area root) {
        if (root.getChildCount() > 1) {
            Vector<Area> src = new Vector<Area>(root.getChildren());
            Vector<Area> dest = new Vector<Area>(src.size());
            while (!src.isEmpty()) {
                Area seed = (Area)src.get(0);
                List<Area> line = this.findAreasOnLine(root, seed, src);
                dest.addAll(line);
                src.removeAll(line);
            }
            root.removeAllChildren();
            root.appendChildren(dest);
        }
    }

    private List<Area> findAreasOnLine(Area parent, Area area, List<Area> candidates) {
        int threshold;
        Area neigh;
        int y;
        Vector<Area> ret = new Vector<Area>();
        ret.add(area);
        int nx1 = area.getGridPosition().getX1();
        int ny1 = area.getGridPosition().getY1();
        int nx2 = area.getGridPosition().getX2();
        int ny2 = area.getGridPosition().getY2();
        AreaTopology t = parent.getTopology();
        int dist = 1;
        while (nx2 + dist < t.getTopologyWidth()) {
            for (y = ny1; y <= ny2; ++y) {
                neigh = (Area)t.findAreaAt(nx2 + dist, y);
                if (neigh == null || !candidates.contains(neigh)) continue;
                threshold = Math.min(area.getHeight(), neigh.getHeight()) / 2;
                if (threshold < 0) {
                    threshold = 0;
                }
                if (!AreaUtils.isOnSameLine(area, neigh, threshold)) continue;
                ret.add(neigh);
                break;
            }
            ++dist;
        }
        dist = 1;
        while (nx1 - dist >= 0) {
            for (y = ny1; y <= ny2; ++y) {
                neigh = (Area)t.findAreaAt(nx1 - dist, y);
                if (neigh == null || !candidates.contains(neigh)) continue;
                threshold = Math.min(area.getHeight(), neigh.getHeight()) / 2;
                if (threshold < 0) {
                    threshold = 0;
                }
                if (!AreaUtils.isOnSameLine(area, neigh, threshold)) continue;
                ret.insertElementAt(neigh, 0);
                break;
            }
            ++dist;
        }
        return ret;
    }
}

