/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm.op;

import cz.vutbr.fit.layout.impl.BaseOperator;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.segm.TreeOp;

public class CollapseAreasOperator
extends BaseOperator {
    public String getId() {
        return "FitLayout.Segm.CollapseAreas";
    }

    public String getName() {
        return "Collapse areas";
    }

    public String getDescription() {
        return "Collapses the areas having only one (leaf) child.";
    }

    public String getCategory() {
        return "Restructure";
    }

    public void apply(AreaTree atree) {
        this.recursiveCollapseAreas(atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.recursiveCollapseAreas(root);
    }

    private void recursiveCollapseAreas(Area root) {
        if (this.canCollapse(root)) {
            this.recursiveCollapseSubtree(root, root);
            root.removeAllChildren();
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.recursiveCollapseAreas((Area)root.getChildAt(i));
            }
        }
    }

    private boolean canCollapse(Area area) {
        return area.getChildCount() == 1 && ((Area)area.getChildAt(0)).isLeaf();
    }

    private void recursiveCollapseSubtree(Area src, Area dest) {
        for (int i = 0; i < src.getChildCount(); ++i) {
            Area child = (Area)src.getChildAt(i);
            this.recursiveCollapseSubtree(child, dest);
            TreeOp.joinChild(dest, child);
        }
    }
}

