/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm.op;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.segm.op.Separator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class SeparatorSet {
    protected static final double HSEP_MIN_HEIGHT = 0.1;
    protected static final double VSEP_MIN_WIDTH = 0.1;
    protected static final double SEP_MIN_RATIO = 1.0;
    protected static final int ART_SEP_WIDTH = 1;
    protected Area root;
    protected Vector<Separator> hsep;
    protected Vector<Separator> vsep;
    protected Vector<Separator> bsep;

    public SeparatorSet(Area root) {
        this.root = root;
        this.init(null);
    }

    public SeparatorSet(Area root, Area filter) {
        this.root = root;
        this.init(filter);
    }

    private void init(Area filter) {
        this.findAreaSeparators(this.root);
        this.findSeparators(this.root, filter);
    }

    public Vector<Separator> getHorizontal() {
        return this.hsep;
    }

    public Vector<Separator> getVertical() {
        return this.vsep;
    }

    public Vector<Separator> getBoxsep() {
        return this.bsep;
    }

    public Separator getMostImportantSeparator() {
        Separator sep = null;
        if (!this.hsep.isEmpty()) {
            sep = this.hsep.firstElement();
        }
        if (!(this.vsep.isEmpty() || sep != null && this.vsep.firstElement().getWeight() < sep.getWeight())) {
            sep = this.vsep.firstElement();
        }
        if (!(this.bsep.isEmpty() || sep != null && this.bsep.firstElement().getWeight() < sep.getWeight())) {
            sep = this.bsep.firstElement();
        }
        return sep;
    }

    public int getMinHSepHeight() {
        return (int)((double)this.root.getTextStyle().getFontSize() * 0.1);
    }

    public int getMinVSepWidth() {
        return (int)((double)this.root.getTextStyle().getFontSize() * 0.1);
    }

    public boolean isSeparatorAt(int x, int y) {
        return this.containsSeparatorAt(x, y, this.bsep) || this.containsSeparatorAt(x, y, this.hsep) || this.containsSeparatorAt(x, y, this.vsep);
    }

    private boolean containsSeparatorAt(int x, int y, Vector<Separator> col) {
        for (Separator sep : col) {
            if (!sep.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    protected abstract void findSeparators(Area var1, Area var2);

    protected void applyRegularFilters() {
        this.filterSeparators();
        this.processIntersections();
    }

    public void applyFinalFilters() {
        this.filterMarginalSeparators();
        this.filterSeparators();
        this.processIntersections();
        this.sortSeparators();
    }

    protected void filterMarginalSeparators() {
        Separator sep;
        Iterator<Separator> it = this.hsep.iterator();
        while (it.hasNext()) {
            sep = it.next();
            if (sep.getY1() != this.root.getY1() && sep.getY2() != this.root.getY2()) continue;
            it.remove();
        }
        it = this.vsep.iterator();
        while (it.hasNext()) {
            sep = it.next();
            if (sep.getX1() != this.root.getX1() && sep.getX2() != this.root.getX2()) continue;
            it.remove();
        }
    }

    protected void filterSeparators() {
        Separator sep;
        int hthreshold = this.getMinHSepHeight();
        int vthreshold = this.getMinVSepWidth();
        Iterator<Separator> it = this.hsep.iterator();
        while (it.hasNext()) {
            sep = it.next();
            Area above = this.findContentAbove(this.root, sep);
            hthreshold = above != null ? (int)((double)above.getTextStyle().getFontSize() * 0.1) : (int)((double)this.root.getTextStyle().getFontSize() * 0.1);
            if (sep.getWeight() < hthreshold) {
                it.remove();
                continue;
            }
            if (!((double)sep.getWidth() / (double)sep.getHeight() < 1.0)) continue;
            it.remove();
        }
        it = this.vsep.iterator();
        while (it.hasNext()) {
            sep = it.next();
            if (sep.getWeight() < vthreshold) {
                it.remove();
                continue;
            }
            if (!((double)sep.getHeight() / (double)sep.getWidth() < 1.0)) continue;
            it.remove();
        }
    }

    protected void processIntersections() {
    }

    protected void processIntersectionsSplitHorizontal() {
        boolean change;
        do {
            Vector<Separator> newsep = new Vector<Separator>(this.hsep.size());
            change = false;
            for (Separator hs : this.hsep) {
                boolean split = false;
                for (Separator vs : this.vsep) {
                    if (!hs.intersects(vs)) continue;
                    Separator nhs = hs.hsplit(vs);
                    newsep.add(hs);
                    if (nhs != null) {
                        newsep.add(nhs);
                    }
                    split = true;
                    change = true;
                    break;
                }
                if (split) continue;
                newsep.add(hs);
            }
            this.hsep = newsep;
        } while (change);
    }

    protected void processIntersectionsRemoveHorizontal() {
        Iterator<Separator> hit = this.hsep.iterator();
        block0: while (hit.hasNext()) {
            Separator hs = hit.next();
            for (Separator vs : this.vsep) {
                if (!hs.intersects(vs)) continue;
                hit.remove();
                continue block0;
            }
        }
    }

    private void sortSeparators() {
        Collections.sort(this.hsep);
        Collections.sort(this.vsep);
        Collections.sort(this.bsep);
    }

    private void findAreaSeparators(Area root) {
        this.bsep = new Vector();
        for (int i = 0; i < root.getChildCount(); ++i) {
            Area child = (Area)root.getChildAt(i);
            this.analyzeAreaSeparators(child);
        }
    }

    private void analyzeAreaSeparators(Area area) {
        boolean isep;
        boolean bl = isep = area.isExplicitlySeparated() || area.isBackgroundSeparated();
        if (isep || area.hasTopBorder()) {
            this.bsep.add(new Separator(2, area.getX1(), area.getY1(), area.getX2(), area.getY1() + 1 - 1));
        }
        if (isep || area.hasBottomBorder()) {
            this.bsep.add(new Separator(2, area.getX1(), area.getY2() - 1 + 1, area.getX2(), area.getY2()));
        }
        if (isep || area.hasLeftBorder()) {
            this.bsep.add(new Separator(3, area.getX1(), area.getY1(), area.getX1() + 1 - 1, area.getY2()));
        }
        if (isep || area.hasRightBorder()) {
            this.bsep.add(new Separator(3, area.getX2() - 1 + 1, area.getY1(), area.getX2(), area.getY2()));
        }
    }

    private Area findContentAbove(Area root, Separator sep) {
        return this.recursiveFindAreaAbove(root, sep.getX1(), sep.getX2(), 0, sep.getY1());
    }

    private Area recursiveFindAreaAbove(Area root, int x1, int x2, int y1, int y2) {
        Area ret = null;
        int maxx = x2;
        int miny = y1;
        List boxes = root.getBoxes();
        for (Box box : boxes) {
            int bx = box.getBounds().getX1();
            int by = box.getBounds().getY2();
            if (bx < x1 || bx > x2 || by >= y2 || by <= miny && (by != miny || bx >= maxx)) continue;
            ret = root;
            if (bx < maxx) {
                maxx = bx;
            }
            if (by <= miny) continue;
            miny = by;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            Area child = (Area)root.getChildAt(i);
            Area area = this.recursiveFindAreaAbove(child, x1, x2, miny, y2);
            if (area == null) continue;
            int bx = area.getX1();
            int by = area.getY2();
            int len = area.getText().length();
            if (len <= 0 || by <= miny && (by != miny || bx >= maxx)) continue;
            ret = area;
            if (bx < maxx) {
                maxx = bx;
            }
            if (by <= miny) continue;
            miny = by;
        }
        return ret;
    }
}

