/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;

public class AreaStyle {
    private float averageFontSize;
    private float averageFontWeight;
    private float averageFontStyle;
    private float averageColorLuminosity;
    private Color backgroundColor;

    public AreaStyle(float averageFontSize, float averageFontWeight, float averageFontStyle, float averageColorLuminosity, Color backgroundColor) {
        this.averageFontSize = averageFontSize;
        this.averageFontWeight = averageFontWeight;
        this.averageFontStyle = averageFontStyle;
        this.averageColorLuminosity = averageColorLuminosity;
        this.backgroundColor = backgroundColor;
    }

    public AreaStyle(Area source) {
        this.averageFontSize = source.getTextStyle().getFontSize();
        this.averageFontWeight = source.getTextStyle().getFontWeight();
        this.averageFontStyle = source.getTextStyle().getFontStyle();
        this.averageColorLuminosity = this.computeColorLuminosity(source);
        this.backgroundColor = source.getBackgroundColor();
    }

    public double getAverageFontSize() {
        return this.averageFontSize;
    }

    public void setAverageFontSize(float averageFontSize) {
        this.averageFontSize = averageFontSize;
    }

    public double getAverageFontWeight() {
        return this.averageFontWeight;
    }

    public void setAverageFontWeight(float averageFontWeight) {
        this.averageFontWeight = averageFontWeight;
    }

    public double getAverageFontStyle() {
        return this.averageFontStyle;
    }

    public void setAverageFontStyle(float averageFontStyle) {
        this.averageFontStyle = averageFontStyle;
    }

    public double getAverageColorLuminosity() {
        return this.averageColorLuminosity;
    }

    public void setAverageColorLuminosity(float averageColorLuminosity) {
        this.averageColorLuminosity = averageColorLuminosity;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public boolean isSameStyle(AreaStyle other) {
        double fsdif = Math.abs(this.getAverageFontSize() - other.getAverageFontSize());
        double wdif = Math.abs(this.getAverageFontWeight() - other.getAverageFontWeight());
        double sdif = Math.abs(this.getAverageFontStyle() - other.getAverageFontStyle());
        double ldif = Math.abs(this.getAverageColorLuminosity() - other.getAverageColorLuminosity());
        Color bg1 = this.getBackgroundColor();
        Color bg2 = other.getBackgroundColor();
        return fsdif <= 1.0 && wdif <= 0.8 && sdif <= 0.8 && ldif <= 0.005 && (bg1 == null && bg2 == null || bg1 != null && bg2 != null && bg1.equals((Object)bg2));
    }

    public static boolean hasSameStyle(Area a1, Area a2) {
        AreaStyle s1 = new AreaStyle(a1);
        AreaStyle s2 = new AreaStyle(a2);
        return s1.isSameStyle(s2);
    }

    public static boolean hasEqualBackground(Area a1, Area a2) {
        return a1.getBackgroundColor() == null && a2.getBackgroundColor() == null || a1.getBackgroundColor() != null && a2.getBackgroundColor() != null && a1.getBackgroundColor().equals((Object)a2.getBackgroundColor());
    }

    public static boolean hasConsistentStyle(Area root) {
        if (root.isLeaf()) {
            return true;
        }
        Area prevChild = null;
        for (Area child : root.getChildren()) {
            if (!AreaStyle.hasConsistentStyle(child)) {
                return false;
            }
            if (prevChild != null && !AreaStyle.hasSameStyle(prevChild, child)) {
                return false;
            }
            prevChild = child;
        }
        return true;
    }

    public float computeColorLuminosity(Area area) {
        if (area.getBoxes().isEmpty()) {
            return 0.0f;
        }
        float sum = 0.0f;
        int len = 0;
        for (Box box : area.getBoxes()) {
            int l = box.getText().length();
            sum += this.colorLuminosity(box.getColor()) * (float)l;
            len += l;
        }
        return sum / (float)len;
    }

    private float colorLuminosity(Color c) {
        float lr;
        float lg;
        float lb;
        if (c == null) {
            lb = 255.0f;
            lg = 255.0f;
            lr = 255.0f;
        } else {
            lr = (float)Math.pow((float)c.getRed() / 255.0f, 2.2f);
            lg = (float)Math.pow((float)c.getGreen() / 255.0f, 2.2f);
            lb = (float)Math.pow((float)c.getBlue() / 255.0f, 2.2f);
        }
        return lr * 0.2126f + lg * 0.7152f + lb * 0.0722f;
    }
}

