/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.impl.ParameterBoolean;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.segm.SegmentationAreaTree;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;

public class BasicSegmProvider
extends BaseArtifactService {
    private boolean preserveAuxAreas;

    public BasicSegmProvider() {
        this.preserveAuxAreas = false;
    }

    public BasicSegmProvider(boolean presereAuxAreas) {
        this.preserveAuxAreas = presereAuxAreas;
    }

    public String getId() {
        return "FitLayout.BasicAreas";
    }

    public String getName() {
        return "Simple area tree construction";
    }

    public String getDescription() {
        return "Creates a basic area tree by simply taking all visually separated boxes and creating visual areas from them.";
    }

    public IRI getConsumes() {
        return BOX.Page;
    }

    public IRI getProduces() {
        return SEGM.AreaTree;
    }

    public Artifact process(Artifact input) throws ServiceException {
        if (input != null && input instanceof Page) {
            AreaTree atree = this.createAreaTree((Page)input);
            IRI atreeIri = this.getServiceManager().getArtifactRepository().createArtifactIri((Artifact)atree);
            atree.setIri(atreeIri);
            return atree;
        }
        throw new ServiceException("Source artifact not specified or not a page");
    }

    public AreaTree createAreaTree(Page page) {
        SegmentationAreaTree atree = new SegmentationAreaTree(page, this.preserveAuxAreas);
        atree.findBasicAreas();
        atree.setParentIri(page.getIri());
        atree.setLabel(this.getId());
        atree.setCreator(this.getId());
        atree.setCreatorParams(this.getParamString());
        return atree;
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(1);
        ret.add((Parameter)new ParameterBoolean("preserveAuxAreas"));
        return ret;
    }

    public boolean getPreserveAuxAreas() {
        return this.preserveAuxAreas;
    }

    public void setPreserveAuxAreas(boolean preserveAuxAreas) {
        this.preserveAuxAreas = preserveAuxAreas;
    }
}

