/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm.op;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Rectangular;

public class Separator
extends Rectangular
implements Comparable<Separator> {
    public static final short HORIZONTAL = 0;
    public static final short VERTICAL = 1;
    public static final short BOXH = 2;
    public static final short BOXV = 3;
    protected short type;
    protected Area area1;
    protected Area area2;

    public Separator(short type, int x1, int y1, int x2, int y2) {
        super(x1, y1, x2, y2);
        this.type = type;
        this.area1 = null;
        this.area2 = null;
    }

    public Separator(Separator orig) {
        super((Rectangular)orig);
        this.type = orig.type;
        this.area1 = orig.area1;
        this.area2 = orig.area2;
    }

    public Separator(short type, Rectangular rect) {
        super(rect);
        this.type = type;
        this.area1 = null;
        this.area2 = null;
    }

    public short getType() {
        return this.type;
    }

    public void setType(short type) {
        this.type = type;
    }

    public boolean isBoxSep() {
        return this.type == 2 || this.type == 3;
    }

    public Area getArea1() {
        return this.area1;
    }

    public void setArea1(Area area1) {
        this.area1 = area1;
    }

    public Area getArea2() {
        return this.area2;
    }

    public void setArea2(Area area2) {
        this.area2 = area2;
    }

    public String toString() {
        String t = "?";
        switch (this.type) {
            case 0: {
                t = "HSep";
                break;
            }
            case 1: {
                t = "VSep";
                break;
            }
            case 2: {
                t = "BoxH";
                break;
            }
            case 3: {
                t = "BoxV";
            }
        }
        return t + " (" + this.x1 + ", " + this.y1 + ", " + this.x2 + ", " + this.y2 + ") w=" + this.getWeight() + " a1=" + this.area1 + " a2=" + this.area2;
    }

    @Override
    public int compareTo(Separator other) {
        return other.getWeight() - this.getWeight();
    }

    public boolean isHorizontal() {
        return this.getWidth() >= this.getHeight();
    }

    public boolean isVertical() {
        return this.getWidth() < this.getHeight();
    }

    public int getWeight() {
        int ww = Math.min(this.getWidth(), this.getHeight()) / 10;
        ww = this.isVertical() ? ww * 2 : ww;
        return ww;
    }

    public Separator hsplit(Separator other) {
        Rectangular r = super.hsplit((Rectangular)other);
        if (r == null) {
            return null;
        }
        return new Separator(this.type, r);
    }

    public Separator vsplit(Separator other) {
        Rectangular r = super.vsplit((Rectangular)other);
        if (r == null) {
            return null;
        }
        return new Separator(this.type, r);
    }
}

