/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Rectangular;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AreaLayout {
    public static boolean hasInFlowLayout(Area root) {
        float em = root.getTextStyle().getFontSize();
        List leaves = root.findNodesPreOrder(a -> a.isLeaf() || a.isBackgroundSeparated());
        Collections.sort(leaves, new Comparator<Area>(){

            @Override
            public int compare(Area a1, Area a2) {
                return a1.getY1() == a2.getY1() ? a1.getX1() - a2.getX1() : a1.getY1() - a2.getY1();
            }
        });
        boolean atStart = true;
        int lastX = 0;
        int lastY = 0;
        for (Area a2 : leaves) {
            Rectangular bounds = a2.getBounds();
            if (!atStart) {
                int difY = bounds.getY1() - lastY;
                if ((float)difY > 0.8f * em) {
                    return false;
                }
                int difX = bounds.getX1() - lastX;
                if ((float)difX > 1.0f * em) {
                    return false;
                }
            }
            lastX = bounds.getX2();
            lastY = bounds.getY2();
            atStart = false;
        }
        return true;
    }
}

