/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm.op;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.impl.BaseOperator;
import cz.vutbr.fit.layout.impl.ParameterInt;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.segm.Config;
import cz.vutbr.fit.layout.segm.Separators;
import cz.vutbr.fit.layout.segm.op.GroupAnalyzer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class SuperAreaOperator
extends BaseOperator {
    protected int depthLimit;

    public SuperAreaOperator() {
        this.depthLimit = 2;
    }

    public SuperAreaOperator(int depthLimit) {
        this.depthLimit = depthLimit;
    }

    public String getId() {
        return "FitLayout.Segm.SuperAreas";
    }

    public String getName() {
        return "Super areas";
    }

    public String getDescription() {
        return "Detects larger visual areas and creates the artificial area nodes. This implements a basic page segmentation algorithm.";
    }

    public String getCategory() {
        return "Restructure";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(1);
        ret.add((Parameter)new ParameterInt("depthLimit"));
        return ret;
    }

    public int getDepthLimit() {
        return this.depthLimit;
    }

    public void setDepthLimit(int depthLimit) {
        this.depthLimit = depthLimit;
    }

    public void apply(AreaTree atree) {
        this.recursiveFindSuperAreas(atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        this.recursiveFindSuperAreas(root);
    }

    protected GroupAnalyzer createGroupAnalyzer(Area root) {
        return Config.createGroupAnalyzer(root);
    }

    private void recursiveFindSuperAreas(Area root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveFindSuperAreas((Area)root.getChildAt(i));
        }
        this.findSuperAreas(root, this.depthLimit);
    }

    public void findSuperAreas(Area root, int passlimit) {
        if (root.getChildCount() > 0) {
            boolean changed = true;
            Separators.createSeparatorsForArea(root);
            for (int pass = 0; changed && pass < passlimit; ++pass) {
                changed = false;
                GroupAnalyzer groups = this.createGroupAnalyzer(root);
                Vector chld = new Vector();
                chld.addAll(root.getChildren());
                while (chld.size() > 1) {
                    ArrayList<Area> selected = new ArrayList<Area>();
                    int index = root.getIndex((GenericTreeNode)((Area)chld.firstElement()));
                    Area grp = null;
                    if (((Area)chld.firstElement()).isLeaf()) {
                        grp = groups.findSuperArea((Area)chld.firstElement(), selected);
                    }
                    if (selected.size() == root.getChildCount()) break;
                    if (selected.size() > 1) {
                        root.insertChild((GenericTreeNode)grp, index);
                        for (Area a : selected) {
                            grp.appendChild((GenericTreeNode)a);
                        }
                        chld.removeAll(selected);
                        grp.updateTopologies();
                        this.findSuperAreas(grp, passlimit - 1);
                        changed = true;
                        continue;
                    }
                    chld.removeElementAt(0);
                }
                root.updateTopologies();
                Separators.removeSimpleSeparators(root);
            }
        }
    }
}

