/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.segm.op;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.impl.BaseOperator;
import cz.vutbr.fit.layout.impl.DefaultTag;
import cz.vutbr.fit.layout.impl.ParameterBoolean;
import cz.vutbr.fit.layout.impl.ParameterString;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagByAttributeOperator
extends BaseOperator {
    private String attrName;
    private String tagType;
    private boolean multiTag;

    public TagByAttributeOperator() {
        this.attrName = "class";
        this.tagType = "attr";
        this.multiTag = true;
    }

    public TagByAttributeOperator(String attrName, String tagType, boolean multiTag) {
        this.attrName = attrName;
        this.tagType = tagType;
        this.multiTag = multiTag;
    }

    public String getId() {
        return "FitLayout.Tag.Attribute";
    }

    public String getName() {
        return "Tag areas by DOM attribute";
    }

    public String getDescription() {
        return "Tags visual areas based on a chosen DOM attribute value.";
    }

    public String getCategory() {
        return "Classification";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(2);
        ret.add((Parameter)new ParameterString("attrName", "DOM attribute name", 1, 255));
        ret.add((Parameter)new ParameterString("tagType", "The tag type to be used for the created tags", 1, 255));
        ret.add((Parameter)new ParameterBoolean("multiTag", "Assign multiple tags when the attribute contains multiple space-separated values"));
        return ret;
    }

    public String getAttrName() {
        return this.attrName;
    }

    public void setAttrName(String attrName) {
        this.attrName = attrName;
    }

    public String getTagType() {
        return this.tagType;
    }

    public void setTagType(String tagType) {
        this.tagType = tagType;
    }

    public boolean isMultiTag() {
        return this.multiTag;
    }

    public void setMultiTag(boolean multiTag) {
        this.multiTag = multiTag;
    }

    public void apply(AreaTree atree) {
        this.apply(atree, atree.getRoot());
    }

    public void apply(AreaTree atree, Area root) {
        HashMap<String, Tag> assignedTags = new HashMap<String, Tag>();
        this.recursivelyAssignTags(root, assignedTags);
    }

    private void recursivelyAssignTags(Area root, Map<String, Tag> assignedTags) {
        this.assignTags(root, assignedTags);
        for (Area child : root.getChildren()) {
            this.recursivelyAssignTags(child, assignedTags);
        }
    }

    private void assignTags(Area a, Map<String, Tag> assignedTags) {
        String attrVal;
        Box box = null;
        for (Box cand : a.getBoxes()) {
            if (cand.getAttribute(this.attrName) == null) continue;
            box = cand;
            break;
        }
        if (box != null && !(attrVal = box.getAttribute(this.attrName).trim().toLowerCase()).isEmpty()) {
            if (this.multiTag) {
                String[] tagVals;
                for (String tagVal : tagVals = attrVal.split("\\s+")) {
                    this.assignTag(a, tagVal, assignedTags);
                }
            } else {
                this.assignTag(a, attrVal, assignedTags);
            }
        }
    }

    private void assignTag(Area a, String tagName, Map<String, Tag> assignedTags) {
        Tag tag = assignedTags.get(tagName);
        if (tag == null) {
            tag = this.createTag(tagName);
            assignedTags.put(tagName, tag);
        }
        a.addTag(tag, 1.0f);
    }

    protected Tag createTag(String tagName) {
        String normalizedName = tagName.replaceAll("[^a-zA-Z0-9]+", "_");
        return new DefaultTag(this.tagType, normalizedName);
    }
}

