/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.bcs.impl;

import com.infomatiq.jsi.Rectangle;
import cz.vutbr.fit.layout.bcs.impl.PageAreaRelation;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.Rectangular;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PageArea {
    private Integer id;
    private Color color;
    private int left;
    private int right;
    private int top;
    private int bottom;
    private PageArea parent;
    private final ArrayList<PageArea> children;
    private final HashMap<PageArea, PageAreaRelation> neighbors;
    private int meanNeighborDistance;
    private int maxNeighborDistance;
    private Rectangle rectangle;
    private int vEdgeCount;
    private int hEdgeCount;
    private Box node;
    public static final int ALIGNMENT_NONE = 0;
    public static final int ALIGNMENT_LINE = 1;
    public static final int ALIGNMENT_COLUMN = 2;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_TOP = 4;
    public static final int ALIGNMENT_BOTTOM = 8;
    public static final int SHAPE_BLOB = 0;
    public static final int SHAPE_COLUMN = 1;
    public static final int SHAPE_ROW = 2;
    public static final double MAX_DIFF_RGB = 1.7320508075688772;
    public static final double MAX_DIFF_LAB = 258.68384120267046;
    public static final double MAX_DIFF_LCH = 149.93691702034678;

    public PageArea(Color c, Rectangular rect) {
        this.color = c;
        this.left = rect.getX1();
        this.top = rect.getY1();
        this.right = rect.getX2();
        this.bottom = rect.getY2();
        this.children = new ArrayList();
        this.neighbors = new HashMap();
        this.maxNeighborDistance = 0;
        this.meanNeighborDistance = 0;
        this.rectangle = null;
        this.vEdgeCount = 0;
        this.hEdgeCount = 0;
        this.id = null;
        this.node = null;
    }

    public PageArea(PageArea a) {
        this(a, false);
    }

    public PageArea(PageArea a, boolean inheritChildren) {
        this.color = new Color(a.color.getRGB());
        this.left = a.left;
        this.right = a.right;
        this.top = a.top;
        this.bottom = a.bottom;
        this.vEdgeCount = a.vEdgeCount;
        this.hEdgeCount = a.hEdgeCount;
        this.children = new ArrayList();
        this.neighbors = new HashMap();
        this.maxNeighborDistance = 0;
        this.meanNeighborDistance = 0;
        this.id = null;
        this.node = null;
        if (inheritChildren) {
            this.children.addAll(a.getChildren());
        }
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(int top, int left) {
        this.id = top * 10000 + left;
    }

    public void calculateId() {
        this.setId(this.top, this.left);
    }

    public boolean contains(PageArea obj) {
        return this.left <= obj.left && this.right >= obj.right && this.top <= obj.top && this.bottom >= obj.bottom;
    }

    public boolean overlaps(PageArea obj) {
        return this.right >= obj.left && this.left <= obj.right && this.bottom >= obj.top && this.top <= obj.bottom;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
        this.rectangle = null;
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
        this.rectangle = null;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
        this.rectangle = null;
    }

    public int getBottom() {
        return this.bottom;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
        this.rectangle = null;
    }

    public int getWidth() {
        return this.right - this.left + 1;
    }

    public int getHeight() {
        return this.bottom - this.top + 1;
    }

    public String toString() {
        return "(" + this.getTop() + "," + this.getLeft() + "-" + this.getWidth() + "x" + this.getHeight() + ")";
    }

    public void addChild(PageArea child) {
        this.addChild(child, false);
    }

    public PageArea tryAdd(PageArea a) {
        PageArea ret = new PageArea(this);
        ret.addChild(a, true);
        return ret;
    }

    public void addChild(PageArea child, boolean tryout) {
        this.children.add(child);
        if (!tryout) {
            child.setParent(this);
        }
        if (child.getBottom() > this.getBottom()) {
            this.setBottom(child.getBottom());
        }
        if (child.getRight() > this.getRight()) {
            this.setRight(child.getRight());
        }
        if (child.getLeft() < this.getLeft()) {
            this.setLeft(child.getLeft());
        }
        if (child.getTop() < this.getTop()) {
            this.setTop(child.getTop());
        }
    }

    public void delChild(PageArea child) {
        this.children.remove(child);
    }

    public List<PageArea> getChildren() {
        return this.children;
    }

    public void reclaimChildren() {
        if (this.children.size() == 0) {
            this.setParent(null);
        } else {
            for (PageArea child : this.children) {
                child.setParent(this);
            }
        }
    }

    public void giveUpChildren() {
        for (PageArea child : this.getChildren()) {
            if (child.getParent() != this) continue;
            child.setParent(null);
        }
    }

    public int getAreaCount() {
        if (this.children.size() > 0) {
            return this.children.size();
        }
        return 1;
    }

    public void mergeWith(PageArea a) {
        if (a.getChildren().size() > 0) {
            for (PageArea child : a.getChildren()) {
                this.addChild(child);
            }
        } else {
            this.addChild(a);
        }
    }

    public void setParent(PageArea parent) {
        this.parent = parent;
    }

    public PageArea getParent() {
        return this.parent;
    }

    public HashMap<PageArea, PageAreaRelation> getNeighbors() {
        return this.neighbors;
    }

    public PageAreaRelation getNeighbor(PageArea a) {
        return this.neighbors.get(a);
    }

    public void addNeighbor(PageArea a, int direction, int cardinality) {
        PageAreaRelation neighbor;
        int distance = this.getDistanceAbsolute(a);
        if (this.neighbors.containsKey(a) && (double)distance < (neighbor = this.neighbors.get(a)).getSimilarity()) {
            neighbor.setSimilarity(distance);
            neighbor.setAbsoluteDistance(distance);
            neighbor.setCardinality(neighbor.getCardinality() + cardinality);
        }
        neighbor = new PageAreaRelation(this, a, distance, direction);
        neighbor.setCardinality(cardinality);
        neighbor.setAbsoluteDistance(distance);
        this.neighbors.put(a, neighbor);
        a.neighbors.put(this, neighbor);
    }

    public void addNeighbor(PageAreaRelation rel) {
        PageArea a;
        if (rel.getA() == this) {
            a = rel.getB();
        } else if (rel.getB() == this) {
            a = rel.getA();
        } else {
            return;
        }
        if (this.neighbors.containsKey(a)) {
            return;
        }
        int distance = this.getDistanceAbsolute(a);
        PageAreaRelation neighbor = new PageAreaRelation(this, a, distance, rel.getDirection());
        neighbor.setCardinality(rel.getCardinality());
        neighbor.setAbsoluteDistance(distance);
        this.neighbors.put(a, neighbor);
        a.neighbors.put(this, neighbor);
    }

    public void delNeighbor(PageArea a) {
        PageAreaRelation rel = this.neighbors.get(a);
        if (rel == null) {
            return;
        }
        this.neighbors.remove(a);
        a.neighbors.remove(this);
    }

    public int getMaxNeighborDistance() {
        return this.maxNeighborDistance;
    }

    public void setMaxNeighborDistance(int maxNeighborDistance) {
        this.maxNeighborDistance = maxNeighborDistance;
    }

    public int getMeanNeighborDistance() {
        return this.meanNeighborDistance;
    }

    public void setMeanNeighborDistance(int meanNeighborDistance) {
        this.meanNeighborDistance = meanNeighborDistance;
    }

    public void calculateNeighborDistances() {
        int cnt = 0;
        int sum = 0;
        this.maxNeighborDistance = 0;
        for (Map.Entry<PageArea, PageAreaRelation> entry : this.neighbors.entrySet()) {
            int val = entry.getValue().getAbsoluteDistance();
            if (val > this.maxNeighborDistance) {
                this.maxNeighborDistance = val;
            }
            sum += val;
            ++cnt;
        }
        this.meanNeighborDistance = sum / (cnt != 0 ? cnt : 1);
    }

    public double getSimilarity(PageArea a, int alignmentScore) {
        double shape = this.getShapeSimilarity(a);
        double color = this.getColorSimilarity(a);
        double position = this.getDistanceNeighbor(a);
        if (position == 0.0) {
            return 0.0;
        }
        if (position > 1.0) {
            return 1.0;
        }
        return (0.3 * shape + 0.5 * color + 0.2 * position) / (double)(2 * alignmentScore);
    }

    public double getSizeSimilarity(PageArea a) {
        if (this == a) {
            return 0.0;
        }
        double widthRatio = (double)Math.abs(this.getWidth() - a.getWidth()) / (double)(this.getWidth() + a.getWidth());
        double heightRatio = (double)Math.abs(this.getHeight() - a.getHeight()) / (double)(this.getHeight() + a.getHeight());
        return Math.min(widthRatio, heightRatio);
    }

    public double getShapeSimilarity(PageArea a) {
        double ratio1 = (double)this.getWidth() / (double)this.getHeight();
        double ratio2 = (double)a.getWidth() / (double)a.getHeight();
        double ratioMin = Math.min(ratio1, ratio2);
        double ratioMax = Math.max(ratio1, ratio2);
        int surface1 = this.getWidth() * this.getHeight();
        int surface2 = a.getWidth() * a.getHeight();
        double ratioSimilarity = ratio1 == ratio2 ? 0.0 : (ratioMax - ratioMin) / ((ratioMax * ratioMax - 1.0) / ratioMax);
        double surfaceSimilarity = surface1 == surface2 ? 0.0 : (double)(1 - Math.min(surface1, surface2) / Math.max(surface1, surface2));
        return (ratioSimilarity + surfaceSimilarity) / 2.0;
    }

    public double getColorSimilarity(PageArea a) {
        if (this == a) {
            return 0.0;
        }
        double colorDistance = PageArea.colorDiffRgb(this.getColor(), a.getColor());
        return colorDistance /= 1.7320508075688772;
    }

    public double getDistance(PageArea a) {
        int verticalDistance;
        int horizontalDistance;
        if (this == a || this.overlaps(a)) {
            return 0.0;
        }
        int top = Math.min(this.top, a.top);
        int bottom = Math.max(this.bottom, a.bottom);
        int height = bottom - top;
        int left = Math.min(this.left, a.left);
        int right = Math.max(this.right, a.right);
        int width = right - left;
        if (this.getAlignment(a) == 2) {
            horizontalDistance = 0;
        } else {
            int ll = Math.abs(a.left - this.left);
            int lr = Math.abs(a.left - this.right);
            int rr = Math.abs(a.right - this.right);
            int rl = Math.abs(a.right - this.left);
            horizontalDistance = Math.min(Math.min(ll, lr), Math.min(rl, rr));
            if (horizontalDistance > 0) {
                --horizontalDistance;
            }
        }
        if (this.getAlignment(a) == 1) {
            verticalDistance = 0;
        } else {
            int tt = Math.abs(a.top - this.top);
            int tb = Math.abs(a.top - this.bottom);
            int bb = Math.abs(a.bottom - this.bottom);
            int bt = Math.abs(a.bottom - this.top);
            verticalDistance = Math.min(Math.min(tt, tb), Math.min(bt, bb));
            if (verticalDistance > 0) {
                --verticalDistance;
            }
        }
        return Math.sqrt(verticalDistance * verticalDistance + horizontalDistance * horizontalDistance) / Math.sqrt(width * width + height * height);
    }

    public double getDistanceNeighbor(PageArea a) {
        PageAreaRelation rel = this.neighbors.get(a);
        if (rel == null) {
            return 1.1;
        }
        if (this == a || this.overlaps(a)) {
            return 0.0;
        }
        double dist = this.getDistanceAbsolute(a);
        double forward = dist / (double)this.maxNeighborDistance;
        double backward = dist / (double)a.maxNeighborDistance;
        return (forward + backward) / 2.0;
    }

    public int getDistanceAbsolute(PageArea a) {
        if (this == a || this.overlaps(a)) {
            return 0;
        }
        if (this.left > a.right || a.left > this.right) {
            return Math.min(Math.abs(this.left - a.right), Math.abs(a.left - this.right));
        }
        return Math.min(Math.abs(this.top - a.bottom), Math.abs(a.top - this.bottom));
    }

    public int getAlignment(PageArea a) {
        if (this.bottom >= a.top && this.top <= a.bottom) {
            return 1;
        }
        if (this.right >= a.left && this.left <= a.right) {
            return 2;
        }
        if (a.getLeft() == this.getLeft()) {
            return 2;
        }
        if (a.getTop() == this.getTop()) {
            return 1;
        }
        if (a.getRight() == this.getRight()) {
            return 2;
        }
        if (a.getBottom() == this.getBottom()) {
            return 1;
        }
        return 0;
    }

    public int getSideAlignment(PageArea a) {
        if (a.getLeft() == this.getLeft()) {
            return 1;
        }
        if (a.getTop() == this.getTop()) {
            return 4;
        }
        if (a.getRight() == this.getRight()) {
            return 2;
        }
        if (a.getBottom() == this.getBottom()) {
            return 8;
        }
        return 0;
    }

    public static double colorDiff(Color a, Color b) {
        if (a == null || b == null) {
            return 100.0;
        }
        double[] lab = PageArea.rgbToLab(a.getRed(), a.getGreen(), a.getBlue());
        double l1 = lab[0];
        double a1 = lab[1];
        double b1 = lab[2];
        lab = PageArea.rgbToLab(b.getRed(), b.getGreen(), b.getBlue());
        double l2 = lab[0];
        double a2 = lab[1];
        double b2 = lab[2];
        return Math.sqrt(Math.pow(l2 - l1, 2.0) + Math.pow(a2 - a1, 2.0) + Math.pow(b2 - b1, 2.0));
    }

    public static double colorDiffLch(Color a, Color b) {
        if (a == null || b == null) {
            return 100.0;
        }
        double[] lab = PageArea.rgbToLab(a.getRed(), a.getGreen(), a.getBlue());
        double[] lch = PageArea.labToLch(lab);
        double l1 = lch[0];
        double c1 = lch[1];
        double h1 = lch[2];
        lab = PageArea.rgbToLab(b.getRed(), b.getGreen(), b.getBlue());
        lch = PageArea.labToLch(lab);
        double l2 = lch[0];
        double c2 = lch[1];
        double h2 = lch[2];
        double dl = l2 - l1;
        double dc = c2 - c1;
        double dh = h2 - h1;
        return Math.sqrt(dl * dl + (dc /= 1.0 + 0.045 * c1) * dc + (dh /= 1.0 + 0.015 * c1) * dh);
    }

    public static double colorDiffRgb(Color color1, Color color2) {
        double r1 = (double)color1.getRed() / 255.0;
        double g1 = (double)color1.getGreen() / 255.0;
        double b1 = (double)color1.getBlue() / 255.0;
        double r2 = (double)color2.getRed() / 255.0;
        double g2 = (double)color2.getGreen() / 255.0;
        double b2 = (double)color2.getBlue() / 255.0;
        double dr = r2 - r1;
        double dg = g2 - g1;
        double db = b2 - b1;
        return Math.sqrt(dr * dr + dg * dg + db * db);
    }

    private static double[] rgbToLab(int R, int G, int B) {
        double whiteX = 0.9505;
        double whiteY = 1.0;
        double whiteZ = 1.0888;
        double r = (double)R / 255.0;
        double g = (double)G / 255.0;
        double b = (double)B / 255.0;
        r = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : (r /= 12.92);
        g = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : (g /= 12.92);
        b = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : (b /= 12.92);
        double x = 0.4124564 * r + 0.3575761 * g + 0.1804375 * b;
        double y = 0.2126729 * r + 0.7151522 * g + 0.072175 * b;
        double z = 0.0193339 * r + 0.119192 * g + 0.9503041 * b;
        double xr = x / whiteX;
        double yr = y / whiteY;
        double zr = z / whiteZ;
        double fx = xr > 0.008856 ? PageArea.cubeRoot(xr) : PageArea.computeF(xr);
        double fy = yr > 0.008856 ? PageArea.cubeRoot(yr) : PageArea.computeF(yr);
        double fz = zr > 0.008856 ? PageArea.cubeRoot(zr) : PageArea.computeF(zr);
        double[] lab = new double[]{116.0 * fy - 16.0, 500.0 * (fx - fy), 200.0 * (fy - fz)};
        return lab;
    }

    private static double computeF(double x) {
        return (903.3 * x + 16.0) / 116.0;
    }

    private static double cubeRoot(double x) {
        return Math.pow(x, 0.3333333333333333);
    }

    private static double[] labToLch(double[] lab) {
        double[] lch = new double[]{lab[0], Math.sqrt(lab[1] * lab[1] + lab[2] * lab[2]), Math.atan2(lab[2], lab[1])};
        return lch;
    }

    public Rectangle getRectangle() {
        if (this.rectangle == null) {
            this.rectangle = new Rectangle((float)this.left, (float)this.top, (float)this.right, (float)this.bottom);
        }
        return this.rectangle;
    }

    public void resetRectangle() {
        this.rectangle = null;
    }

    public int getVEdgeCount() {
        return this.vEdgeCount;
    }

    public double getVRatio() {
        if (this.vEdgeCount == 0) {
            return 0.1;
        }
        int edgeCount = this.vEdgeCount + this.hEdgeCount;
        if (edgeCount == 0) {
            return 0.0;
        }
        return this.vEdgeCount / edgeCount;
    }

    public void setVEdgeCount(int vEdgeCount) {
        this.vEdgeCount = vEdgeCount;
    }

    public void addVEdgeCount(int vEdgeCount) {
        this.vEdgeCount = vEdgeCount;
    }

    public int getHEdgeCount() {
        return this.hEdgeCount;
    }

    public double getHRatio() {
        if (this.hEdgeCount == 0) {
            return 0.1;
        }
        int edgeCount = this.vEdgeCount + this.hEdgeCount;
        if (edgeCount == 0) {
            return 0.0;
        }
        return this.hEdgeCount / edgeCount;
    }

    public void setHEdgeCount(int hEdgeCount) {
        this.hEdgeCount = hEdgeCount;
    }

    public void addHEdgeCount(int hEdgeCount) {
        this.hEdgeCount = hEdgeCount;
    }

    public boolean isRow() {
        return this.getHRatio() > 2.0 * this.getVRatio();
    }

    public boolean isColumn() {
        return this.getHRatio() < 0.5 * this.getVRatio();
    }

    public int getShape() {
        if (this.isRow()) {
            return 2;
        }
        if (this.isColumn()) {
            return 1;
        }
        return 0;
    }

    public boolean isBlob() {
        return !this.isColumn() && !this.isRow();
    }

    public Box getNode() {
        return this.node;
    }

    public void setNode(Box node) {
        this.node = node;
    }
}

