/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.bcs.impl;

import cz.vutbr.fit.layout.bcs.impl.PageArea;
import cz.vutbr.fit.layout.model.Color;
import java.util.ArrayList;

public class SimplePattern {
    private final ArrayList<PageArea> children;
    private int alignment;
    public static final int ALIGNMENT_NONE = 0;
    public static final int ALIGNMENT_TOP = 1;
    public static final int ALIGNMENT_BOTTOM = 2;
    public static final int ALIGNMENT_LEFT = 3;
    public static final int ALIGNMENT_RIGHT = 4;
    private Color meanColor;
    private double colorTolerance;
    private double meanSize;
    private double sizeTolerance;

    public SimplePattern(ArrayList<PageArea> c) {
        this.children = c;
        this.evaluate();
    }

    public void evaluate() {
        if (this.children.size() == 0) {
            this.alignment = 0;
        }
        PageArea a = this.children.get(0);
        for (int i = 1; i < this.children.size(); ++i) {
            PageArea b = this.children.get(i);
            int alignment = this.getAlignment(a, b);
            if (alignment == 0) {
                return;
            }
            if (this.alignment == 0) {
                this.alignment = alignment;
                continue;
            }
            if (this.alignment == alignment) continue;
            this.alignment = 0;
            return;
        }
        int bSum = 0;
        int gSum = 0;
        int rSum = 0;
        double sizeSum = 0;
        for (PageArea child : this.children) {
            rSum += child.getColor().getRed();
            gSum += child.getColor().getGreen();
            bSum += child.getColor().getBlue();
            if (this.alignment == 1 || this.alignment == 2) {
                sizeSum += (double)child.getHeight();
                continue;
            }
            sizeSum += (double)child.getWidth();
        }
        this.meanColor = new Color(rSum /= this.children.size(), gSum /= this.children.size(), bSum /= this.children.size());
        this.meanSize = sizeSum / (double)this.children.size();
        sizeSum = 0.0;
        double sum = 0.0;
        for (PageArea child : this.children) {
            double tmpVal = PageArea.colorDiff(child.getColor(), this.meanColor);
            sum += tmpVal * tmpVal;
            tmpVal = this.alignment == 1 || this.alignment == 2 ? this.meanSize - (double)child.getHeight() : this.meanSize - (double)child.getWidth();
            sizeSum += tmpVal * tmpVal;
        }
        sizeSum /= (double)this.children.size();
        this.colorTolerance = Math.sqrt(sum /= (double)this.children.size());
        if (this.colorTolerance == 0.0) {
            this.colorTolerance = 5.0;
        }
        this.sizeTolerance = Math.sqrt(sizeSum);
    }

    public boolean match(PageArea a) {
        if (this.children.size() == 0) {
            return true;
        }
        if (this.alignment == 0) {
            return false;
        }
        PageArea child = this.children.get(0);
        if (this.alignment == 1 && child.getTop() != a.getTop() || this.alignment == 2 && child.getBottom() != a.getBottom() || this.alignment == 3 && child.getLeft() != a.getLeft() || this.alignment == 4 && child.getRight() != a.getRight()) {
            return false;
        }
        double colorDiff = PageArea.colorDiff(this.meanColor, a.getColor());
        if (colorDiff > this.colorTolerance) {
            return false;
        }
        double sizeDiff = this.getSizeDiff(a);
        return !(sizeDiff > this.sizeTolerance);
    }

    private double getSizeDiff(PageArea a) {
        if (this.alignment == 1 || this.alignment == 2) {
            return Math.abs(this.meanSize - (double)a.getHeight());
        }
        return Math.abs(this.meanSize - (double)a.getWidth());
    }

    private int getAlignment(PageArea a, PageArea b) {
        if (a.getLeft() == b.getLeft()) {
            return 3;
        }
        if (a.getTop() == b.getTop()) {
            return 1;
        }
        if (a.getRight() == b.getRight()) {
            return 4;
        }
        if (a.getBottom() == b.getBottom()) {
            return 2;
        }
        return 0;
    }

    public double getWidthRatio(PageArea a, PageArea b) {
        return (double)Math.abs(a.getWidth() - b.getWidth()) / (double)(a.getWidth() + b.getWidth());
    }

    public double getHeightRatio(PageArea a, PageArea b) {
        return (double)Math.abs(a.getHeight() - b.getHeight()) / (double)(a.getHeight() + b.getHeight());
    }
}

