/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.bcs.impl;

import cz.vutbr.fit.layout.bcs.impl.PageArea;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageOutput {
    private List<PageArea> areas;
    private int width;
    private int height;

    public ImageOutput(List<PageArea> areas, int width, int height) {
        this.areas = areas;
        this.width = width;
        this.height = height;
    }

    public void save(String path) {
        BufferedImage img = this.createImage();
        File outfile = new File(path);
        try {
            ImageIO.write((RenderedImage)img, "png", outfile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private BufferedImage createImage() {
        BufferedImage img = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        for (PageArea area : this.areas) {
            g.setColor(this.toAWTColor(area.getColor()));
            g.fillRect(area.getLeft(), area.getTop(), area.getRight() - area.getLeft() + 1, area.getBottom() - area.getTop() + 1);
        }
        return img;
    }

    private Color toAWTColor(cz.vutbr.fit.layout.model.Color src) {
        if (src == null) {
            return null;
        }
        return new Color(src.getRed(), src.getGreen(), src.getBlue(), src.getAlpha());
    }
}

