/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.bcs.impl;

import cz.vutbr.fit.layout.bcs.impl.PageArea;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PageAreaRelation {
    private PageArea a;
    private PageArea b;
    private double similarity;
    private int alignmentScore;
    private int absoluteDistance;
    private int direction;
    public static final int DIRECTION_VERTICAL = 0;
    public static final int DIRECTION_HORIZONTAL = 1;
    private int cardinality;

    public PageAreaRelation(PageArea a, PageArea b, double similarity, int direction) {
        this.a = a;
        this.b = b;
        this.similarity = similarity;
        this.setDirection(direction);
        this.setCardinality(1);
        this.setAlignmentScore(1);
    }

    public PageArea getA() {
        return this.a;
    }

    public void setA(PageArea a) {
        this.a = a;
    }

    public PageArea getB() {
        return this.b;
    }

    public void setB(PageArea b) {
        this.b = b;
    }

    public double getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(double similarity) {
        this.similarity = similarity;
    }

    public void addSimilarity(double similarity) {
        this.similarity += similarity;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public void addCardinality(int cardinality) {
        this.cardinality += cardinality;
    }

    public int getAbsoluteDistance() {
        return this.absoluteDistance;
    }

    public void setAbsoluteDistance(int absoluteDistance) {
        this.absoluteDistance = absoluteDistance;
    }

    public String toString() {
        return "Relation: " + this.getAbsoluteDistance() + "-" + this.getSimilarity() + "-" + this.getAlignmentScore() + "-" + this.getCardinality() + "-" + this.a.toString() + "-" + this.b.toString();
    }

    public int getAlignmentScore() {
        return this.alignmentScore;
    }

    public void setAlignmentScore(int alignmentScore) {
        this.alignmentScore = alignmentScore;
    }

    public void addAlignmentScore(int alignmentScore) {
        this.alignmentScore += alignmentScore;
    }

    public int computeAlignmentScore() {
        int aligned = 1;
        int alignment = 0;
        ArrayList<PageArea> queue = new ArrayList<PageArea>();
        HashSet<PageArea> inspected = new HashSet<PageArea>();
        alignment = this.a.getSideAlignment(this.b);
        int threshold = (int)Math.floor((double)Math.min(Math.min(this.a.getWidth(), this.a.getHeight()), Math.min(this.b.getWidth(), this.b.getHeight())) * 1.5);
        if (alignment == 0 || this.absoluteDistance > threshold) {
            return aligned;
        }
        ++aligned;
        queue.add(this.a);
        queue.add(this.b);
        while (queue.size() > 0) {
            PageArea cur = (PageArea)queue.get(0);
            queue.remove(0);
            if (inspected.contains(cur) || queue.contains(cur)) continue;
            HashMap<PageArea, PageAreaRelation> neighbors = cur.getNeighbors();
            for (Map.Entry<PageArea, PageAreaRelation> entry : neighbors.entrySet()) {
                PageArea area = entry.getKey();
                PageAreaRelation relation = entry.getValue();
                if (relation.getDirection() != this.direction || inspected.contains(area) || queue.contains(area) || cur.getSideAlignment(area) != alignment || relation.getAbsoluteDistance() > threshold) continue;
                ++aligned;
                queue.add(area);
            }
            inspected.add(cur);
        }
        return aligned;
    }
}

