/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.bcs;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.bcs.impl.AreaCreator;
import cz.vutbr.fit.layout.bcs.impl.AreaProcessor2;
import cz.vutbr.fit.layout.bcs.impl.ImageOutput;
import cz.vutbr.fit.layout.bcs.impl.PageArea;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.impl.DefaultAreaTree;
import cz.vutbr.fit.layout.impl.ParameterFloat;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.SEGM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;

public class BCSProvider
extends BaseArtifactService {
    private float threshold = 0.3f;
    private boolean debug = true;

    public String getId() {
        return "FitLayout.BCS";
    }

    public String getName() {
        return "BCS";
    }

    public String getDescription() {
        return "BCS: the Box Clustering Segmentation Algorithm";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(1);
        ret.add((Parameter)new ParameterFloat("threshold"));
        return ret;
    }

    public IRI getConsumes() {
        return BOX.Page;
    }

    public IRI getProduces() {
        return SEGM.AreaTree;
    }

    public Artifact process(Artifact input) throws ServiceException {
        if (input != null && input instanceof Page) {
            AreaTree atree = this.createAreaTree((Page)input);
            IRI atreeIri = this.getServiceManager().getArtifactRepository().createArtifactIri((Artifact)atree);
            atree.setIri(atreeIri);
            return atree;
        }
        throw new ServiceException("Source artifact not specified or not a page");
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public AreaTree createAreaTree(Page page) {
        boolean graphOutput;
        AreaCreator c = new AreaCreator(page.getWidth(), page.getHeight());
        List<PageArea> areas = c.getAreas(page.getRoot());
        boolean bl = graphOutput = System.getProperty("fitlayout.bcs.debug") != null;
        if (graphOutput) {
            ImageOutput imgout = new ImageOutput(areas, page.getWidth(), page.getHeight());
            imgout.save("areas.png");
        }
        AreaProcessor2 h = new AreaProcessor2(areas, page.getWidth(), page.getHeight());
        if (this.threshold > 0.0f) {
            h.setThreshold(this.threshold);
        }
        h.setDebug(this.debug);
        List<PageArea> groups = h.extractGroups(h.getAreas());
        List<PageArea> ungrouped = h.getUngrouped();
        List<PageArea> all = this.unifyAreas(groups, ungrouped);
        DefaultAreaTree atree = new DefaultAreaTree(page.getIri());
        atree.setParentIri(page.getIri());
        atree.setLabel(this.getId());
        atree.setCreator(this.getId());
        atree.setCreatorParams(this.getParamString());
        Area root = atree.createArea(new Rectangular(0, 0, page.getWidth() - 1, page.getHeight() - 1));
        root.setName("root");
        atree.setRoot(root);
        this.appendGroups((AreaTree)atree, root, all);
        return atree;
    }

    private List<PageArea> unifyAreas(List<PageArea> groups, List<PageArea> ungrouped) {
        ArrayList<PageArea> all = new ArrayList<PageArea>(groups.size() + ungrouped.size());
        all.addAll(groups);
        all.addAll(ungrouped);
        Collections.sort(all, new Comparator<PageArea>(){

            @Override
            public int compare(PageArea a1, PageArea a2) {
                if (a1.getTop() == a2.getTop()) {
                    return a1.getLeft() - a2.getLeft();
                }
                return a1.getTop() - a2.getTop();
            }
        });
        return all;
    }

    private void appendGroups(AreaTree atree, Area root, List<PageArea> groups) {
        for (PageArea pa : groups) {
            Rectangular pos = new Rectangular(pa.getLeft(), pa.getTop(), pa.getRight(), pa.getBottom());
            Area child = atree.createArea(pos);
            root.appendChild((GenericTreeNode)child);
        }
    }
}

