/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.bcs.impl;

import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.SpatialIndex;
import com.infomatiq.jsi.rtree.RTree;
import cz.vutbr.fit.layout.bcs.impl.AreaMatch;
import cz.vutbr.fit.layout.bcs.impl.AreaSizeComparator;
import cz.vutbr.fit.layout.bcs.impl.AverageColor;
import cz.vutbr.fit.layout.bcs.impl.PageArea;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.ContentImage;
import cz.vutbr.fit.layout.model.Rectangular;
import gnu.trove.TIntProcedure;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;

public class AreaCreator {
    private static final int ALLOWED_OVERLAP_ELEMENT = 1;
    private static final int ALLOWED_OVERLAP_REPLACED = 1;
    private static final float ALLOWED_OVERLAP_TEXT = 0.1f;
    private ArrayList<PageArea> areas;
    private HashSet<Integer> mask;
    private final int pageWidth;
    private final int pageHeight;
    private SpatialIndex areaTree;

    public AreaCreator(int w, int h) {
        this.pageWidth = w;
        this.pageHeight = h;
    }

    public List<PageArea> getAreas(Box root) {
        this.areaTree = new RTree();
        this.areaTree.init(null);
        this.areas = new ArrayList();
        this.mask = new HashSet();
        ArrayList<PageArea> ret = new ArrayList<PageArea>();
        this.createAreasSubtree(root, Color.WHITE);
        for (int index = 0; index < this.areas.size(); ++index) {
            if (this.mask.contains(index)) continue;
            ret.add(this.areas.get(index));
        }
        Collections.sort(ret, new AreaSizeComparator());
        return ret;
    }

    private void createAreasSubtree(Box root, Color parentBg) {
        Color bgColor = this.getBgColor(root, parentBg);
        if (root.getChildCount() == 0) {
            if (!this.isTransparent(root)) {
                this.createElementArea(root, parentBg);
            }
            return;
        }
        if (root.getChildCount() == 1) {
            Box child = (Box)root.getChildAt(0);
            if (child.getType() == Box.Type.TEXT_CONTENT) {
                this.createTextArea(child, bgColor);
                return;
            }
            if (this.hasNoBranches(child)) {
                this.createSmallestBox(root, parentBg);
                return;
            }
        }
        for (Box child : root.getChildren()) {
            if (child.getType() == Box.Type.TEXT_CONTENT) {
                this.createTextArea(child, bgColor);
                continue;
            }
            if (child.getType() == Box.Type.REPLACED_CONTENT) {
                this.createImageArea(child, child.getContentBounds());
                continue;
            }
            this.createAreasSubtree(child, bgColor);
        }
    }

    private boolean hasNoBranches(Box root) {
        if (root.getChildCount() == 0) {
            return true;
        }
        if (root.getChildCount() == 1) {
            Box child = (Box)root.getChildAt(0);
            if (child.getType() == Box.Type.TEXT_CONTENT) {
                return true;
            }
            return this.hasNoBranches(child);
        }
        return false;
    }

    private void createSmallestBox(Box root, Color parentBg) {
        if (root.getChildCount() == 0) {
            this.createElementArea(root, parentBg);
        } else {
            Box child = (Box)root.getChildAt(0);
            Color bgColor = this.getBgColor(root, parentBg);
            if (child.getType() == Box.Type.TEXT_CONTENT) {
                this.createTextArea(child, bgColor);
            } else if (child.getType() == Box.Type.REPLACED_CONTENT) {
                this.createImageArea(child, child.getContentBounds());
            } else if (this.isTransparent(root)) {
                this.createSmallestBox(child, parentBg);
            } else {
                this.createElementArea(child, parentBg);
            }
        }
    }

    private Color getBgColor(Box box, Color parentBg) {
        BufferedImage bgImg = this.getBackgroundImage(box);
        Color color = box.getBackgroundColor();
        if (color == null) {
            color = parentBg;
        }
        if (bgImg != null) {
            AverageColor imgColor = new AverageColor(bgImg);
            if (imgColor.getColor() != null) {
                return imgColor.mixWithBackground(color);
            }
            return color;
        }
        return color;
    }

    private BufferedImage getBackgroundImage(Box box) {
        if (box.getBackgroundImagePng() != null) {
            try {
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(box.getBackgroundImagePng()));
                return image;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private BufferedImage getContentImage(Box box) {
        if (box.getContentObject() != null && box.getContentObject() instanceof ContentImage) {
            ContentImage img = (ContentImage)box.getContentObject();
            if (img.getPngData() != null) {
                try {
                    BufferedImage image = ImageIO.read(new ByteArrayInputStream(img.getPngData()));
                    return image;
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    private boolean isTransparent(Box box) {
        return !box.hasBackground();
    }

    private void createTextArea(Box box, Color bgColor) {
        Rectangular pos = box.getContentBounds();
        if (this.onPage(pos)) {
            int white_multiplier;
            int hsb_index;
            Color color = box.getColor();
            float[] hsb = java.awt.Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            if (hsb[1] == 0.0f) {
                if (hsb[2] == 1.0f) {
                    float[] bgHsb = java.awt.Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), null);
                    hsb[0] = bgHsb[0];
                    hsb[1] = 0.2f;
                    hsb_index = 1;
                    white_multiplier = -1;
                } else {
                    hsb_index = 2;
                    white_multiplier = -1;
                    if (hsb[2] == 0.0f) {
                        hsb[2] = 0.2f;
                    }
                }
            } else {
                hsb_index = 1;
                white_multiplier = 1;
            }
            if (box.getTextStyle().getUnderline() > 0.5f) {
                int n = hsb_index;
                hsb[n] = hsb[n] + (float)white_multiplier * 0.2f;
            }
            if (box.getTextStyle().getFontStyle() > 0.5f) {
                int n = hsb_index;
                hsb[n] = hsb[n] - (float)white_multiplier * 0.2f;
            }
            if (box.getTextStyle().getFontWeight() > 0.5f) {
                int n = hsb_index;
                hsb[n] = hsb[n] + (float)white_multiplier * 0.3f;
            }
            if (hsb[hsb_index] > 1.0f) {
                hsb[hsb_index] = 1.0f;
            } else if ((double)hsb[hsb_index] < 0.0) {
                hsb[hsb_index] = 0.0f;
            }
            Color avgcolor = new Color(java.awt.Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
            PageArea area = new PageArea(avgcolor, pos);
            area.setNode(box);
            int size = Math.min(pos.getWidth(), pos.getHeight());
            int overlap = Math.round((float)size * 0.1f);
            this.addArea(area, overlap);
        }
    }

    private void createImageArea(Box box, Rectangular pos) {
        AverageColor avg;
        BufferedImage img;
        if (this.onPage(pos) && (img = this.getContentImage(box)) != null && img.getWidth() > 0 && img.getHeight() > 0 && (avg = new AverageColor(img)).getColor() != null) {
            PageArea area = new PageArea(avg.getColor(), pos);
            area.setNode(box);
            this.addArea(area, 1);
        }
    }

    private void createElementArea(Box box, Color parentBg) {
        Color c;
        Rectangular rect = box.getContentBounds();
        if (this.onPage(rect) && (c = this.getBgColor(box, parentBg)) != null) {
            PageArea area = new PageArea(c, rect);
            area.setNode(box);
            this.addArea(area, 1);
        }
    }

    private boolean onPage(Rectangular r) {
        if (r.getX1() > this.pageWidth || r.getY1() > this.pageHeight) {
            return false;
        }
        if (r.isEmpty()) {
            return false;
        }
        return r.getX2() >= 0 && r.getY2() >= 0;
    }

    private void addArea(PageArea area, int allowedOverlap) {
        Rectangle areaRect = new Rectangle((float)(area.getLeft() + allowedOverlap), (float)(area.getTop() + allowedOverlap), (float)(area.getRight() - allowedOverlap), (float)(area.getBottom() - allowedOverlap));
        AreaMatch match = new AreaMatch();
        this.areaTree.intersects(areaRect, (TIntProcedure)match);
        for (Integer id : match.getIds()) {
            this.mask.add(id);
        }
        this.areas.add(area);
        this.areaTree.add(area.getRectangle(), this.areas.size() - 1);
    }
}

