/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.bcs.impl;

import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.SpatialIndex;
import com.infomatiq.jsi.rtree.RTree;
import cz.vutbr.fit.layout.bcs.impl.AreaMatch;
import cz.vutbr.fit.layout.bcs.impl.AreaProximityComparator;
import cz.vutbr.fit.layout.bcs.impl.AreaSizeComparator;
import cz.vutbr.fit.layout.bcs.impl.PageArea;
import cz.vutbr.fit.layout.bcs.impl.PageAreaRelation;
import cz.vutbr.fit.layout.bcs.impl.RelationComparator;
import cz.vutbr.fit.layout.bcs.impl.StopWatch;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaProcessor2 {
    private static Logger log = LoggerFactory.getLogger(AreaProcessor2.class);
    private boolean DEBUG = false;
    private final ArrayList<PageArea> areas;
    private final SpatialIndex areaTree;
    private final SpatialIndex groupTree;
    private final HashMap<Integer, PageArea> groupMap;
    private final ArrayList<PageArea> ungrouped;
    private double similarityThreshold = 0.3;
    private final int pageWidth;
    private final int pageHeight;
    private final StopWatch time;

    public AreaProcessor2(List<PageArea> areas, int width, int height) {
        Collections.sort(areas, new AreaSizeComparator());
        this.areas = new ArrayList();
        this.areaTree = new RTree();
        this.areaTree.init(null);
        this.groupMap = new HashMap();
        this.groupTree = new RTree();
        this.groupTree.init(null);
        this.ungrouped = new ArrayList();
        this.pageHeight = width;
        this.pageWidth = height;
        this.time = new StopWatch(true);
        this.buildHierarchy(areas);
    }

    public void setThreshold(double t) {
        if (t < 0.0 || t > 1.0) {
            return;
        }
        this.similarityThreshold = t;
    }

    public double getThreshold() {
        return this.similarityThreshold;
    }

    public void setDebug(boolean d) {
        this.DEBUG = d;
    }

    private void buildHierarchy(List<PageArea> areas) {
        ArrayList<PageArea> pool = new ArrayList<PageArea>();
        ArrayList<PageArea> deleteList = new ArrayList<PageArea>();
        pool.addAll(areas);
        Collections.sort(pool, new AreaSizeComparator());
        for (PageArea area : areas) {
            PageArea a2;
            for (PageArea a2 : deleteList) {
                pool.remove(a2);
            }
            deleteList.clear();
            Iterator iterator = pool.iterator();
            while (iterator.hasNext() && area != (a2 = (PageArea)iterator.next())) {
                if (!area.contains(a2)) continue;
                area.addChild(a2);
                deleteList.add(a2);
            }
        }
        this.extractLeafAreas(areas);
    }

    public ArrayList<PageArea> getAreas() {
        return this.areas;
    }

    private void extractLeafAreas(List<PageArea> areas) {
        this.areas.clear();
        for (PageArea a : areas) {
            if (a.getChildren().size() != 0) continue;
            a.setParent(null);
            a.getChildren().clear();
            this.areas.add(a);
            this.areaTree.add(a.getRectangle(), this.areas.size() - 1);
        }
    }

    public HashMap<Integer, PageArea> getGroups() throws Exception {
        if (this.groupMap.isEmpty() && !this.areas.isEmpty()) {
            this.extractGroups(this.areas);
        }
        return this.groupMap;
    }

    public List<PageArea> extractGroups(List<PageArea> areas) {
        ArrayList<PageArea> ret = new ArrayList<PageArea>();
        ArrayList<PageAreaRelation> relations = this.getAreaGraph(areas);
        this.locateGroups(relations);
        this.ungrouped.clear();
        for (PageArea group : this.groupMap.values()) {
            ret.add(group);
        }
        for (PageArea area : this.areas) {
            if (area.getParent() != null) continue;
            this.ungrouped.add(area);
        }
        return ret;
    }

    private void locateGroups(ArrayList<PageAreaRelation> relations) {
        int relCnt = relations.size();
        ArrayList<PageAreaRelation> mtRelations = new ArrayList<PageAreaRelation>();
        ArrayList<PageArea> mergeCandidates = new ArrayList<PageArea>();
        this.time.toggle();
        while (relations.size() > 0) {
            boolean area_overlap;
            PageAreaRelation relation;
            PageArea b;
            PageArea a;
            do {
                relation = relations.get(0);
                relations.remove(0);
                a = relation.getA();
                b = relation.getB();
            } while (relations.size() > 0 && (a.getParent() != null || b.getParent() != null));
            if (relations.size() == 0 && a.getParent() == null && b.getParent() == null) break;
            if (this.DEBUG) {
                log.debug("Picked " + relation.toString() + "\n");
            }
            int v1 = a.getAreaCount();
            int v2 = b.getAreaCount();
            int vsum = v1 + v2;
            int groupCnt = (a.getChildren().size() == 0 ? 0 : 1) + (b.getChildren().size() == 0 ? 0 : 1);
            double threshold = this.similarityThreshold;
            double similarity = relation.getSimilarity();
            boolean mergeTest = this.mergeTest(relation);
            if (similarity > threshold || !mergeTest) {
                if (similarity <= threshold && !mergeTest) {
                    if (this.DEBUG) {
                        log.debug("Merge attempt failed\n");
                    }
                    mtRelations.add(relation);
                } else if (similarity >= threshold && this.DEBUG) {
                    log.debug("Similarity comparison failed: " + similarity + " >= " + threshold + "\n");
                }
                if (relations.size() != 0 || mtRelations.size() >= relCnt) continue;
                relations.addAll(mtRelations);
                relCnt = relations.size();
                mtRelations.clear();
                continue;
            }
            PageArea group = this.createGroup(a, b);
            mergeCandidates.clear();
            if (this.DEBUG) {
                log.debug("Group: " + group.getTop() + "-" + group.getLeft() + "(" + group.getWidth() + "x" + group.getHeight() + ") - (" + v1 + ", " + v2 + ")\n");
            }
            AreaMatch match = new AreaMatch();
            this.groupTree.intersects(group.getRectangle(), (TIntProcedure)match);
            if (match.getIds().size() > groupCnt) {
                a.reclaimChildren();
                b.reclaimChildren();
                group.giveUpChildren();
                continue;
            }
            do {
                match = new AreaMatch();
                this.areaTree.intersects(group.getRectangle(), (TIntProcedure)match);
                boolean bl = area_overlap = match.getIds().size() > vsum;
                if (area_overlap) {
                    if (this.DEBUG) {
                        log.debug("overlap = true; vsum = " + vsum + "; matches = " + match.getIds().size() + "\n");
                    }
                    if (!this.growGroup(group, match.getIds(), mergeCandidates)) {
                        if (this.DEBUG) {
                            log.debug("group grow failed\n");
                        }
                        a.reclaimChildren();
                        b.reclaimChildren();
                        group.giveUpChildren();
                        break;
                    }
                    vsum = group.getChildren().size() + mergeCandidates.size();
                    if (!this.DEBUG) continue;
                    log.debug("updated vsum: " + vsum + "\n");
                    continue;
                }
                if (this.DEBUG) {
                    log.debug("overlap = false; vsum = " + vsum + "; matches = " + match.getIds().size() + "\n");
                }
                if (mergeCandidates.size() <= 0) continue;
                if (this.DEBUG) {
                    log.debug("trying to merge group " + group.toString() + " and " + mergeCandidates.size() + " candidates\n");
                }
                if (!this.tryMerge(group, mergeCandidates)) {
                    if (this.DEBUG) {
                        log.debug("merging failed\n");
                    }
                    a.reclaimChildren();
                    b.reclaimChildren();
                    group.giveUpChildren();
                    area_overlap = true;
                    break;
                }
                mergeCandidates.clear();
                area_overlap = true;
            } while (area_overlap);
            if (!area_overlap) {
                if (this.DEBUG) {
                    log.debug("Final Group: " + group.getTop() + "-" + group.getLeft() + "(" + group.getWidth() + "x" + group.getHeight() + ")\n");
                }
                this.transferNeighbors(a, b, group);
                this.transferRelations(a, b, group, relations);
                if (a.getId() != null) {
                    this.groupMap.remove(a.getId());
                }
                if (b.getId() != null) {
                    this.groupMap.remove(b.getId());
                }
                group.calculateId();
                this.groupMap.put(group.getId(), group);
                this.groupTree.delete(a.getRectangle(), 0);
                this.groupTree.delete(b.getRectangle(), 0);
                this.groupTree.add(group.getRectangle(), 0);
            }
            if (relations.size() != 0 || mtRelations.size() >= relCnt) continue;
            relations.addAll(mtRelations);
            relCnt = relations.size();
            mtRelations.clear();
        }
        this.time.toggle();
    }

    private boolean growGroup(PageArea group, ArrayList<Integer> matches, ArrayList<PageArea> mergeCandidates) {
        boolean merged = true;
        ArrayList<PageArea> areas = new ArrayList<PageArea>();
        for (Integer i : matches) {
            areas.add(this.areas.get(i));
        }
        Collections.sort(areas, new AreaSizeComparator());
        Collections.reverse(areas);
        block1: while (merged) {
            merged = false;
            for (int i = 0; i < areas.size(); ++i) {
                PageArea area = (PageArea)areas.get(i);
                if (this.DEBUG) {
                    log.debug("area test for merge: " + area.toString());
                }
                if (area.getParent() == group) {
                    if (this.DEBUG) {
                        log.debug(" (already in the group)\n");
                    }
                    areas.remove(i);
                    --i;
                    continue;
                }
                if (area.getParent() != null) {
                    if (this.DEBUG) {
                        log.debug(" (belongs to another group)\n");
                    }
                    return false;
                }
                for (PageArea child : group.getChildren()) {
                    if (!area.overlaps(child)) continue;
                    merged = true;
                    group.addChild(area);
                    if (!this.DEBUG) break;
                    log.debug(" (merged - overlap)\n");
                    break;
                }
                if (merged) {
                    areas.remove(i);
                    --i;
                    continue block1;
                }
                if (!mergeCandidates.contains(area)) {
                    mergeCandidates.add(area);
                }
                if (!this.DEBUG) continue;
                log.debug(" (not merged)\n");
            }
        }
        return true;
    }

    private boolean tryMerge(PageArea group, ArrayList<PageArea> areas) {
        PageArea tmpGroup = new PageArea(group);
        int matchCnt = 0;
        int candidateCnt = areas.size();
        ArrayList<PageArea> mergeList = new ArrayList<PageArea>();
        for (PageArea area : areas) {
            if (this.DEBUG) {
                log.debug("candidate: " + area.toString());
            }
            PageArea mark = new PageArea(tmpGroup);
            tmpGroup.addChild(area, true);
            if (group.contains(tmpGroup)) {
                if (this.DEBUG) {
                    log.debug(" is within the group\n");
                }
                group.addChild(area);
                --candidateCnt;
                continue;
            }
            AreaMatch match = new AreaMatch();
            tmpGroup.resetRectangle();
            this.areaTree.intersects(tmpGroup.getRectangle(), (TIntProcedure)match);
            matchCnt = match.getIds().size();
            if (matchCnt > group.getChildren().size() + candidateCnt) {
                boolean merge = false;
                for (Integer i : match.getIds()) {
                    PageArea tmpArea = this.areas.get(i);
                    if (group.getChildren().contains(tmpArea) || areas.contains(tmpArea) || tmpArea.getDistanceAbsolute(mark) > 1) continue;
                    mergeList.add(area);
                    if (this.DEBUG) {
                        log.debug(" brings new adjacent box\n");
                    }
                    merge = true;
                    break;
                }
                if (merge) continue;
                if (this.DEBUG) {
                    log.debug(" would bring more boxes to the group\n");
                }
                return false;
            }
            if (this.DEBUG) {
                log.debug(" expands the group but can be included\n");
            }
            group.addChild(area);
            --candidateCnt;
        }
        for (PageArea a : mergeList) {
            if (this.DEBUG) {
                log.debug("merging " + a.toString() + "\n");
            }
            group.addChild(a);
        }
        return true;
    }

    private PageArea createGroup(PageArea a, PageArea b) {
        PageArea group = new PageArea(a);
        group.mergeWith(a);
        group.mergeWith(b);
        return group;
    }

    private boolean mergeTest(PageAreaRelation rel) {
        PageArea a = rel.getA();
        PageArea b = rel.getB();
        int direction = rel.getDirection();
        int aShape = a.getShape();
        int bShape = b.getShape();
        if (direction == 1) {
            if (aShape == bShape) {
                if (aShape == 1) {
                    return this.mergeTestDensity(a, b, aShape);
                }
                return true;
            }
            return this.mergeTestAlignment(a, b);
        }
        if (aShape == bShape) {
            if (aShape == 2) {
                return this.mergeTestDensity(a, b, aShape);
            }
            return true;
        }
        return this.mergeTestAlignment(a, b);
    }

    private boolean mergeTestAlignment(PageArea a, PageArea b) {
        PageArea tmpArea = new PageArea(a);
        tmpArea.addChild(b, true);
        int areaCnt = a.getAreaCount() + b.getAreaCount();
        AreaMatch match = new AreaMatch();
        this.areaTree.intersects(tmpArea.getRectangle(), (TIntProcedure)match);
        return match.getIds().size() <= areaCnt;
    }

    private boolean mergeTestDensity(PageArea a, PageArea b, int shape) {
        int dimB;
        int cntB;
        int dimA;
        int cntA;
        if (shape == 2) {
            cntA = a.getVEdgeCount();
            dimA = a.getHeight();
            cntB = b.getVEdgeCount();
            dimB = b.getHeight();
        } else if (shape == 1) {
            cntA = a.getHEdgeCount();
            dimA = a.getWidth();
            cntB = b.getHEdgeCount();
            dimB = b.getWidth();
        } else {
            return false;
        }
        double densA = (double)cntA / (double)dimA;
        double densB = (double)cntB / (double)dimB;
        double ratio = Math.min(densA, densB) / Math.max(densA, densB);
        return ratio <= 0.5;
    }

    private void transferRelations(PageArea oldGroup1, PageArea oldGroup2, PageArea newGroup, List<PageAreaRelation> relations) {
        PageAreaRelation rel;
        HashMap<PageArea, PageAreaRelation> tmpRelations = new HashMap<PageArea, PageAreaRelation>();
        HashSet<PageArea> merged = new HashSet<PageArea>();
        merged.add(oldGroup1);
        merged.add(oldGroup2);
        for (PageArea pageArea : newGroup.getChildren()) {
            merged.add(pageArea);
        }
        for (int i = 0; i < relations.size(); ++i) {
            PageAreaRelation bestRel;
            rel = relations.get(i);
            PageArea candidate = merged.contains(rel.getA()) ? rel.getB() : (merged.contains(rel.getB()) ? rel.getA() : null);
            if (candidate == null) continue;
            if (merged.contains(candidate)) {
                if (this.DEBUG) {
                    log.debug("remove " + rel.toString() + " (within group)\n");
                }
                if (rel.getDirection() == 1) {
                    newGroup.addHEdgeCount(rel.getCardinality());
                } else {
                    newGroup.addVEdgeCount(rel.getCardinality());
                }
                relations.remove(i);
                --i;
                continue;
            }
            if (candidate.getParent() != null) {
                candidate = candidate.getParent();
            }
            if (tmpRelations.containsKey(candidate)) {
                bestRel = (PageAreaRelation)tmpRelations.get(candidate);
                bestRel.addCardinality(rel.getCardinality());
                bestRel.addSimilarity(rel.getSimilarity() * (double)rel.getCardinality());
            } else {
                double tmpSimilarity = rel.getSimilarity() * (double)rel.getCardinality();
                bestRel = new PageAreaRelation(newGroup, candidate, tmpSimilarity, rel.getDirection());
                bestRel.setCardinality(rel.getCardinality());
                tmpRelations.put(candidate, bestRel);
            }
            if (this.DEBUG) {
                log.debug("remove " + rel.toString() + "\n");
            }
            relations.remove(i);
            --i;
        }
        for (Map.Entry entry : tmpRelations.entrySet()) {
            rel = (PageAreaRelation)entry.getValue();
            rel.setSimilarity(rel.getSimilarity() / (double)rel.getCardinality());
            relations.add(rel);
        }
        Collections.sort(relations, new RelationComparator());
    }

    private void transferNeighbors(PageArea oldGroup1, PageArea oldGroup2, PageArea newGroup) {
        ArrayList<PageArea> delList = new ArrayList<PageArea>();
        HashMap<PageArea, Integer> recalc = new HashMap<PageArea, Integer>();
        HashMap<PageArea, Integer> children = new HashMap<PageArea, Integer>();
        for (PageArea child : newGroup.getChildren()) {
            children.put(child, 0);
        }
        children.put(oldGroup1, 0);
        children.put(oldGroup2, 0);
        for (PageArea a : newGroup.getChildren()) {
            delList.clear();
            for (Map.Entry<PageArea, PageAreaRelation> entry : a.getNeighbors().entrySet()) {
                PageArea area = entry.getKey();
                PageAreaRelation rel = entry.getValue();
                delList.add(area);
                recalc.put(area, 0);
                if (children.containsKey(area)) continue;
                newGroup.addNeighbor(area, rel.getDirection(), rel.getCardinality());
            }
            for (PageArea del : delList) {
                del.delNeighbor(a);
            }
        }
        newGroup.calculateNeighborDistances();
        for (PageArea a : recalc.keySet()) {
            a.calculateNeighborDistances();
        }
    }

    private ArrayList<PageAreaRelation> getAreaGraph(List<PageArea> areas) {
        PageArea a;
        ArrayList<PageAreaRelation> relations = new ArrayList<PageAreaRelation>();
        ArrayList<PageAreaRelation> tmpRelations = new ArrayList();
        for (int i = 0; i < areas.size(); ++i) {
            a = areas.get(i);
            Rectangle selector = new Rectangle((float)(a.getRight() + 1), (float)(a.getTop() + 1), (float)this.pageWidth, (float)(a.getBottom() - 1));
            tmpRelations = this.findRelations(a, selector, 1);
            this.processRelations(tmpRelations, relations, true);
            selector = new Rectangle((float)(a.getLeft() + 1), (float)(a.getBottom() + 1), (float)(a.getRight() - 1), (float)this.pageHeight);
            tmpRelations = this.findRelations(a, selector, 0);
            this.processRelations(tmpRelations, relations, true);
            int edge = a.getLeft() > 0 ? a.getLeft() - 1 : 0;
            selector = new Rectangle(0.0f, (float)(a.getTop() + 1), (float)edge, (float)(a.getBottom() - 1));
            tmpRelations = this.findRelations(a, selector, 1);
            this.processRelations(tmpRelations, relations, false);
            edge = a.getTop() > 0 ? a.getTop() - 1 : 0;
            selector = new Rectangle((float)(a.getLeft() + 1), 0.0f, (float)(a.getRight() - 1), (float)edge);
            tmpRelations = this.findRelations(a, selector, 0);
            this.processRelations(tmpRelations, relations, false);
        }
        for (PageArea area : areas) {
            area.calculateNeighborDistances();
        }
        for (PageAreaRelation rel : relations) {
            a = rel.getA();
            PageArea b = rel.getB();
            rel.setAlignmentScore(rel.computeAlignmentScore());
            double similarity = a.getSimilarity(b, rel.getAlignmentScore());
            rel.setSimilarity(similarity);
        }
        Collections.sort(relations, new RelationComparator());
        return relations;
    }

    private ArrayList<PageAreaRelation> findRelations(PageArea area, Rectangle selector, int direction) {
        ArrayList<PageAreaRelation> tmpRelations = new ArrayList<PageAreaRelation>();
        AreaMatch match = new AreaMatch();
        this.areaTree.intersects(selector, (TIntProcedure)match);
        for (Integer index : match.getIds()) {
            PageArea b = this.areas.get(index);
            if (area == b) continue;
            PageAreaRelation rel = new PageAreaRelation(area, b, 1.0, direction);
            rel.setAbsoluteDistance(area.getDistanceAbsolute(b));
            tmpRelations.add(rel);
        }
        return tmpRelations;
    }

    private void processRelations(ArrayList<PageAreaRelation> batch, ArrayList<PageAreaRelation> all, boolean append) {
        if (batch.size() > 0) {
            Collections.sort(batch, new AreaProximityComparator());
            double distMark = batch.get(0).getAbsoluteDistance();
            for (PageAreaRelation r : batch) {
                if (!((double)r.getAbsoluteDistance() <= distMark)) break;
                r.getA().addNeighbor(r);
                if (!append) continue;
                all.add(r);
            }
            batch.clear();
        }
    }

    public List<PageArea> getUngrouped() {
        return this.ungrouped;
    }
}

