/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.bcs.impl;

import cz.vutbr.fit.layout.model.Color;
import java.awt.image.BufferedImage;

public class AverageColor {
    private Color color;
    private float coloredPortion;

    public AverageColor(Color c, float p) {
        this.color = c;
        this.coloredPortion = p;
    }

    public AverageColor(BufferedImage im) {
        long rSum = 0L;
        long gSum = 0L;
        long bSum = 0L;
        int totalCount = 0;
        int count = 0;
        if (im == null) {
            this.color = null;
            this.coloredPortion = 0.0f;
            return;
        }
        for (int y = 0; y < im.getHeight(); ++y) {
            for (int x = 0; x < im.getWidth(); ++x) {
                ++totalCount;
                int rgb = im.getRGB(x, y);
                int alpha = (rgb & 0xFF000000) >> 24;
                if (alpha == 0) continue;
                rSum += (long)((rgb & 0xFF0000) >> 16);
                gSum += (long)((rgb & 0xFF00) >> 8);
                bSum += (long)(rgb & 0xFF);
                ++count;
            }
        }
        if (count == 0) {
            this.color = null;
            this.coloredPortion = 0.0f;
            return;
        }
        this.color = new Color((int)(rSum /= (long)count), (int)(gSum /= (long)count), (int)(bSum /= (long)count), 255);
        this.coloredPortion = (float)count / (float)totalCount;
    }

    public Color mixWithBackground(Color bg) {
        int r = 0;
        int g = 0;
        int b = 0;
        float fgPart = this.coloredPortion;
        float bgPart = 1.0f - fgPart;
        if (bg == null) {
            return new Color(this.color.getRGB());
        }
        r = (int)((float)this.color.getRed() * fgPart + (float)bg.getRed() * bgPart);
        g = (int)((float)this.color.getGreen() * fgPart + (float)bg.getGreen() * bgPart);
        b = (int)((float)this.color.getBlue() * fgPart + (float)bg.getBlue() * bgPart);
        return new Color(r, g, b);
    }

    public Color getColor() {
        return this.color;
    }

    public float getColoredPortion() {
        return this.coloredPortion;
    }
}

