/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.bcs.impl;

import cz.vutbr.fit.layout.bcs.impl.PageArea;
import cz.vutbr.fit.layout.bcs.impl.PatternElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Pattern {
    private final PageArea area;
    private int consistency;
    public static final int CONSISTENCY_HIGH = 0;
    public static final int CONSISTENCY_MEDIUM = 1;
    public static final int CONSISTENCY_LOW = 2;
    public static final int CONSISTENCY_NONE = 3;
    public static final int ALIGNMENT_NONE = 0;
    public static final int ALIGNMENT_TOP = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_BOTTOM = 3;
    public static final int ALIGNMENT_LEFT = 4;
    private HashSet<PageArea> aligned;
    private HashSet<PageArea> unaligned;

    public Pattern(PageArea a) {
        this.area = a;
    }

    public int calculateConsistency() {
        boolean consistency = false;
        int alignment = 0;
        PageArea firstChild = null;
        List<PageArea> children = this.area.getChildren();
        if (children == null) {
            return 3;
        }
        for (PageArea child : children) {
            if (firstChild == null) {
                firstChild = child;
                continue;
            }
            int newAlignment = this.getAlignment(firstChild, child);
            if (alignment == 0) {
                alignment = newAlignment;
            }
            if (newAlignment != 0 && alignment == newAlignment) continue;
            consistency = true;
            break;
        }
        if (!consistency) {
            return 0;
        }
        alignment = this.findAlignment(children);
        PatternElement el = new PatternElement();
        el.setAlignment(PatternElement.transformAlignment(alignment));
        for (PageArea a : this.aligned) {
            el.addArea(a);
        }
        this.filterContained(el);
        return 3;
    }

    private int getAlignment(PageArea a, PageArea b) {
        if (a.getTop() == b.getTop()) {
            return 1;
        }
        if (a.getRight() == b.getRight()) {
            return 2;
        }
        if (a.getBottom() == b.getBottom()) {
            return 3;
        }
        if (a.getLeft() == b.getLeft()) {
            return 4;
        }
        return 0;
    }

    private int findAlignment(List<PageArea> areas) {
        int bestAlignment = 0;
        HashSet bestAlignedSet = new HashSet();
        HashSet<PageArea> alignedSet = new HashSet<PageArea>();
        HashSet<PageArea> unAlignedSet = new HashSet<PageArea>();
        int i = 0;
        for (PageArea a : areas) {
            PageArea area = null;
            int alignment = 0;
            for (int j = i + 1; j < areas.size(); ++j) {
                area = areas.get(j);
                alignment = this.getAlignment(a, area);
                if (alignment == 0) continue;
                alignedSet.clear();
                alignedSet.add(a);
                alignedSet.add(area);
                for (int k = j + 1; k < areas.size(); ++k) {
                    int tmpAlignment;
                    PageArea tmpArea = areas.get(k);
                    if (tmpArea == a || tmpArea == area || (tmpAlignment = this.getAlignment(a, tmpArea)) != alignment) continue;
                    alignedSet.add(tmpArea);
                }
                if (alignedSet.size() <= bestAlignedSet.size()) continue;
                bestAlignment = alignment;
                bestAlignedSet = alignedSet;
                alignedSet = new HashSet();
            }
            ++i;
        }
        if (bestAlignment != 0) {
            for (PageArea a : areas) {
                if (bestAlignedSet.contains(a)) continue;
                unAlignedSet.add(a);
            }
        }
        this.aligned = bestAlignedSet;
        this.unaligned = unAlignedSet;
        return bestAlignment;
    }

    public void filterContained(PatternElement el) {
        ArrayList<PageArea> deleteList = new ArrayList<PageArea>();
        HashSet<PageArea> nextScan = new HashSet<PageArea>();
        for (PageArea a : this.unaligned) {
            if (!el.contains(a) || deleteList.contains(a)) continue;
            PatternElement subEl = null;
            for (PageArea elArea : el.getAreas()) {
                int patAlignment;
                int alignment = this.getAlignment(a, elArea);
                if (alignment == 0 || (patAlignment = PatternElement.transformAlignment(alignment)) == el.getAlignment()) continue;
                el.delArea(elArea);
                subEl = new PatternElement();
                subEl.addArea(elArea);
                subEl.addArea(a);
                deleteList.add(a);
                el.addSubpattern(subEl);
                for (PageArea tmpArea : this.unaligned) {
                    if (el.contains(tmpArea) && !deleteList.contains(tmpArea) || PatternElement.transformAlignment(alignment = this.getAlignment(tmpArea, a)) != patAlignment) continue;
                    subEl.addArea(tmpArea);
                    deleteList.add(tmpArea);
                }
            }
            if (subEl != null) continue;
            nextScan.add(a);
        }
        for (PageArea a : deleteList) {
            this.unaligned.remove(a);
        }
        if (nextScan.size() > 0) {
            // empty if block
        }
    }

    public Pattern getUpdatedPattern(PageArea newChild) {
        List<PageArea> children = this.area.getChildren();
        if (children == null || children.size() == 0) {
            return null;
        }
        return null;
    }

    public int getConsistency() {
        return this.consistency;
    }
}

