/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.cormier;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.cormier.impl.CormierSegmentation;
import cz.vutbr.fit.layout.cormier.impl.EdgeDetector;
import cz.vutbr.fit.layout.cormier.impl.LineDetector;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.impl.ParameterFloat;
import cz.vutbr.fit.layout.impl.ParameterInt;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.SEGM;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CormierProvider
extends BaseArtifactService {
    private static final Logger logger = LoggerFactory.getLogger(CormierProvider.class);
    int halfWindowWidth = 45;
    float standardDeviation = 0.1f;
    float priorEdgeProbability = 0.01f;
    int pyramidLevels = 1;
    int maxLineLength = 256;
    float edgeProbabilityThreshold = 0.3f;
    int monteCarloTrials = 100;
    int minSegmentLength = 45;
    float signLineProbThreshold = 0.5f;

    public String getId() {
        return "FitLayout.Cormier";
    }

    public String getName() {
        return "Cormier et al.";
    }

    public String getDescription() {
        return "Cormier: Purely visual segmentation algorithm";
    }

    public List<Parameter> defineParams() {
        return Arrays.stream(CormierParameter.values()).map(cormierParameter -> cormierParameter.data).collect(Collectors.toList());
    }

    public int getHalfWindowWidth() {
        return this.halfWindowWidth;
    }

    public void setHalfWindowWidth(int halfWindowWidth) {
        this.halfWindowWidth = halfWindowWidth;
    }

    public float getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(float standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    public float getPriorEdgeProbability() {
        return this.priorEdgeProbability;
    }

    public void setPriorEdgeProbability(float priorEdgeProbability) {
        this.priorEdgeProbability = priorEdgeProbability;
    }

    public int getPyramidLevels() {
        return this.pyramidLevels;
    }

    public void setPyramidLevels(int pyramidLevels) {
        this.pyramidLevels = pyramidLevels;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    public float getEdgeProbabilityThreshold() {
        return this.edgeProbabilityThreshold;
    }

    public void setEdgeProbabilityThreshold(float edgeProbabilityThreshold) {
        this.edgeProbabilityThreshold = edgeProbabilityThreshold;
    }

    public int getMonteCarloTrials() {
        return this.monteCarloTrials;
    }

    public void setMonteCarloTrials(int monteCarloTrials) {
        this.monteCarloTrials = monteCarloTrials;
    }

    public int getMinSegmentLength() {
        return this.minSegmentLength;
    }

    public void setMinSegmentLength(int minSegmentLength) {
        this.minSegmentLength = minSegmentLength;
    }

    public float getSignLineProbThreshold() {
        return this.signLineProbThreshold;
    }

    public void setSignLineProbThreshold(float signLineProbThreshold) {
        this.signLineProbThreshold = signLineProbThreshold;
    }

    public IRI getConsumes() {
        return BOX.Page;
    }

    public IRI getProduces() {
        return SEGM.AreaTree;
    }

    public Artifact process(Artifact input) throws ServiceException {
        AreaTree atree;
        if (!(input instanceof Page)) {
            throw new ServiceException("Source artifact not specified or not a page.");
        }
        try {
            atree = this.createAreaTree((Page)input);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to process the screenshot of the source page.", (Throwable)e);
        }
        IRI atreeIri = this.getServiceManager().getArtifactRepository().createArtifactIri((Artifact)atree);
        atree.setIri(atreeIri);
        return atree;
    }

    public AreaTree createAreaTree(Page page) throws IOException {
        return this.createAreaTree(page.getPngImage(), page.getIri());
    }

    public AreaTree createAreaTree(byte[] imageData, IRI iri) throws IOException {
        for (CormierParameter param : CormierParameter.values()) {
            logger.debug("Parameter {} = {}", (Object)param.data.getName(), this.getParam(param.data.getName()));
        }
        return new CormierSegmentation(new EdgeDetector((Integer)this.getParam(CormierParameter.HALF_WINDOW_WIDTH.data.getName()), ((Float)this.getParam(CormierParameter.STANDARD_DEVIATION.data.getName())).floatValue(), ((Float)this.getParam(CormierParameter.PRIOR_EDGE_PROBABILITY.data.getName())).floatValue(), (Integer)this.getParam(CormierParameter.PYRAMID_LEVELS.data.getName())), new LineDetector((Integer)this.getParam(CormierParameter.MAX_LINE_LENGTH.data.getName()), ((Float)this.getParam(CormierParameter.EDGE_PROBABILITY_THRESHOLD.data.getName())).floatValue(), (Integer)this.getParam(CormierParameter.MONTE_CARLO_TRIALS.data.getName())), (Integer)this.getParam(CormierParameter.MIN_SEGMENT_LENGTH.data.getName()), ((Float)this.getParam(CormierParameter.SIGN_LINE_PROB_THRESHOLD.data.getName())).floatValue()).run(imageData, iri);
    }

    public static enum CormierParameter {
        HALF_WINDOW_WIDTH((Parameter)new ParameterInt("halfWindowWidth", "Controls the size of the neighborhood (in number of pixels from the center pixel). Higher values dramatically impact performance.", 0, 1000)),
        STANDARD_DEVIATION((Parameter)new ParameterFloat("standardDeviation", "Standard deviation for the normal distribution used in kernel density estimation for determining the probability of an edge in each pixel.", 0.0f, 1000.0f)),
        PRIOR_EDGE_PROBABILITY((Parameter)new ParameterFloat("priorEdgeProbability", "Prior probability of an edge in each pixel.", 0.0f, 1.0f)),
        PYRAMID_LEVELS((Parameter)new ParameterInt("pyramidLevels", "Number of levels for the Gaussian pyramid used for the multiscale edge detection. Set to 1 to effectively turn off the multiscale edge detection.", 1, 10)),
        MAX_LINE_LENGTH((Parameter)new ParameterInt("maxLineLength", "Maximum length of a segmentation line (in pixels) before the algorithm splits it in half and processes each half separately.", 1, 1000)),
        EDGE_PROBABILITY_THRESHOLD((Parameter)new ParameterFloat("edgeProbabilityThreshold", "Minimum probability of an edge in each pixel required in order for it to be considered significant.", 0.0f, 1.0f)),
        MONTE_CARLO_TRIALS((Parameter)new ParameterInt("monteCarloTrials", "Number of Monte Carlo trials for determining the probability that line is semantically significant.", 1, 5000)),
        MIN_SEGMENT_LENGTH((Parameter)new ParameterInt("minSegmentLength", "Minimum length of any side of each segment.", 0, 1000)),
        SIGN_LINE_PROB_THRESHOLD((Parameter)new ParameterFloat("signLineProbThreshold", "Minimum probability that line is significant for it to be used for segmentation.", 0.0f, 1.0f));

        public final Parameter data;

        private CormierParameter(Parameter data) {
            this.data = data;
        }
    }
}

