/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.cormier.impl;

import cz.vutbr.fit.layout.cormier.impl.EdgeDetector;
import cz.vutbr.fit.layout.cormier.impl.LineDetector;
import cz.vutbr.fit.layout.cormier.impl.Utils;
import cz.vutbr.fit.layout.impl.DefaultArea;
import cz.vutbr.fit.layout.impl.DefaultAreaTree;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.model.Rectangular;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import javax.imageio.ImageIO;
import org.eclipse.rdf4j.model.IRI;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CormierSegmentation {
    private static final Logger logger = LoggerFactory.getLogger(CormierSegmentation.class);
    private EdgeDetector edgeDetector;
    private LineDetector lineDetector;
    private int minSegmentLength;
    private float signLineProbThreshold;
    private boolean parallelEnabled = true;
    private static final ForkJoinPool segmentPool = new ForkJoinPool();

    public CormierSegmentation(EdgeDetector edgeDetector, LineDetector lineDetector, int minSegmentLength, float signLineProbThreshold) {
        this.edgeDetector = edgeDetector;
        this.lineDetector = lineDetector;
        this.minSegmentLength = minSegmentLength;
        this.signLineProbThreshold = signLineProbThreshold;
    }

    public CormierSegmentation(EdgeDetector edgeDetector, LineDetector lineDetector, int minSegmentLength, float signLineProbThreshold, boolean parallelEnabled) {
        this.edgeDetector = edgeDetector;
        this.lineDetector = lineDetector;
        this.minSegmentLength = minSegmentLength;
        this.signLineProbThreshold = signLineProbThreshold;
        this.parallelEnabled = parallelEnabled;
    }

    public EdgeDetector getEdgeDetector() {
        return this.edgeDetector;
    }

    public void setEdgeDetector(EdgeDetector edgeDetector) {
        this.edgeDetector = edgeDetector;
    }

    public LineDetector getLineDetector() {
        return this.lineDetector;
    }

    public void setLineDetector(LineDetector lineDetector) {
        this.lineDetector = lineDetector;
    }

    public int getMinSegmentLength() {
        return this.minSegmentLength;
    }

    public void setMinSegmentLength(int minSegmentLength) {
        this.minSegmentLength = minSegmentLength;
    }

    public float getSignLineProbThreshold() {
        return this.signLineProbThreshold;
    }

    public void setSignLineProbThreshold(float signLineProbThreshold) {
        this.signLineProbThreshold = signLineProbThreshold;
    }

    public AreaTree run(Page page) throws IOException {
        return this.run(page.getPngImage(), page.getIri());
    }

    public AreaTree run(byte[] imageData, IRI iri) throws IOException {
        ByteArrayInputStream imageStream = new ByteArrayInputStream(imageData);
        BufferedImage image = ImageIO.read(imageStream);
        Pair<double[][], double[][]> edgeProbs = this.getEdgeDetector().getEdgeProbabilities(imageData);
        DefaultArea root = new DefaultArea(new Rectangular(0, 0, image.getWidth(), image.getHeight()));
        DefaultAreaTree atree = new DefaultAreaTree(iri);
        atree.setParentIri(iri);
        long startTime = System.currentTimeMillis();
        logger.debug("Creating segmentation tree...");
        atree.setRoot(this.segment((Area)root, this.split((Area)root, edgeProbs), edgeProbs));
        logger.debug("Segmentation tree created in {} seconds.", (Object)String.format("%.2f", (double)(System.currentTimeMillis() - startTime) / 1000.0));
        return atree;
    }

    private Area segment(Area rootSegment, Pair<List<Area>, SegmDirection> initialSplit, Pair<double[][], double[][]> edgeProbabilities) {
        return segmentPool.invoke(new SegmentTask(rootSegment, initialSplit, edgeProbabilities));
    }

    private Pair<List<Area>, SegmDirection> split(Area segment, Pair<double[][], double[][]> edgeProbabilities) {
        double maxRowProb = 0.0;
        double maxColProb = 0.0;
        int rowWithMaxProb = 0;
        int colWithMaxProb = 0;
        for (int row2 = segment.getY1() + this.getMinSegmentLength(); row2 < segment.getY2() - this.getMinSegmentLength(); ++row2) {
            double rowProb = this.getLineDetector().lineProbability(Arrays.copyOfRange(((double[][])edgeProbabilities.getValue0())[row2], segment.getX1(), segment.getX2()));
            if (!(rowProb > maxRowProb)) continue;
            maxRowProb = rowProb;
            rowWithMaxProb = row2;
            if (rowProb == 1.0) break;
        }
        for (int col = segment.getX1() + this.getMinSegmentLength(); col < segment.getX2() - this.getMinSegmentLength(); ++col) {
            int colF = col;
            double colProb = this.getLineDetector().lineProbability(Arrays.stream((double[][])Arrays.copyOfRange((double[][])edgeProbabilities.getValue1(), segment.getY1(), segment.getY2())).mapToDouble(row -> row[colF]).toArray());
            if (!(colProb > maxColProb)) continue;
            maxColProb = colProb;
            colWithMaxProb = col;
            if (colProb == 1.0) break;
        }
        if (maxRowProb > (double)this.getSignLineProbThreshold() || maxColProb > (double)this.getSignLineProbThreshold()) {
            SegmDirection direction;
            final Rectangular first = new Rectangular(segment.getBounds());
            final Rectangular second = new Rectangular(segment.getBounds());
            if (maxRowProb > maxColProb) {
                direction = SegmDirection.HORIZONTAL;
                first.setY2(rowWithMaxProb);
                second.setY1(rowWithMaxProb + 1);
            } else {
                direction = SegmDirection.VERTICAL;
                first.setX2(colWithMaxProb);
                second.setX1(colWithMaxProb + 1);
            }
            return new Pair((Object)new ArrayList<Area>(){
                {
                    this.add(new DefaultArea(first));
                    this.add(new DefaultArea(second));
                }
            }, (Object)direction);
        }
        return null;
    }

    private class SegmentTask
    extends RecursiveTask<Area> {
        private final Area rootSegment;
        private final Pair<List<Area>, SegmDirection> initialSplit;
        private final Pair<double[][], double[][]> edgeProbabilities;

        public SegmentTask(Area rootSegment, Pair<List<Area>, SegmDirection> initialSplit, Pair<double[][], double[][]> edgeProbabilities) {
            this.rootSegment = rootSegment;
            this.initialSplit = initialSplit;
            this.edgeProbabilities = edgeProbabilities;
        }

        @Override
        protected Area compute() {
            logger.debug("Segmenting node [{},{}];[{},{}] ({}x{} px) at depth level {}.", new Object[]{this.rootSegment.getX1(), this.rootSegment.getY1(), this.rootSegment.getX2(), this.rootSegment.getY2(), this.rootSegment.getX2() - this.rootSegment.getX1(), this.rootSegment.getY2() - this.rootSegment.getY1(), Utils.getDepth(this.rootSegment)});
            if (this.initialSplit == null) {
                logger.debug("Couldn't segment any further (leaf node).");
                return this.rootSegment;
            }
            List toSplit = (List)this.initialSplit.getValue0();
            SegmDirection direction = (SegmDirection)((Object)this.initialSplit.getValue1());
            ListIterator it = toSplit.listIterator();
            ArrayList<SegmentTask> childrenSegm = new ArrayList<SegmentTask>();
            while (it.hasNext()) {
                Area curr = (Area)it.next();
                Pair<List<Area>, SegmDirection> split = CormierSegmentation.this.split(curr, this.edgeProbabilities);
                if (split == null || split.getValue1() != direction) {
                    this.rootSegment.appendChild((GenericTreeNode)curr);
                    childrenSegm.add(new SegmentTask(curr, split, this.edgeProbabilities));
                    continue;
                }
                ((List)split.getValue0()).forEach(it::add);
                for (Area ignored : (List)split.getValue0()) {
                    it.previous();
                }
            }
            if (CormierSegmentation.this.parallelEnabled) {
                SegmentTask.invokeAll(childrenSegm);
            } else {
                for (SegmentTask task : childrenSegm) {
                    task.invoke();
                }
            }
            return this.rootSegment;
        }
    }

    static enum SegmDirection {
        HORIZONTAL,
        VERTICAL;

    }
}

