/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.cormier.impl;

import cz.vutbr.fit.layout.model.Rectangular;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import nu.pattern.OpenCV;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.javatuples.Pair;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.Size;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeDetector {
    private static final Logger logger;
    private int halfWindowWidth;
    private float standardDeviation;
    private float priorProbability;
    private int pyramidLevels;
    private boolean ndPregenEnabled = true;
    private boolean parallelEnabled = true;

    public EdgeDetector(int halfWindowWidth, float standardDeviation, float priorProbability, int pyramidLevels) {
        this.halfWindowWidth = halfWindowWidth;
        this.standardDeviation = standardDeviation;
        this.priorProbability = priorProbability;
        this.pyramidLevels = pyramidLevels;
    }

    public EdgeDetector(int halfWindowWidth, float standardDeviation, float priorProbability, int pyramidLevels, boolean ndPregenEnabled, boolean parallelEnabled) {
        this.halfWindowWidth = halfWindowWidth;
        this.standardDeviation = standardDeviation;
        this.priorProbability = priorProbability;
        this.pyramidLevels = pyramidLevels;
        this.ndPregenEnabled = ndPregenEnabled;
        this.parallelEnabled = parallelEnabled;
    }

    public int getHalfWindowWidth() {
        return this.halfWindowWidth;
    }

    public void setHalfWindowWidth(int halfWindowWidth) {
        this.halfWindowWidth = halfWindowWidth;
    }

    public float getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(float standardDeviation) {
        this.standardDeviation = standardDeviation;
    }

    public float getPriorProbability() {
        return this.priorProbability;
    }

    public void setPriorProbability(float priorProbability) {
        this.priorProbability = priorProbability;
    }

    public int getPyramidLevels() {
        return this.pyramidLevels;
    }

    public void setPyramidLevels(int pyramidLevels) {
        this.pyramidLevels = pyramidLevels;
    }

    public Pair<double[][], double[][]> getEdgeProbabilities(byte[] imageData) {
        return this.getEdgeProbabilities(Imgcodecs.imdecode((Mat)new MatOfByte(imageData), (int)1));
    }

    public Pair<double[][], double[][]> getEdgeProbabilities(Mat image) {
        Mat greyscaleImage = EdgeDetector.toGreyscale(image);
        Pair<Mat, Mat> sobel = this.multiscaleSobel(greyscaleImage);
        return this.edgeProbabilities((Mat)sobel.getValue0(), (Mat)sobel.getValue1());
    }

    private static Mat toGreyscale(Mat image) {
        Mat greyscaleImage = new Mat();
        Imgproc.cvtColor((Mat)image, (Mat)greyscaleImage, (int)7);
        return greyscaleImage;
    }

    private static Pair<Mat, Mat> sobel(Mat greyscaleImage) {
        Mat hEdges = new Mat();
        Mat vEdges = new Mat();
        Imgproc.Sobel((Mat)greyscaleImage, (Mat)hEdges, (int)3, (int)0, (int)1, (int)3);
        Imgproc.Sobel((Mat)greyscaleImage, (Mat)vEdges, (int)3, (int)1, (int)0, (int)3);
        return new Pair((Object)hEdges, (Object)vEdges);
    }

    public Pair<Mat, Mat> multiscaleSobel(Mat greyscaleImage) {
        if (this.getPyramidLevels() == 1) {
            return EdgeDetector.sobel(greyscaleImage);
        }
        Mat[] pyramid = new Mat[this.getPyramidLevels()];
        Mat hEdges = Mat.zeros((Size)greyscaleImage.size(), (int)5);
        Mat vEdges = Mat.zeros((Size)greyscaleImage.size(), (int)5);
        for (int i = 0; i < this.getPyramidLevels(); ++i) {
            if (i > 0) {
                Mat currentLevel = new Mat();
                Imgproc.pyrDown((Mat)pyramid[i - 1], (Mat)currentLevel);
                pyramid[i] = currentLevel;
            } else {
                pyramid[i] = greyscaleImage.clone();
            }
            Pair<Mat, Mat> edges = EdgeDetector.sobel(pyramid[i]);
            ((Mat)edges.getValue0()).convertTo((Mat)edges.getValue0(), 5);
            ((Mat)edges.getValue1()).convertTo((Mat)edges.getValue1(), 5);
            Core.multiply((Mat)((Mat)edges.getValue0()), (Mat)((Mat)edges.getValue0()), (Mat)((Mat)edges.getValue0()));
            Core.multiply((Mat)((Mat)edges.getValue1()), (Mat)((Mat)edges.getValue1()), (Mat)((Mat)edges.getValue1()));
            if (i > 0) {
                Imgproc.resize((Mat)((Mat)edges.getValue0()), (Mat)((Mat)edges.getValue0()), (Size)greyscaleImage.size());
                Imgproc.resize((Mat)((Mat)edges.getValue1()), (Mat)((Mat)edges.getValue1()), (Size)greyscaleImage.size());
            }
            Core.add((Mat)hEdges, (Mat)((Mat)edges.getValue0()), (Mat)hEdges);
            Core.add((Mat)vEdges, (Mat)((Mat)edges.getValue1()), (Mat)vEdges);
        }
        Core.sqrt((Mat)hEdges, (Mat)hEdges);
        Core.sqrt((Mat)vEdges, (Mat)vEdges);
        return new Pair((Object)hEdges, (Object)vEdges);
    }

    private Pair<double[][], double[][]> edgeProbabilities(Mat hEdges, Mat vEdges) {
        long totalStartTime = System.currentTimeMillis();
        int height = hEdges.rows();
        int width = hEdges.cols();
        double[][] hEdgeProbability = new double[height][width];
        double[][] vEdgeProbability = new double[height][width];
        logger.debug("Culculating edge probabilities in each pixel in an image made of {} pixels ({}x{}),", new Object[]{width * height, width, height});
        Core.convertScaleAbs((Mat)hEdges, (Mat)hEdges);
        Core.convertScaleAbs((Mat)vEdges, (Mat)vEdges);
        NormalDistribution[][] hNormalDistributions = new NormalDistribution[height][width];
        NormalDistribution[][] vNormalDistributions = new NormalDistribution[height][width];
        if (this.ndPregenEnabled) {
            logger.debug("Pre-generating normal distributions...");
            for (int row2 = 0; row2 < height; ++row2) {
                for (int col = 0; col < width; ++col) {
                    hNormalDistributions[row2][col] = new NormalDistribution(null, hEdges.get(row2, col)[0], (double)this.getStandardDeviation());
                    vNormalDistributions[row2][col] = new NormalDistribution(null, vEdges.get(row2, col)[0], (double)this.getStandardDeviation());
                }
            }
        }
        logger.debug("Calculating probabilities...");
        long startTime = System.currentTimeMillis();
        AtomicInteger rowsDoneA = new AtomicInteger(0);
        IntStream rowRange = IntStream.range(0, height);
        if (this.parallelEnabled) {
            rowRange = rowRange.parallel();
        }
        rowRange.forEach(row -> {
            for (int col = 0; col < width; ++col) {
                Rectangular topNeighborhood = new Rectangular(Math.max(col - this.getHalfWindowWidth(), 0), Math.max(row - this.getHalfWindowWidth(), 0), Math.min(col + this.getHalfWindowWidth() + 1, width), row);
                Rectangular bottomNeighborhood = new Rectangular(Math.max(col - this.getHalfWindowWidth(), 0), row + 1, Math.min(col + this.getHalfWindowWidth() + 1, width), Math.min(row + this.getHalfWindowWidth() + 1, height));
                Rectangular leftNeighborhood = new Rectangular(Math.max(col - this.getHalfWindowWidth(), 0), Math.max(row - this.getHalfWindowWidth(), 0), col, Math.min(row + this.getHalfWindowWidth() + 1, height));
                Rectangular rightNeighborhood = new Rectangular(col + 1, Math.max(row - this.getHalfWindowWidth(), 0), Math.min(col + this.getHalfWindowWidth() + 1, width), Math.min(row + this.getHalfWindowWidth() + 1, height));
                if (this.ndPregenEnabled) {
                    hEdgeProbability[row][col] = this.edgeProbability(this.relativeEdgeStrength(hEdges.get(row, col)[0], topNeighborhood, hNormalDistributions), this.relativeEdgeStrength(hEdges.get(row, col)[0], bottomNeighborhood, hNormalDistributions));
                    vEdgeProbability[row][col] = this.edgeProbability(this.relativeEdgeStrength(vEdges.get(row, col)[0], leftNeighborhood, vNormalDistributions), this.relativeEdgeStrength(vEdges.get(row, col)[0], rightNeighborhood, vNormalDistributions));
                    continue;
                }
                hEdgeProbability[row][col] = this.edgeProbability(this.relativeEdgeStrength(hEdges.get(row, col)[0], topNeighborhood, hEdges), this.relativeEdgeStrength(hEdges.get(row, col)[0], bottomNeighborhood, hEdges));
                vEdgeProbability[row][col] = this.edgeProbability(this.relativeEdgeStrength(vEdges.get(row, col)[0], leftNeighborhood, vEdges), this.relativeEdgeStrength(vEdges.get(row, col)[0], rightNeighborhood, vEdges));
            }
            int rowsDone = rowsDoneA.incrementAndGet();
            if (rowsDone % (height / 100) == 0) {
                long totalTime = System.currentTimeMillis() - startTime;
                double avgTimePerRow = (double)totalTime / (double)rowsDone;
                double timeRemaining = (double)(height - rowsDone) * avgTimePerRow;
                logger.debug("{}% of the image processed ({}/{} rows), total time: {} s, estimated time remaining: {} s", new Object[]{String.format("%.0f", Math.ceil((double)rowsDone / (double)height * 100.0)), rowsDone, height, String.format("%.2f", (double)totalTime / 1000.0), String.format("%.2f", timeRemaining / 1000.0)});
            }
        });
        logger.debug("Edge probablities calculated in {} seconds.", (Object)String.format("%.2f", (double)(System.currentTimeMillis() - totalStartTime) / 1000.0));
        return new Pair((Object)hEdgeProbability, (Object)vEdgeProbability);
    }

    private double relativeEdgeStrength(double targetPixelValue, Rectangular neighborhood, Mat edges) {
        double sum = 0.5;
        for (int row = neighborhood.getY1(); row < neighborhood.getY2(); ++row) {
            for (int col = neighborhood.getX1(); col < neighborhood.getX2(); ++col) {
                sum += new NormalDistribution(null, edges.get(row, col)[0], (double)this.getStandardDeviation()).cumulativeProbability(targetPixelValue);
            }
        }
        return 1.0 - sum / (double)((neighborhood.getX2() - neighborhood.getX1()) * (neighborhood.getY2() - neighborhood.getY1()) + 1);
    }

    private double relativeEdgeStrength(double targetPixelValue, Rectangular neighborhood, NormalDistribution[][] normalDistributions) {
        double sum = 0.5;
        for (int row = neighborhood.getY1(); row < neighborhood.getY2(); ++row) {
            for (int col = neighborhood.getX1(); col < neighborhood.getX2(); ++col) {
                sum += normalDistributions[row][col].cumulativeProbability(targetPixelValue);
            }
        }
        return 1.0 - sum / (double)((neighborhood.getX2() - neighborhood.getX1()) * (neighborhood.getY2() - neighborhood.getY1()) + 1);
    }

    private double edgeProbability(double edgeStrength, double edgeStrength2) {
        double edgeProbability = (double)this.getPriorProbability() * (1.0 + edgeStrength - (double)this.getPriorProbability() * edgeStrength) / ((double)this.getPriorProbability() + edgeStrength - (double)this.getPriorProbability() * edgeStrength);
        double edgeProbability2 = (double)this.getPriorProbability() * (1.0 + edgeStrength2 - (double)this.getPriorProbability() * edgeStrength2) / ((double)this.getPriorProbability() + edgeStrength2 - (double)this.getPriorProbability() * edgeStrength2);
        return edgeProbability + edgeProbability2 - edgeProbability * edgeProbability2;
    }

    static {
        OpenCV.loadLocally();
        logger = LoggerFactory.getLogger(EdgeDetector.class);
    }
}

