/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.cormier.impl;

import java.util.Arrays;
import java.util.Random;

public class LineDetector {
    private int maxLineLength;
    private float edgeProbabilityThreshold;
    private int monteCarloTrials;

    public LineDetector(int maxLineLength, float edgeProbabilityThreshold, int monteCarloTrials) {
        this.maxLineLength = maxLineLength;
        this.edgeProbabilityThreshold = edgeProbabilityThreshold;
        this.monteCarloTrials = monteCarloTrials;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    public float getEdgeProbabilityThreshold() {
        return this.edgeProbabilityThreshold;
    }

    public void setEdgeProbabilityThreshold(float edgeProbabilityThreshold) {
        this.edgeProbabilityThreshold = edgeProbabilityThreshold;
    }

    public int getMonteCarloTrials() {
        return this.monteCarloTrials;
    }

    public void setMonteCarloTrials(int monteCarloTrials) {
        this.monteCarloTrials = monteCarloTrials;
    }

    public float lineProbability(double[] edgeProbabilities) {
        int length = edgeProbabilities.length;
        if (length > this.getMaxLineLength()) {
            return this.lineProbability(Arrays.copyOfRange(edgeProbabilities, 0, length / 2)) * this.lineProbability(Arrays.copyOfRange(edgeProbabilities, length / 2 + 1, length - 1));
        }
        Random rng = new Random();
        int successCount = 0;
        for (int i = 0; i < this.getMonteCarloTrials(); ++i) {
            long significantPixels = Arrays.stream(edgeProbabilities).filter(prob -> prob > (double)rng.nextFloat()).count();
            if (!((float)significantPixels / (float)length >= this.getEdgeProbabilityThreshold())) continue;
            ++successCount;
        }
        return (float)successCount / (float)this.getMonteCarloTrials();
    }
}

