/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.vips;

import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.impl.DefaultAreaTree;
import cz.vutbr.fit.layout.impl.ParameterInt;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.vips.impl.Vips;
import cz.vutbr.fit.layout.vips.impl.VipsTreeBuilder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;

public class VipsProvider
extends BaseArtifactService {
    private int pDoC = 10;

    public String getId() {
        return "FitLayout.VIPS";
    }

    public String getName() {
        return "VIPS";
    }

    public String getDescription() {
        return "VIPS: a VIsion based Page Segmentation Algorithm";
    }

    public List<Parameter> defineParams() {
        ArrayList<Parameter> ret = new ArrayList<Parameter>(1);
        ret.add((Parameter)new ParameterInt("pDoC", 1, 11));
        return ret;
    }

    public IRI getConsumes() {
        return BOX.Page;
    }

    public IRI getProduces() {
        return SEGM.AreaTree;
    }

    public Artifact process(Artifact input) throws ServiceException {
        if (input != null && input instanceof Page) {
            AreaTree atree = this.createAreaTree((Page)input);
            IRI atreeIri = this.getServiceManager().getArtifactRepository().createArtifactIri((Artifact)atree);
            atree.setIri(atreeIri);
            return atree;
        }
        throw new ServiceException("Source artifact not specified or not a page");
    }

    public int getPDoC() {
        return this.pDoC;
    }

    public void setPDoC(int pDoC) {
        this.pDoC = pDoC;
    }

    public AreaTree createAreaTree(Page page) {
        DefaultAreaTree atree = new DefaultAreaTree(page.getIri());
        atree.setParentIri(page.getIri());
        atree.setLabel(this.getId());
        atree.setCreator(this.getId());
        atree.setCreatorParams(this.getParamString());
        boolean graphOutput = System.getProperty("fitlayout.vips.debug") != null;
        Vips vips = new Vips();
        vips.enableGraphicsOutput(graphOutput);
        vips.enableOutputToFolder(false);
        vips.setPredefinedDoC(this.pDoC);
        vips.startSegmentation(page);
        VipsTreeBuilder builder = vips.getTreeBuilder();
        Area root = builder.buildAreaTree((AreaTree)atree, vips.getVisualStructure());
        atree.setRoot(root);
        return atree;
    }
}

