/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.vips.impl;

import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.vips.impl.VisualArea;
import cz.vutbr.fit.layout.vips.impl.VisualBlock;
import java.util.ArrayList;
import java.util.List;

public class VisualBlockDetector {
    private VisualArea rootArea;
    private int sizeTresholdWidth = 0;
    private int sizeTresholdHeight = 0;

    public VisualBlockDetector(VisualArea rootArea) {
        this.rootArea = rootArea;
        this.sizeTresholdHeight = 80;
        this.sizeTresholdWidth = 80;
    }

    public VisualBlockDetector(VisualArea rootArea, int sizeTresholdWidth, int sizeTresholdHeight) {
        this(rootArea);
        this.sizeTresholdHeight = sizeTresholdHeight;
        this.sizeTresholdWidth = sizeTresholdWidth;
    }

    public void parse() {
        for (VisualBlock rootBlock : this.rootArea.getBlockRoots()) {
            rootBlock.reset();
            rootBlock.setRoot(rootBlock);
            this.constructVipsBlockTree(rootBlock);
            this.divideVipsBlockTree(rootBlock);
        }
    }

    private void findVisualBlocks(VisualBlock vipsBlock, List<VisualBlock> list) {
        if (vipsBlock.isVisualBlock()) {
            list.add(vipsBlock);
        }
        for (VisualBlock vipsStructureChild : vipsBlock.getChildren()) {
            this.findVisualBlocks(vipsStructureChild, list);
        }
    }

    public List<VisualBlock> getVisualBlocks() {
        ArrayList<VisualBlock> list = new ArrayList<VisualBlock>();
        for (VisualBlock rootBlock : this.rootArea.getBlockRoots()) {
            this.findVisualBlocks(rootBlock, list);
        }
        return list;
    }

    private void constructVipsBlockTree(VisualBlock rootBlock) {
        Box root = rootBlock.getBox();
        if (root.getType() != Box.Type.TEXT_CONTENT) {
            for (Box child : root.getChildren()) {
                VisualBlock childBlock = new VisualBlock();
                childBlock.setRoot(rootBlock.getRoot());
                childBlock.setBox(child);
                rootBlock.addChild(childBlock);
                this.constructVipsBlockTree(childBlock);
            }
        }
    }

    private void divideVipsBlockTree(VisualBlock block) {
        if (this.applyVipsRules(block) && block.isDividable() && !block.isVisualBlock()) {
            block.setAlreadyDivided(true);
            for (VisualBlock child : block.getChildren()) {
                this.divideVipsBlockTree(child);
            }
        } else if (!this.verifyValidity(block)) {
            block.setIsVisualBlock(false);
        }
    }

    private boolean verifyValidity(VisualBlock block) {
        if (!this.rootArea.getBounds().encloses(block.getBounds())) {
            return false;
        }
        if (block.getBounds().getWidth() <= 0 || block.getBounds().getHeight() <= 0) {
            return false;
        }
        return block.getBox().isVisible();
    }

    private boolean isValidNode(Box node) {
        if (node.getType() == Box.Type.TEXT_CONTENT) {
            return true;
        }
        return node.getHeight() > 0 && node.getWidth() > 0;
    }

    private boolean isTextNode(Box box) {
        return box.getType() == Box.Type.TEXT_CONTENT || box.getType() == Box.Type.REPLACED_CONTENT;
    }

    private boolean isVirtualTextNode1(Box node) {
        if (node.getDisplayType() == Box.DisplayType.BLOCK) {
            return false;
        }
        for (Box childNode : node.getChildren()) {
            if (childNode.getType() == Box.Type.TEXT_CONTENT) continue;
            return false;
        }
        return true;
    }

    private boolean isVirtualTextNode2(Box node) {
        if (node.getDisplayType() == Box.DisplayType.BLOCK) {
            return false;
        }
        for (Box childNode : node.getChildren()) {
            if (this.isTextNode(childNode) && this.isVirtualTextNode1(childNode)) continue;
            return false;
        }
        return true;
    }

    private boolean isVirtualTextNode(Box node) {
        return this.isVirtualTextNode1(node) || this.isVirtualTextNode2(node);
    }

    private int countValidChildNodes(Box node) {
        int ret = 0;
        for (Box childNode : node.getChildren()) {
            if (!this.isValidNode(childNode)) continue;
            ++ret;
        }
        return ret;
    }

    private Box getFirstValidChildNode(Box node) {
        for (Box childNode : node.getChildren()) {
            if (!this.isValidNode(childNode)) continue;
            return childNode;
        }
        return null;
    }

    private boolean hasValidChildNodes(Box node) {
        return this.getFirstValidChildNode(node) != null;
    }

    private boolean applyVipsRules(VisualBlock block) {
        Box node = block.getBox();
        boolean retVal = false;
        retVal = node.getDisplayType() == Box.DisplayType.INLINE ? this.applyInlineTextNodeVipsRules(block) : ("table".equalsIgnoreCase(node.getTagName()) ? this.applyTableNodeVipsRules(block) : ("tr".equalsIgnoreCase(node.getTagName()) ? this.applyTrNodeVipsRules(block) : ("td".equalsIgnoreCase(node.getTagName()) ? this.applyTdNodeVipsRules(block) : ("p".equalsIgnoreCase(node.getTagName()) ? this.applyPNodeVipsRules(block) : this.applyOtherNodeVipsRules(block)))));
        return retVal;
    }

    private boolean applyOtherNodeVipsRules(VisualBlock block) {
        if (this.ruleOne(block)) {
            return true;
        }
        if (this.ruleTwo(block)) {
            return true;
        }
        if (this.ruleThree(block)) {
            return true;
        }
        if (this.ruleFour(block)) {
            return true;
        }
        if (this.ruleSix(block)) {
            return true;
        }
        if (this.ruleEight(block)) {
            return true;
        }
        if (this.ruleNine(block)) {
            return true;
        }
        return this.ruleEleven(block);
    }

    private boolean applyPNodeVipsRules(VisualBlock block) {
        if (this.ruleOne(block)) {
            return true;
        }
        if (this.ruleTwo(block)) {
            return true;
        }
        if (this.ruleThree(block)) {
            return true;
        }
        if (this.ruleFour(block)) {
            return true;
        }
        if (this.ruleFive(block)) {
            return true;
        }
        if (this.ruleSix(block)) {
            return true;
        }
        if (this.ruleSeven(block)) {
            return true;
        }
        if (this.ruleEight(block)) {
            return true;
        }
        if (this.ruleNine(block)) {
            return true;
        }
        if (this.ruleTen(block)) {
            return true;
        }
        if (this.ruleEleven(block)) {
            return true;
        }
        return this.ruleTwelve(block);
    }

    private boolean applyTdNodeVipsRules(VisualBlock block) {
        if (this.ruleOne(block)) {
            return true;
        }
        if (this.ruleTwo(block)) {
            return true;
        }
        if (this.ruleThree(block)) {
            return true;
        }
        if (this.ruleFour(block)) {
            return true;
        }
        if (this.ruleEight(block)) {
            return true;
        }
        if (this.ruleNine(block)) {
            return true;
        }
        if (this.ruleTen(block)) {
            return true;
        }
        return this.ruleTwelve(block);
    }

    private boolean applyTrNodeVipsRules(VisualBlock block) {
        if (this.ruleOne(block)) {
            return true;
        }
        if (this.ruleTwo(block)) {
            return true;
        }
        if (this.ruleThree(block)) {
            return true;
        }
        if (this.ruleSeven(block)) {
            return true;
        }
        if (this.ruleNine(block)) {
            return true;
        }
        return this.ruleTwelve(block);
    }

    private boolean applyTableNodeVipsRules(VisualBlock block) {
        if (this.ruleOne(block)) {
            return true;
        }
        if (this.ruleTwo(block)) {
            return true;
        }
        if (this.ruleThree(block)) {
            return true;
        }
        if (this.ruleSeven(block)) {
            return true;
        }
        if (this.ruleNine(block)) {
            return true;
        }
        return this.ruleTwelve(block);
    }

    private boolean applyInlineTextNodeVipsRules(VisualBlock block) {
        if (this.ruleOne(block)) {
            return true;
        }
        if (this.ruleTwo(block)) {
            return true;
        }
        if (this.ruleThree(block)) {
            return true;
        }
        if (this.ruleFour(block)) {
            return true;
        }
        if (this.ruleFive(block)) {
            return true;
        }
        if (this.ruleSix(block)) {
            return true;
        }
        if (this.ruleEight(block)) {
            return true;
        }
        if (this.ruleNine(block)) {
            return true;
        }
        return this.ruleTwelve(block);
    }

    private boolean ruleOne(VisualBlock block) {
        Box node = block.getBox();
        if (!this.isTextNode(node) && !this.hasValidChildNodes(node)) {
            block.setIsDividable(false);
            return true;
        }
        return false;
    }

    private boolean ruleTwo(VisualBlock block) {
        Box node = block.getBox();
        if (this.countValidChildNodes(node) == 1) {
            Box child = this.getFirstValidChildNode(node);
            return !this.isTextNode(child);
        }
        return false;
    }

    private boolean ruleThree(VisualBlock block) {
        return this.rootArea.getBlockRoots().size() == 1 && this.rootArea.getBlockRoots().get(0) == block;
    }

    private boolean ruleFour(VisualBlock block) {
        Box node = block.getBox();
        if (this.isTextNode(node)) {
            block.setIsVisualBlock(true);
            block.setIsDividable(false);
            block.setDoC(10);
            return true;
        }
        if (node.getChildCount() > 0) {
            for (Box box : node.getChildren()) {
                if (this.isTextNode(box) || this.isVirtualTextNode(box)) continue;
                return false;
            }
            block.setIsVisualBlock(true);
            block.setIsDividable(false);
            float fw = ((Box)node.getChildAt(0)).getTextStyle().getFontWeight();
            float fs = ((Box)node.getChildAt(0)).getTextStyle().getFontSize();
            boolean allEqual = true;
            for (int i = 1; i < node.getChildCount() && allEqual; ++i) {
                float nfw = ((Box)node.getChildAt(i)).getTextStyle().getFontWeight();
                float nfs = ((Box)node.getChildAt(i)).getTextStyle().getFontSize();
                if (!((double)Math.abs(fw - nfw) > 0.01) || !((double)Math.abs(fs - nfs) > 0.01)) continue;
                allEqual = false;
            }
            block.setDoC(allEqual ? 10 : 9);
            return true;
        }
        return false;
    }

    private boolean ruleFive(VisualBlock block) {
        Box node = block.getBox();
        for (Box childNode : node.getChildren()) {
            if (childNode.getDisplayType() == Box.DisplayType.INLINE) continue;
            return true;
        }
        return false;
    }

    private boolean ruleSix(VisualBlock block) {
        Box node = block.getBox();
        for (Box child : node.getChildren()) {
            if (!"hr".equalsIgnoreCase(child.getTagName())) continue;
            return true;
        }
        return false;
    }

    private boolean ruleSeven(VisualBlock block) {
        Box node = block.getBox();
        if (node.getChildren().isEmpty()) {
            return false;
        }
        if (this.isTextNode(node)) {
            return false;
        }
        String nodeBgColor = block.getBgColor();
        for (VisualBlock child : block.getChildren()) {
            if (child.getBgColor().equals(nodeBgColor)) continue;
            child.setIsDividable(false);
            child.setIsVisualBlock(true);
            child.setDoC(7);
            return true;
        }
        return false;
    }

    private boolean ruleEight(VisualBlock block) {
        Box node = block.getBox();
        if (node.getChildCount() > 0) {
            if (node.getWidth() * node.getHeight() < this.sizeTresholdHeight * this.sizeTresholdWidth) {
                boolean hasTextChild = false;
                for (Box child : node.getChildren()) {
                    if (!this.isTextNode(child) && !this.isVirtualTextNode(child)) continue;
                    hasTextChild = true;
                    break;
                }
                if (hasTextChild) {
                    block.setIsVisualBlock(true);
                    block.setIsDividable(false);
                    if ("Xdiv".equalsIgnoreCase(node.getTagName())) {
                        block.setDoC(7);
                    } else if ("code".equalsIgnoreCase(node.getTagName())) {
                        block.setDoC(7);
                    } else if ("div".equalsIgnoreCase(node.getTagName())) {
                        block.setDoC(5);
                    } else {
                        block.setDoC(8);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean ruleNine(VisualBlock block) {
        Box node = block.getBox();
        if (node.getChildCount() > 0) {
            int maxSize = 0;
            for (Box childNode : node.getChildren()) {
                int childSize = childNode.getWidth() * childNode.getHeight();
                if (maxSize >= childSize) continue;
                maxSize = childSize;
            }
            if (maxSize < this.sizeTresholdWidth * this.sizeTresholdHeight) {
                block.setIsVisualBlock(true);
                block.setIsDividable(false);
                if ("XDiv".equalsIgnoreCase(node.getTagName())) {
                    block.setDoC(7);
                }
                if ("a".equalsIgnoreCase(node.getTagName())) {
                    block.setDoC(11);
                } else {
                    block.setDoC(8);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean ruleTen(VisualBlock block) {
        Box node = block.getBox();
        if (node.getPreviousSibling() != null) {
            VisualBlock siblingBlock = this.findBlockForBox((Box)node.getPreviousSibling(), block.getRoot());
            if (siblingBlock != null && siblingBlock.isAlreadyDivided()) {
                block.setIsDividable(true);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean ruleEleven(VisualBlock block) {
        return true;
    }

    private boolean ruleTwelve(VisualBlock block) {
        Box node = block.getBox();
        block.setIsDividable(false);
        block.setIsVisualBlock(true);
        if ("XDiv".equalsIgnoreCase(node.getTagName())) {
            block.setDoC(7);
        } else if ("li".equalsIgnoreCase(node.getTagName())) {
            block.setDoC(8);
        } else if ("span".equalsIgnoreCase(node.getTagName())) {
            block.setDoC(8);
        } else if ("sup".equalsIgnoreCase(node.getTagName())) {
            block.setDoC(8);
        } else if ("img".equalsIgnoreCase(node.getTagName())) {
            block.setDoC(8);
        } else {
            block.setDoC(333);
        }
        return true;
    }

    public int getSizeTresholdWidth() {
        return this.sizeTresholdWidth;
    }

    public void setSizeTresholdWidth(int sizeTresholdWidth) {
        this.sizeTresholdWidth = sizeTresholdWidth;
    }

    public int getSizeTresholdHeight() {
        return this.sizeTresholdHeight;
    }

    public void setSizeTresholdHeight(int sizeTresholdHeight) {
        this.sizeTresholdHeight = sizeTresholdHeight;
    }

    private VisualBlock findBlockForBox(Box node, VisualBlock root) {
        if (root.getBox().equals(node)) {
            return root;
        }
        for (VisualBlock child : root.getChildren()) {
            VisualBlock found = this.findBlockForBox(node, child);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

