/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.vips.impl;

import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.vips.impl.Separator;
import cz.vutbr.fit.layout.vips.impl.VisualBlock;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicalOutput {
    private static Logger log = LoggerFactory.getLogger(GraphicalOutput.class);
    private static final Color VSEP_COLOR = Color.RED;
    private static final Color HSEP_COLOR = Color.BLUE;
    private static final Color BLOCK_COLOR = Color.BLACK;
    private static final Color TEXT_COLOR = Color.WHITE;
    private Graphics2D displayPool;
    private BufferedImage image;
    private Rectangular bounds;
    private List<VisualBlock> visualBlocks;
    private List<Separator> horizontalSeparators;
    private List<Separator> verticalSeparators;

    public GraphicalOutput(Rectangular subPageBounds) {
        this.bounds = new Rectangular(subPageBounds);
        this.image = new BufferedImage(this.bounds.getWidth(), this.bounds.getHeight(), 4);
        this.createDisplayPool();
    }

    public List<VisualBlock> getVisualBlocks() {
        return this.visualBlocks;
    }

    public void setVisualBlocks(List<VisualBlock> visualBlocks) {
        this.visualBlocks = visualBlocks;
    }

    public List<Separator> getHorizontalSeparators() {
        return this.horizontalSeparators;
    }

    public void setHorizontalSeparators(List<Separator> horizontalSeparators) {
        this.horizontalSeparators = horizontalSeparators;
    }

    public List<Separator> getVerticalSeparators() {
        return this.verticalSeparators;
    }

    public void setVerticalSeparators(List<Separator> verticalSeparators) {
        this.verticalSeparators = verticalSeparators;
    }

    private void createDisplayPool() {
        this.displayPool = this.image.createGraphics();
        this.displayPool.setColor(Color.WHITE);
        this.displayPool.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
        this.displayPool.setColor(Color.BLACK);
        this.displayPool.setFont(new Font("Dialog", 1, 11));
    }

    private void drawVisualBlock(VisualBlock vipsBlock) {
        Rectangular bb = vipsBlock.getBounds();
        Rectangle rect = new Rectangle(bb.getX1(), bb.getY1(), bb.getWidth(), bb.getHeight());
        this.displayPool.setColor(BLOCK_COLOR);
        this.displayPool.draw(rect);
        this.displayPool.fill(rect);
        this.displayPool.setColor(TEXT_COLOR);
        this.displayPool.drawString(String.valueOf(vipsBlock.getDoC()), bb.getX1() + 5, bb.getY1() + 15);
    }

    private void drawVisualBlocks() {
        for (VisualBlock block : this.getVisualBlocks()) {
            this.drawVisualBlock(block);
        }
    }

    private void drawHorizontalSeparators() {
        for (Separator separator : this.getHorizontalSeparators()) {
            int tx = this.bounds.getX1();
            int ty = this.bounds.getY1() + separator.getStartPoint();
            Rectangle rect = new Rectangle(tx, ty, this.bounds.getWidth(), separator.getEndPoint() - separator.getStartPoint());
            this.displayPool.setColor(HSEP_COLOR);
            this.displayPool.draw(rect);
            this.displayPool.fill(rect);
            this.displayPool.setColor(TEXT_COLOR);
            this.displayPool.drawString(String.valueOf(separator.getWeight()), tx + 5, ty + 15);
        }
    }

    private void drawVerticalSeparators() {
        for (Separator separator : this.getVerticalSeparators()) {
            int tx = this.bounds.getX1() + separator.getStartPoint();
            int ty = this.bounds.getY1();
            Rectangle rect = new Rectangle(tx, ty, separator.getEndPoint() - separator.getStartPoint(), this.bounds.getHeight());
            this.displayPool.setColor(VSEP_COLOR);
            this.displayPool.draw(rect);
            this.displayPool.fill(rect);
            this.displayPool.setColor(TEXT_COLOR);
            this.displayPool.drawString(String.valueOf(separator.getWeight()), tx + 5, ty + 25);
        }
    }

    private void drawAll() {
        this.drawVisualBlocks();
        this.drawVerticalSeparators();
        this.drawHorizontalSeparators();
    }

    public void exportAllToImage() {
        this.createDisplayPool();
        this.drawAll();
        this.saveToImage("all");
    }

    public void exportAllToImage(String suffix) {
        this.createDisplayPool();
        this.drawAll();
        this.saveToImage("iteration" + suffix);
    }

    public void exportVerticalSeparatorsToImage() {
        this.createDisplayPool();
        this.drawVerticalSeparators();
        this.saveToImage("verticalSeparators");
    }

    public void exportVerticalSeparatorsToImage(String suffix) {
        this.createDisplayPool();
        this.drawVerticalSeparators();
        this.saveToImage("verticalSeparators" + suffix);
    }

    public void exportHorizontalSeparatorsToImage() {
        this.createDisplayPool();
        this.drawHorizontalSeparators();
        this.saveToImage("horizontalSeparators");
    }

    public void exportHorizontalSeparatorsToImage(String suffix) {
        this.createDisplayPool();
        this.drawHorizontalSeparators();
        this.saveToImage("horizontalSeparators" + suffix);
    }

    private void saveToImage(String filename) {
        filename = System.getProperty("user.dir") + "/" + (String)filename + ".png";
        try {
            ImageIO.write((RenderedImage)this.image, "png", new File((String)filename));
        }
        catch (Exception e) {
            log.error("Couldn't save {}: {}", filename, (Object)e.getMessage());
        }
    }
}

