/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.vips.impl;

import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.vips.impl.Separator;
import cz.vutbr.fit.layout.vips.impl.VisualBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SeparatorDetector {
    private List<VisualBlock> visualBlocks;
    private List<Separator> horizontalSeparators;
    private List<Separator> verticalSeparators;
    private Rectangular pageBounds;

    public SeparatorDetector(List<VisualBlock> visualBlocks, Rectangular pageBounds) {
        this.pageBounds = pageBounds;
        this.visualBlocks = visualBlocks;
        this.horizontalSeparators = new ArrayList<Separator>();
        this.verticalSeparators = new ArrayList<Separator>();
    }

    public void setVisualBlocks(List<VisualBlock> visualBlocks) {
        this.visualBlocks = visualBlocks;
    }

    public List<VisualBlock> getVisualBlocks() {
        return this.visualBlocks;
    }

    public List<Separator> detectHorizontalSeparators() {
        this.horizontalSeparators.clear();
        if (this.visualBlocks.size() > 0) {
            this.horizontalSeparators.add(new Separator(this.pageBounds.getY1(), this.pageBounds.getY2(), false));
            this.findHorizontalSeparators();
            this.removeBorderSeparators(this.horizontalSeparators, this.pageBounds.getY1(), this.pageBounds.getY2());
            this.computeHorizontalWeights();
            this.sortSeparatorsByWeight(this.horizontalSeparators);
        }
        return this.horizontalSeparators;
    }

    public List<Separator> detectVerticalSeparators() {
        this.verticalSeparators.clear();
        if (this.visualBlocks.size() > 0) {
            this.verticalSeparators.add(new Separator(this.pageBounds.getX1(), this.pageBounds.getX2(), true));
            this.findVerticalSeparators();
            this.removeBorderSeparators(this.verticalSeparators, this.pageBounds.getX1(), this.pageBounds.getX2());
            this.computeVerticalWeights();
            this.sortSeparatorsByWeight(this.verticalSeparators);
        }
        return this.verticalSeparators;
    }

    private void findVerticalSeparators() {
        for (VisualBlock vipsBlock : this.visualBlocks) {
            int blockStart = vipsBlock.getBounds().getX1();
            int blockEnd = vipsBlock.getBounds().getX2();
            this.updateSeparatorsForBlock(this.verticalSeparators, blockStart, blockEnd);
        }
    }

    private void findHorizontalSeparators() {
        for (VisualBlock vipsBlock : this.visualBlocks) {
            int blockStart = vipsBlock.getBounds().getY1();
            int blockEnd = vipsBlock.getBounds().getY2();
            this.updateSeparatorsForBlock(this.horizontalSeparators, blockStart, blockEnd);
        }
    }

    private void updateSeparatorsForBlock(List<Separator> separators, int blockStart, int blockEnd) {
        ArrayList<Separator> toAdd = new ArrayList<Separator>();
        Iterator<Separator> it = separators.iterator();
        while (it.hasNext()) {
            Separator sep = it.next();
            if (blockStart <= sep.startPoint && blockEnd >= sep.endPoint) {
                it.remove();
                continue;
            }
            if (blockStart > sep.startPoint && blockEnd < sep.endPoint) {
                Separator newsep = new Separator(sep);
                sep.endPoint = blockStart - 1;
                newsep.startPoint = blockEnd + 1;
                toAdd.add(newsep);
                continue;
            }
            if (blockStart <= sep.startPoint && blockEnd >= sep.startPoint && blockEnd < sep.endPoint) {
                sep.startPoint = blockEnd + 1;
                continue;
            }
            if (blockEnd < sep.endPoint || blockStart <= sep.startPoint || blockStart > sep.endPoint) continue;
            sep.endPoint = blockStart - 1;
        }
        separators.addAll(toAdd);
    }

    private void removeBorderSeparators(List<Separator> list, int min, int max) {
        Iterator<Separator> it = list.iterator();
        while (it.hasNext()) {
            Separator separator = it.next();
            if (separator.startPoint != min && separator.endPoint != max) continue;
            it.remove();
        }
    }

    private void sortSeparatorsByWeight(List<Separator> separators) {
        Collections.sort(separators);
    }

    private void computeVerticalWeights() {
        for (Separator separator : this.verticalSeparators) {
            this.ruleOne(separator);
            this.ruleTwo(separator);
            this.ruleThree(separator);
        }
    }

    private void computeHorizontalWeights() {
        for (Separator separator : this.horizontalSeparators) {
            this.ruleOne(separator);
            this.ruleTwo(separator);
            this.ruleThree(separator);
            this.ruleFour(separator);
            this.ruleFive(separator);
        }
    }

    private void ruleOne(Separator separator) {
        int width = separator.endPoint - separator.startPoint + 1;
        separator.weight = width > 15 ? (separator.weight += ((width - 16) / 10 + 1) * 2 + 2) : (width > 8 && width <= 15 ? (separator.weight += 2) : ++separator.weight);
    }

    private void ruleTwo(Separator separator) {
        List<VisualBlock> overlappedElements = this.findOverlappedElements(separator);
        for (VisualBlock vipsBlock : overlappedElements) {
            if (!"hr".equalsIgnoreCase(vipsBlock.getBox().getTagName())) continue;
            separator.weight += 2;
            break;
        }
    }

    private List<VisualBlock> findOverlappedElements(Separator separator) {
        ArrayList<VisualBlock> result = new ArrayList<VisualBlock>();
        for (VisualBlock vipsBlock : this.visualBlocks) {
            int blockEnd;
            int blockStart;
            if (separator.isVertical()) {
                blockStart = vipsBlock.getBounds().getX1();
                blockEnd = vipsBlock.getBounds().getX2();
            } else {
                blockStart = vipsBlock.getBounds().getY1();
                blockEnd = vipsBlock.getBounds().getY2();
            }
            if ((blockStart < separator.startPoint || blockStart > separator.endPoint) && (blockEnd < separator.startPoint || blockEnd > separator.endPoint)) continue;
            result.add(vipsBlock);
        }
        return result;
    }

    private void ruleThree(Separator separator) {
        ArrayList<VisualBlock> adjacentBefore = new ArrayList<VisualBlock>();
        ArrayList<VisualBlock> adjacentAfter = new ArrayList<VisualBlock>();
        this.findAdjacentBlocks(separator, adjacentBefore, adjacentAfter);
        if (!adjacentBefore.isEmpty() && !adjacentAfter.isEmpty()) {
            boolean weightIncreased = false;
            for (VisualBlock before : adjacentBefore) {
                for (VisualBlock after : adjacentAfter) {
                    if (before.getBgColor().equals(after.getBgColor())) continue;
                    separator.weight += 2;
                    weightIncreased = true;
                    break;
                }
                if (!weightIncreased) continue;
                break;
            }
        }
    }

    private void findAdjacentBlocks(Separator separator, List<VisualBlock> before, List<VisualBlock> after) {
        for (VisualBlock vipsBlock : this.visualBlocks) {
            int blockEnd;
            int blockStart;
            if (separator.isVertical()) {
                blockStart = vipsBlock.getBounds().getX1();
                blockEnd = vipsBlock.getBounds().getX2();
            } else {
                blockStart = vipsBlock.getBounds().getY1();
                blockEnd = vipsBlock.getBounds().getY2();
            }
            if (blockStart == separator.endPoint + 1) {
                after.add(vipsBlock);
                continue;
            }
            if (blockEnd != separator.startPoint - 1) continue;
            before.add(0, vipsBlock);
        }
    }

    private void ruleFour(Separator separator) {
        ArrayList<VisualBlock> adjacentTop = new ArrayList<VisualBlock>();
        ArrayList<VisualBlock> adjacentBottom = new ArrayList<VisualBlock>();
        this.findAdjacentBlocks(separator, adjacentTop, adjacentBottom);
        if (!adjacentTop.isEmpty() && !adjacentBottom.isEmpty()) {
            boolean weightIncreased = false;
            for (VisualBlock top : adjacentTop) {
                for (VisualBlock bottom : adjacentBottom) {
                    int diff = Math.abs(top.getFontSize() - bottom.getFontSize());
                    if (diff != 0) {
                        separator.weight += 2;
                        weightIncreased = true;
                        break;
                    }
                    if (top.getFontWeight().equals(bottom.getFontWeight())) continue;
                    separator.weight += 2;
                }
                if (!weightIncreased) continue;
                break;
            }
            weightIncreased = false;
            for (VisualBlock top : adjacentTop) {
                for (VisualBlock bottom : adjacentBottom) {
                    if (top.getFontSize() >= bottom.getFontSize()) continue;
                    separator.weight += 2;
                    weightIncreased = true;
                    break;
                }
                if (!weightIncreased) continue;
                break;
            }
        }
    }

    private void ruleFive(Separator separator) {
        ArrayList<VisualBlock> adjacentTop = new ArrayList<VisualBlock>();
        ArrayList<VisualBlock> adjacentBottom = new ArrayList<VisualBlock>();
        this.findAdjacentBlocks(separator, adjacentTop, adjacentBottom);
        if (!adjacentTop.isEmpty() && !adjacentBottom.isEmpty()) {
            boolean weightDecreased = false;
            for (VisualBlock top : adjacentTop) {
                for (VisualBlock bottom : adjacentBottom) {
                    if (top.getBox().getType() != Box.Type.TEXT_CONTENT || bottom.getBox().getType() != Box.Type.TEXT_CONTENT) continue;
                    separator.weight -= 2;
                    weightDecreased = true;
                    break;
                }
                if (!weightDecreased) continue;
                break;
            }
        }
    }

    public List<Separator> getHorizontalSeparators() {
        return this.horizontalSeparators;
    }

    public List<Separator> getVerticalSeparators() {
        return this.verticalSeparators;
    }

    public List<Separator> getAllSeparators() {
        ArrayList<Separator> ret = new ArrayList<Separator>(this.horizontalSeparators.size() + this.verticalSeparators.size());
        ret.addAll(this.horizontalSeparators);
        ret.addAll(this.verticalSeparators);
        this.sortSeparatorsByWeight(ret);
        return ret;
    }
}

