/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.vips.impl;

import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.vips.impl.GraphicalOutput;
import cz.vutbr.fit.layout.vips.impl.Separator;
import cz.vutbr.fit.layout.vips.impl.SeparatorDetector;
import cz.vutbr.fit.layout.vips.impl.VipsTreeBuilder;
import cz.vutbr.fit.layout.vips.impl.VisualArea;
import cz.vutbr.fit.layout.vips.impl.VisualBlock;
import cz.vutbr.fit.layout.vips.impl.VisualBlockDetector;
import cz.vutbr.fit.layout.vips.impl.VisualStructureConstructor;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vips {
    private static final int MAX_ITERATIONS = 20;
    private static Logger log = LoggerFactory.getLogger(Vips.class);
    private Page page = null;
    private VisualArea rootArea;
    private boolean _graphicsOutput = false;
    private boolean _outputToFolder = false;
    private int pDoC = 11;
    private int sizeTresholdWidth = 350;
    private int sizeTresholdHeight = 400;
    private int minSepWeight;
    private int maxSepWeight;

    public void enableGraphicsOutput(boolean enable) {
        this._graphicsOutput = enable;
    }

    public void enableOutputToFolder(boolean enable) {
        this._outputToFolder = enable;
    }

    public void setPredefinedDoC(int value) {
        if (value <= 0 || value > 11) {
            log.error("pDoC value must be between 1 and 11! ({} given)", (Object)value);
        }
        this.pDoC = value;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public VisualArea getVisualStructure() {
        return this.rootArea;
    }

    public VipsTreeBuilder getTreeBuilder() {
        return new VipsTreeBuilder(this.pDoC);
    }

    private String generateFolderName() {
        Object outputFolder = "";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss");
        outputFolder = (String)outputFolder + sdf.format(cal.getTime());
        outputFolder = (String)outputFolder + "_";
        outputFolder = (String)outputFolder + this.page.getSourceURL().getHost().replaceAll("\\.", "_").replaceAll("/", "_");
        return outputFolder;
    }

    private void performSegmentation() {
        int iteration;
        int pageWidth = this.page.getWidth();
        int pageHeight = this.page.getHeight();
        Rectangular pageBounds = new Rectangular(0, 0, pageWidth - 1, pageHeight - 1);
        this.minSepWeight = Integer.MAX_VALUE;
        this.maxSepWeight = 1;
        VisualBlock rootBlock = new VisualBlock();
        rootBlock.setBox(this.page.getRoot());
        this.rootArea = new VisualArea();
        this.rootArea.setBounds(pageBounds);
        this.rootArea.addBlock(rootBlock);
        boolean change = true;
        for (iteration = 0; change && iteration < 20; ++iteration) {
            change = this.iteration(iteration, this.rootArea);
            this.recursiveComputeDoC(this.rootArea);
        }
        log.debug("Segmentation finished after {} iterations", (Object)iteration);
    }

    private boolean iteration(int index, VisualArea root) {
        ArrayList<VisualArea> leaves = new ArrayList<VisualArea>();
        this.getLeafAreas(root, leaves);
        int li = 1;
        boolean changed = false;
        for (VisualArea leaf : leaves) {
            if (leaf.isFinished()) continue;
            changed |= this.segmentArea(index, li++, leaf);
        }
        return changed;
    }

    private boolean segmentArea(int iterationIndex, int leafIndex, VisualArea area) {
        VisualBlockDetector vipsParser = new VisualBlockDetector(area);
        vipsParser.setSizeTresholdHeight(this.sizeTresholdHeight);
        vipsParser.setSizeTresholdWidth(this.sizeTresholdWidth);
        vipsParser.parse();
        List<VisualBlock> vipsBlocks = vipsParser.getVisualBlocks();
        SeparatorDetector detector = new SeparatorDetector(vipsBlocks, area.getBounds());
        List<Separator> hsep = detector.detectHorizontalSeparators();
        List<Separator> vsep = detector.detectVerticalSeparators();
        List<Separator> asep = detector.getAllSeparators();
        this.updateSeparatorStats(asep);
        if (this._graphicsOutput) {
            String suffix = "-" + iterationIndex + "-" + leafIndex;
            this.exportSeparators(suffix, this.rootArea.getBounds(), vipsBlocks, hsep, vsep);
        }
        if (!asep.isEmpty()) {
            VisualStructureConstructor constructor = new VisualStructureConstructor(area.getBounds(), vipsBlocks, asep);
            constructor.constructVisualStructure();
            VisualArea resultRoot = constructor.getVisualStructure();
            area.addChildren(resultRoot.getChildren());
            area.setSeparators(resultRoot.getSeparators());
            return true;
        }
        area.setFinished(true);
        return false;
    }

    private void getLeafAreas(VisualArea root, List<VisualArea> dest) {
        if (root.getChildren().isEmpty()) {
            dest.add(root);
        } else {
            for (VisualArea child : root.getChildren()) {
                this.getLeafAreas(child, dest);
            }
        }
    }

    public void startSegmentation(Page page) {
        this.setPage(page);
        this.startSegmentation();
    }

    public void startSegmentation() {
        try {
            String outputFolder = "";
            String oldWorkingDirectory = "";
            Object newWorkingDirectory = "";
            if (this._outputToFolder) {
                outputFolder = this.generateFolderName();
                if (!new File(outputFolder).mkdir()) {
                    System.err.println("Something goes wrong during directory creation!");
                } else {
                    oldWorkingDirectory = System.getProperty("user.dir");
                    newWorkingDirectory = (String)newWorkingDirectory + oldWorkingDirectory + "/" + outputFolder + "/";
                    System.setProperty("user.dir", (String)newWorkingDirectory);
                }
            }
            this.performSegmentation();
            if (this._outputToFolder) {
                System.setProperty("user.dir", oldWorkingDirectory);
            }
        }
        catch (Exception e) {
            System.err.println("Something's wrong!");
            e.printStackTrace();
        }
    }

    private void updateSeparatorStats(List<Separator> separators) {
        if (!separators.isEmpty()) {
            int maxWeight = separators.get((int)0).weight;
            int minWeight = separators.get((int)(separators.size() - 1)).weight;
            if (minWeight < this.minSepWeight) {
                this.minSepWeight = minWeight;
            }
            if (maxWeight > this.maxSepWeight) {
                this.maxSepWeight = maxWeight;
            }
        }
    }

    private void recursiveComputeDoC(VisualArea root) {
        for (VisualArea child : root.getChildren()) {
            this.recursiveComputeDoC(child);
        }
        root.setDoC(this.computeDoC(root));
    }

    private int computeDoC(VisualArea area) {
        int maxsep = area.getMaxSeparator();
        if (maxsep == 0) {
            return 11;
        }
        double minWeight = this.minSepWeight;
        double maxWeight = this.maxSepWeight;
        double normalizedValue = ((double)maxsep - minWeight) / (maxWeight - minWeight) * 9.0 + 1.0;
        return 11 - (int)Math.ceil(normalizedValue);
    }

    private void exportSeparators(String suffix, Rectangular bounds, List<VisualBlock> blocks, List<Separator> hsep, List<Separator> vsep) {
        GraphicalOutput out = new GraphicalOutput(bounds);
        out.setHorizontalSeparators(hsep);
        out.exportHorizontalSeparatorsToImage(suffix);
        out.setVerticalSeparators(vsep);
        out.exportVerticalSeparatorsToImage(suffix);
        out.setVisualBlocks(blocks);
        out.exportAllToImage(suffix);
    }
}

