/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.vips.impl;

import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.vips.impl.Separator;
import cz.vutbr.fit.layout.vips.impl.VisualArea;
import cz.vutbr.fit.layout.vips.impl.VisualBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class VisualStructureConstructor {
    private List<VisualBlock> visualBlocks;
    private VisualArea root;
    private List<Separator> separators;
    private Rectangular pageBounds;

    public VisualStructureConstructor(Rectangular pageBounds, List<VisualBlock> blocks, List<Separator> separators) {
        this.pageBounds = new Rectangular(pageBounds);
        this.visualBlocks = blocks;
        this.separators = separators;
    }

    public void setPageSize(Rectangular bounds) {
        this.pageBounds = new Rectangular(bounds);
    }

    public VisualArea getVisualStructure() {
        return this.root;
    }

    public void setVipsBlocks(List<VisualBlock> vipsBlocks) {
        this.visualBlocks = vipsBlocks;
    }

    public List<VisualBlock> getVisualBlocks() {
        return this.visualBlocks;
    }

    public void constructVisualStructure() {
        this.root = new VisualArea();
        this.root.setBounds(this.pageBounds);
        List<VisualArea> pool = this.extractLeafStructures();
        this.root.addChildren(pool);
        Set<VisualArea> parents = new HashSet<VisualArea>();
        parents.add(this.root);
        LinkedList<Separator> seps = new LinkedList<Separator>(this.separators);
        while (!seps.isEmpty()) {
            int w = ((Separator)seps.get((int)0)).weight;
            boolean vertical = ((Separator)seps.get((int)0)).vertical;
            ArrayList<Separator> equalSeps = new ArrayList<Separator>();
            while (!seps.isEmpty() && ((Separator)seps.get((int)0)).vertical == vertical && ((Separator)seps.get((int)0)).weight == w) {
                Separator sep = (Separator)seps.remove(0);
                equalSeps.add(sep);
            }
            this.sortSeparatorsByPosition(equalSeps);
            parents = this.splitParents(parents, equalSeps);
        }
    }

    private Set<VisualArea> splitParents(Set<VisualArea> parents, List<Separator> seps) {
        HashSet<VisualArea> newParents = new HashSet<VisualArea>();
        for (VisualArea parent : parents) {
            ArrayList<Separator> plist = new ArrayList<Separator>();
            for (Separator sep : seps) {
                if (!sep.isInside(parent)) continue;
                plist.add(sep);
            }
            if (!plist.isEmpty()) {
                List<VisualArea> subParents = this.splitParent(parent, plist);
                newParents.addAll(subParents);
                continue;
            }
            newParents.add(parent);
        }
        return newParents;
    }

    private List<VisualArea> splitParent(VisualArea parent, List<Separator> seps) {
        ArrayList<VisualArea> newParents = new ArrayList<VisualArea>(seps.size() + 1);
        Separator prevSep = null;
        for (int i = 0; i < seps.size() + 1; ++i) {
            Separator nextSep;
            VisualArea newParent = new VisualArea(parent);
            Separator separator = nextSep = i < seps.size() ? seps.get(i) : null;
            if (prevSep != null) {
                if (prevSep.vertical) {
                    newParent.setX1(prevSep.endPoint + 1);
                } else {
                    newParent.setY1(prevSep.endPoint + 1);
                }
            }
            if (nextSep != null) {
                if (nextSep.vertical) {
                    newParent.setX2(nextSep.startPoint - 1);
                } else {
                    newParent.setY2(nextSep.startPoint - 1);
                }
            }
            newParents.add(newParent);
            prevSep = nextSep;
        }
        for (VisualArea child : parent.getChildren()) {
            int pos = this.findSeparatorIndexAfter(child, seps);
            ((VisualArea)newParents.get(pos)).addChild(child);
        }
        parent.getChildren().clear();
        ArrayList<VisualArea> subParents = new ArrayList<VisualArea>(newParents.size());
        for (VisualArea subParent : newParents) {
            if (subParent.getChildren().size() > 1) {
                subParents.add(subParent);
                continue;
            }
            if (subParent.getChildren().size() != 1) continue;
            subParents.add(subParent.getChildren().get(0));
        }
        parent.addChildren(subParents);
        parent.setSeparators(seps);
        return subParents;
    }

    private int findSeparatorIndexAfter(VisualArea area, List<Separator> seps) {
        for (int i = 0; i < seps.size(); ++i) {
            Separator sep = seps.get(i);
            if ((!sep.vertical || sep.startPoint <= area.getX2()) && (sep.vertical || sep.startPoint <= area.getY2())) continue;
            return i;
        }
        return seps.size();
    }

    private List<VisualArea> extractLeafStructures() {
        ArrayList<VisualArea> list = new ArrayList<VisualArea>();
        VisualArea initial = new VisualArea();
        initial.setBlockRoots(this.visualBlocks);
        initial.setBounds(this.pageBounds);
        list.add(initial);
        for (Separator sep : this.separators) {
            ArrayList<VisualArea> toAdd = new ArrayList<VisualArea>();
            ArrayList<VisualArea> toRemove = new ArrayList<VisualArea>();
            for (VisualArea area : list) {
                if (!sep.isVertical() && sep.startPoint >= area.getY1() && sep.endPoint <= area.getY2()) {
                    this.splitHorizontally(area, sep, toAdd);
                    toRemove.add(area);
                    continue;
                }
                if (!sep.isVertical() || sep.startPoint < area.getX1() || sep.endPoint > area.getX2()) continue;
                this.splitVertically(area, sep, toAdd);
                toRemove.add(area);
            }
            list.removeAll(toRemove);
            list.addAll(toAdd);
        }
        return list;
    }

    private void splitHorizontally(VisualArea current, Separator separator, List<VisualArea> list) {
        VisualArea top = new VisualArea(current);
        top.setY2(separator.startPoint - 1);
        VisualArea bottom = new VisualArea(current);
        bottom.setY1(separator.endPoint + 1);
        List<VisualBlock> nestedBlocks = current.getBlockRoots();
        for (VisualBlock vipsBlock : nestedBlocks) {
            if (vipsBlock.getBounds().getY1() <= separator.startPoint) {
                top.addBlock(vipsBlock);
                continue;
            }
            bottom.addBlock(vipsBlock);
        }
        if (!top.isEmpty()) {
            list.add(top);
        }
        if (!bottom.isEmpty()) {
            list.add(bottom);
        }
    }

    private void splitVertically(VisualArea current, Separator separator, List<VisualArea> list) {
        VisualArea left = new VisualArea(current);
        left.setX2(separator.startPoint - 1);
        VisualArea right = new VisualArea(current);
        right.setX1(separator.endPoint + 1);
        List<VisualBlock> nestedBlocks = current.getBlockRoots();
        for (VisualBlock vipsBlock : nestedBlocks) {
            if (vipsBlock.getBounds().getX1() <= separator.startPoint) {
                left.addBlock(vipsBlock);
                continue;
            }
            right.addBlock(vipsBlock);
        }
        if (!left.isEmpty()) {
            list.add(left);
        }
        if (!right.isEmpty()) {
            list.add(right);
        }
    }

    private void sortSeparatorsByPosition(List<Separator> separators) {
        Collections.sort(separators, new Comparator<Separator>(){

            @Override
            public int compare(Separator o1, Separator o2) {
                return o1.startPoint - o2.startPoint;
            }
        });
    }

    private int findMinimalDoC(VisualArea visualStructure) {
        int min = Integer.MAX_VALUE;
        for (VisualArea child : visualStructure.getChildren()) {
            if (child.getDoC() >= min) continue;
            min = child.getDoC();
        }
        return min;
    }

    public int getMinimalDoC() {
        return this.findMinimalDoC(this.root);
    }
}

