/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.vips.impl;

import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.vips.impl.Utils;
import java.util.ArrayList;
import java.util.List;

public class VisualBlock {
    private VisualBlock root;
    private Box box = null;
    private List<VisualBlock> children = new ArrayList<VisualBlock>();
    private int doC = 0;
    private boolean visualBlock = false;
    private boolean alreadyDivided = false;
    private boolean dividable = true;
    private String bgColor = null;

    public void reset() {
        this.visualBlock = false;
        this.alreadyDivided = false;
        this.dividable = true;
        this.doC = 0;
        this.children.clear();
    }

    public void setIsVisualBlock(boolean isVisualBlock) {
        this.visualBlock = isVisualBlock;
    }

    public boolean isVisualBlock() {
        return this.visualBlock;
    }

    public void addChild(VisualBlock child) {
        this.children.add(child);
    }

    public List<VisualBlock> getChildren() {
        return this.children;
    }

    public VisualBlock getRoot() {
        return this.root;
    }

    public void setRoot(VisualBlock root) {
        this.root = root;
    }

    public void setBox(Box box) {
        this.box = box;
    }

    public Box getBox() {
        return this.box;
    }

    public int getDoC() {
        return this.doC;
    }

    public void setDoC(int doC) {
        this.doC = doC;
    }

    public boolean isDividable() {
        return this.dividable;
    }

    public void setIsDividable(boolean isDividable) {
        this.dividable = isDividable;
    }

    public boolean isAlreadyDivided() {
        return this.alreadyDivided;
    }

    public void setAlreadyDivided(boolean alreadyDivided) {
        this.alreadyDivided = alreadyDivided;
    }

    public Rectangular getBounds() {
        return this.getBox().getVisualBounds();
    }

    private String findBgColor(Box element) {
        String backgroundColor = Utils.colorString(element.getBackgroundColor());
        if (backgroundColor.isEmpty()) {
            if (element.getParent() != null && !element.getTagName().equals("body")) {
                return this.findBgColor((Box)element.getParent());
            }
            return "#ffffff";
        }
        return backgroundColor;
    }

    public String getBgColor() {
        if (this.bgColor == null) {
            this.bgColor = this.findBgColor(this.getBox());
        }
        return this.bgColor;
    }

    public int getFontSize() {
        return Math.round(this.getBox().getTextStyle().getFontSize());
    }

    public String getFontWeight() {
        return Utils.fontWeight(this.getBox());
    }

    public String toString() {
        Object ret;
        Object object = ret = this.isVisualBlock() ? "*[" : "[";
        if (this.getBox() != null) {
            ret = (String)ret + this.getBox().toString();
        }
        ret = (String)ret + "]";
        ret = (String)ret + "(DoC=" + this.getDoC() + ")";
        return ret;
    }
}

