/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.vips.impl;

import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.vips.impl.Separator;
import cz.vutbr.fit.layout.vips.impl.VisualBlock;
import java.util.ArrayList;
import java.util.List;

public class VisualArea {
    private List<VisualBlock> blockRoots = new ArrayList<VisualBlock>();
    private List<VisualArea> childStructures = new ArrayList<VisualArea>();
    private List<Separator> separators;
    private Rectangular bounds = new Rectangular();
    private int doC = 1;
    private boolean finished = false;

    public VisualArea() {
    }

    public VisualArea(VisualArea src) {
        this();
        this.bounds = new Rectangular(src.bounds);
    }

    public List<VisualBlock> getBlockRoots() {
        return this.blockRoots;
    }

    public void addBlock(VisualBlock blockRoot) {
        this.blockRoots.add(blockRoot);
    }

    public void setBlockRoots(List<VisualBlock> vipsBlocks) {
        this.blockRoots = vipsBlocks;
    }

    public boolean isEmpty() {
        return this.blockRoots.isEmpty();
    }

    public void addChild(VisualArea child) {
        this.childStructures.add(child);
    }

    public void addChildren(List<VisualArea> children) {
        for (VisualArea child : children) {
            this.addChild(child);
        }
    }

    public List<VisualArea> getChildren() {
        return this.childStructures;
    }

    public void setSeparators(List<Separator> separators) {
        this.separators = separators;
    }

    public List<Separator> getSeparators() {
        return this.separators;
    }

    public void setBounds(Rectangular bounds) {
        this.bounds = new Rectangular(bounds);
    }

    public void setX1(int x) {
        this.bounds.setX1(x);
    }

    public void setX2(int x) {
        this.bounds.setX2(x);
    }

    public void setY1(int y) {
        this.bounds.setY1(y);
    }

    public void setY2(int y) {
        this.bounds.setY2(y);
    }

    public int getX1() {
        return this.bounds.getX1();
    }

    public int getX2() {
        return this.bounds.getX2();
    }

    public int getY1() {
        return this.bounds.getY1();
    }

    public int getY2() {
        return this.bounds.getY2();
    }

    public Rectangular getBounds() {
        return this.bounds;
    }

    public int getDoC() {
        return this.doC;
    }

    public void setDoC(int doC) {
        this.doC = doC;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public int getMaxSeparator() {
        int max = 0;
        if (this.getSeparators() != null) {
            for (Separator sep : this.getSeparators()) {
                if (sep.getWeight() <= max) continue;
                max = sep.getWeight();
            }
        }
        for (VisualArea child : this.getChildren()) {
            int cmax = child.getMaxSeparator();
            if (cmax <= max) continue;
            max = cmax;
        }
        return max;
    }

    public String toString() {
        return "[blockRoots=" + this.blockRoots + ", doC=" + this.getDoC() + "]";
    }
}

