/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.vips.impl;

import cz.vutbr.fit.layout.vips.impl.VisualArea;

public class Separator
implements Comparable<Separator> {
    public boolean vertical;
    public int startPoint = 0;
    public int endPoint = 0;
    public int weight = 3;

    public Separator(int start, int end, boolean vertical) {
        this.vertical = vertical;
        this.startPoint = start;
        this.endPoint = end;
    }

    public Separator(int start, int end, boolean vertical, int weight) {
        this.vertical = vertical;
        this.startPoint = start;
        this.endPoint = end;
        this.weight = weight;
    }

    public Separator(Separator src) {
        this.vertical = src.vertical;
        this.startPoint = src.startPoint;
        this.endPoint = src.endPoint;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public int getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(int startPoint) {
        this.startPoint = startPoint;
    }

    public int getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(int endPoint) {
        this.endPoint = endPoint;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public boolean isInside(VisualArea area) {
        if (this.vertical) {
            return this.startPoint > area.getX1() && this.endPoint < area.getX2();
        }
        return this.startPoint > area.getY1() && this.endPoint < area.getY2();
    }

    @Override
    public int compareTo(Separator otherSeparator) {
        int dif = otherSeparator.weight - this.weight;
        if (dif == 0) {
            return (otherSeparator.vertical ? 0 : 1) - (this.vertical ? 0 : 1);
        }
        return dif;
    }

    public String toString() {
        return "Separator [vertical=" + this.vertical + ", startPoint=" + this.startPoint + ", endPoint=" + this.endPoint + ", weight=" + this.weight + "]";
    }
}

