/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Border;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.FL;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.AreaTreeInfo;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelLoader;
import cz.vutbr.fit.layout.rdf.ModelLoaderBase;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.Serialization;
import cz.vutbr.fit.layout.rdf.model.RDFArea;
import cz.vutbr.fit.layout.rdf.model.RDFAreaTree;
import cz.vutbr.fit.layout.rdf.model.RDFBox;
import cz.vutbr.fit.layout.rdf.model.RDFPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaModelLoader
extends ModelLoaderBase
implements ModelLoader {
    private static Logger log = LoggerFactory.getLogger(AreaModelLoader.class);
    private static final String[] dataObjectProperties = new String[]{"box:hasTopBorder", "box:hasBottomBorder", "box:hasLeftBorder", "box:hasRightBorder", "box:hasAttribute", "box:bounds", "segm:hasTag", "segm:tagSupport"};

    public AreaModelLoader(IRIFactory iriFactory) {
        super(iriFactory);
    }

    @Override
    public Artifact loadArtifact(IRI artifactIri, RDFArtifactRepository artifactRepo) throws RepositoryException {
        return this.constructAreaTree(artifactRepo, artifactIri);
    }

    private RDFAreaTree constructAreaTree(RDFArtifactRepository artifactRepo, IRI areaTreeIri) throws RepositoryException {
        Model artifactModel = artifactRepo.getStorage().getSubjectModel((Resource)areaTreeIri);
        if (artifactModel.size() > 0) {
            AreaTreeInfo atreeInfo = new AreaTreeInfo(artifactModel, areaTreeIri);
            IRI pageIri = this.getSourcePageIri(artifactModel, areaTreeIri);
            IRI parentIri = this.getPredicateIriValue(artifactModel, areaTreeIri, FL.hasParentArtifact);
            RDFAreaTree atree = new RDFAreaTree(parentIri, pageIri);
            atreeInfo.applyToAreaTree(atree);
            Model areaModel = this.getAreaModelForAreaTree(artifactRepo, areaTreeIri);
            Model dataModel = this.getAreaDataModelForAreaTree(artifactRepo, areaTreeIri);
            RDFPage sourcePage = null;
            if (pageIri != null) {
                sourcePage = this.getSourcePage(pageIri, artifactRepo);
            }
            LinkedHashMap<IRI, RDFArea> areaUris = new LinkedHashMap<IRI, RDFArea>();
            RDFArea root = this.constructVisualAreaTree(artifactRepo, sourcePage, atree, areaModel, dataModel, areaTreeIri, areaUris);
            this.recursiveUpdateTopologies((Area)root);
            atree.setRoot((Area)root);
            atree.setAreaIris(areaUris);
            return atree;
        }
        return null;
    }

    private RDFArea constructVisualAreaTree(RDFArtifactRepository artifactRepo, RDFPage sourcePage, RDFAreaTree atree, Model areaModel, Model dataModel, IRI areaTreeIri, Map<IRI, RDFArea> areas) throws RepositoryException {
        for (Resource res : areaModel.subjects()) {
            if (!(res instanceof IRI)) continue;
            RDFArea area = this.createAreaFromModel(artifactRepo, sourcePage, areaModel, dataModel, areaTreeIri, (IRI)res);
            area.setAreaTree((AreaTree)atree);
            areas.put((IRI)res, area);
        }
        ArrayList<RDFArea> rootAreas = new ArrayList<RDFArea>(areas.values());
        for (Statement st : areaModel.filter(null, SEGM.isChildOf, null, new Resource[0])) {
            if (!(st.getSubject() instanceof IRI) || !(st.getObject() instanceof IRI)) continue;
            RDFArea parent = areas.get(st.getObject());
            RDFArea child = areas.get(st.getSubject());
            if (parent == null || child == null) continue;
            parent.appendChild((Area)child);
            rootAreas.remove(child);
        }
        if (rootAreas.size() == 1) {
            return (RDFArea)rootAreas.get(0);
        }
        log.error("Strange number of root areas: {}", (Object)((Object)rootAreas).toString());
        return null;
    }

    private RDFArea createAreaFromModel(RDFArtifactRepository artifactRepo, RDFPage sourcePage, Model areaModel, Model dataModel, IRI areaTreeIri, IRI uri) throws RepositoryException {
        RDFArea area = new RDFArea(new Rectangular(), uri);
        area.setId(this.getIriFactory().decodeAreaId(uri));
        HashMap tagSupport = new HashMap();
        ModelLoaderBase.RDFTextStyle style = new ModelLoaderBase.RDFTextStyle();
        for (Statement st : areaModel.filter((Resource)uri, null, null, new Resource[0])) {
            Tag tag;
            Border border;
            IRI pred = st.getPredicate();
            Value value = st.getObject();
            if (RDFS.LABEL.equals((Object)pred)) {
                String name = value.stringValue();
                area.setName(name);
                continue;
            }
            if (BOX.documentOrder.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                area.setDocumentOrder(((Literal)value).intValue());
                continue;
            }
            if (BOX.backgroundColor.equals((Object)pred)) {
                String bgColor = value.stringValue();
                area.setBackgroundColor(Serialization.decodeHexColor(bgColor));
                continue;
            }
            if (BOX.underline.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                style.underline = ((Literal)value).floatValue();
                continue;
            }
            if (BOX.lineThrough.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                style.lineThrough = ((Literal)value).floatValue();
                continue;
            }
            if (BOX.fontSize.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                style.fontSize = ((Literal)value).floatValue();
                continue;
            }
            if (BOX.fontStyle.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                style.fontStyle = ((Literal)value).floatValue();
                continue;
            }
            if (BOX.fontWeight.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                style.fontWeight = ((Literal)value).floatValue();
                continue;
            }
            if (SEGM.contentLength.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                style.contentLength = ((Literal)value).intValue();
                continue;
            }
            if (BOX.hasBottomBorder.equals((Object)pred)) {
                if (!(value instanceof IRI)) continue;
                border = this.createBorder(dataModel, (IRI)value);
                area.setBorderStyle(Border.Side.BOTTOM, border);
                continue;
            }
            if (BOX.hasLeftBorder.equals((Object)pred)) {
                if (!(value instanceof IRI)) continue;
                border = this.createBorder(dataModel, (IRI)value);
                area.setBorderStyle(Border.Side.LEFT, border);
                continue;
            }
            if (BOX.hasRightBorder.equals((Object)pred)) {
                if (!(value instanceof IRI)) continue;
                border = this.createBorder(dataModel, (IRI)value);
                area.setBorderStyle(Border.Side.RIGHT, border);
                continue;
            }
            if (BOX.hasTopBorder.equals((Object)pred)) {
                if (!(value instanceof IRI)) continue;
                border = this.createBorder(dataModel, (IRI)value);
                area.setBorderStyle(Border.Side.TOP, border);
                continue;
            }
            if (BOX.bounds.equals((Object)pred)) {
                Rectangular rect;
                if (!(value instanceof IRI) || (rect = this.createBounds(dataModel, (IRI)value)) == null) continue;
                area.setBounds(rect);
                continue;
            }
            if (SEGM.containsBox.equals((Object)pred)) {
                RDFBox box;
                if (!(value instanceof IRI) || sourcePage == null || (box = sourcePage.findBoxByIri((IRI)value)) == null) continue;
                area.addBox((Box)box);
                continue;
            }
            if (SEGM.hasTag.equals((Object)pred)) {
                Tag tag2;
                if (!(value instanceof IRI) || tagSupport.containsKey(value) || (tag2 = this.createTag(dataModel, (IRI)value)) == null) continue;
                area.addTag(tag2, 1.0f);
                continue;
            }
            if (!SEGM.tagSupport.equals((Object)pred) || !(value instanceof IRI)) continue;
            IRI tsUri = (IRI)value;
            IRI tagUri = null;
            Float support = null;
            for (Statement sst : dataModel.filter((Resource)tsUri, null, null, new Resource[0])) {
                if (SEGM.hasTag.equals((Object)sst.getPredicate()) && sst.getObject() instanceof IRI) {
                    tagUri = (IRI)sst.getObject();
                    continue;
                }
                if (!SEGM.support.equals((Object)sst.getPredicate()) || !(sst.getObject() instanceof Literal)) continue;
                support = Float.valueOf(((Literal)sst.getObject()).floatValue());
            }
            if (tagUri == null || support == null || (tag = this.createTag(dataModel, (IRI)value)) == null) continue;
            area.addTag(tag, support.floatValue());
        }
        area.setTextStyle(style.toTextStyle());
        area.sortBoxes();
        return area;
    }

    private void recursiveUpdateTopologies(Area root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveUpdateTopologies((Area)root.getChildAt(i));
        }
        root.updateTopologies();
    }

    private Model getAreaModelForAreaTree(RDFArtifactRepository artifactRepo, IRI areaTreeIri) throws RepositoryException {
        String query = artifactRepo.getIriDecoder().declarePrefixes() + "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?s rdf:type segm:Area . ?s box:documentOrder ?ord . ?s segm:belongsTo <" + areaTreeIri.stringValue() + "> } ORDER BY ?ord";
        return artifactRepo.getStorage().executeSafeQuery(query);
    }

    private Model getAreaDataModelForAreaTree(RDFArtifactRepository artifactRepo, IRI areaTreeIri) throws RepositoryException {
        String query = artifactRepo.getIriDecoder().declarePrefixes() + "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?a rdf:type segm:Area . ?a segm:belongsTo <" + areaTreeIri.stringValue() + "> . " + this.getDataPropertyUnion(dataObjectProperties) + "}";
        return artifactRepo.getStorage().executeSafeQuery(query);
    }
}

