/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.unbescape.uri.UriEscape;

public class DefaultIRIFactory
implements IRIFactory {
    public static final String NAMESPACE = "http://fitlayout.github.io/resource/";
    public static final String PREFIX = "r";
    private final ValueFactory factory = SimpleValueFactory.getInstance();

    @Override
    public IRI createPageSetURI(String name) {
        String res = name.replace(' ', '_');
        res = UriEscape.escapeUriPathSegment((String)res);
        return this.factory.createIRI(NAMESPACE, "pset-" + res);
    }

    @Override
    public IRI createArtifactIri(long seq) {
        return this.factory.createIRI(NAMESPACE, "art" + seq);
    }

    @Override
    public IRI createArtifactIri(String id) {
        return this.factory.createIRI(NAMESPACE, "art-" + id);
    }

    @Override
    public IRI createBoxURI(IRI pageUri, Box box) {
        return this.factory.createIRI(pageUri.toString() + "#b" + box.getId());
    }

    @Override
    public int decodeBoxId(IRI boxIri) {
        int ofs;
        String localName = boxIri.getLocalName();
        for (ofs = 0; ofs < localName.length() && !Character.isDigit(localName.charAt(ofs)); ++ofs) {
        }
        if (ofs < localName.length()) {
            return Integer.parseInt(localName.substring(ofs));
        }
        return -1;
    }

    @Override
    public IRI createBoundsURI(IRI boxUri, String type) {
        String localName = boxUri.getLocalName() + "-rect-" + type;
        return this.factory.createIRI(boxUri.getNamespace(), localName);
    }

    @Override
    public IRI createBorderURI(IRI boxUri, String side) {
        String localName = boxUri.getLocalName() + "B" + side;
        return this.factory.createIRI(boxUri.getNamespace(), localName);
    }

    @Override
    public IRI createAttributeURI(IRI boxUri, String name) {
        String localName = boxUri.getLocalName() + "-attr-" + name;
        return this.factory.createIRI(boxUri.getNamespace(), localName);
    }

    @Override
    public IRI createContentObjectURI(IRI pageUri, int seq) {
        return this.factory.createIRI(pageUri.toString() + "#o" + seq);
    }

    @Override
    public IRI createAreaURI(IRI areaTreeNode, Area area) {
        return this.factory.createIRI(areaTreeNode.toString() + "#a" + area.getId());
    }

    @Override
    public int decodeAreaId(IRI areaIri) {
        return this.decodeBoxId(areaIri);
    }

    @Override
    public IRI createLogicalAreaURI(IRI areaTreeNode, int cnt) {
        return this.factory.createIRI(areaTreeNode.toString() + "#l" + cnt);
    }

    @Override
    public IRI createTagSupportURI(IRI areaUri, Tag tag) {
        return this.factory.createIRI(areaUri.toString() + "-" + this.getTagDesc(tag));
    }

    @Override
    public IRI createTagURI(Tag tag) {
        return this.factory.createIRI(NAMESPACE, "tag-" + this.getTagDesc(tag));
    }

    private String getTagDesc(Tag tag) {
        return tag.getType().replaceAll("\\.", "-") + "--" + tag.getValue();
    }

    @Override
    public IRI createTextChunkURI(IRI chunkSetUri, TextChunk chunk) {
        return this.factory.createIRI(chunkSetUri.toString() + "#c" + chunk.getId());
    }

    @Override
    public int decodeTextChunkId(IRI textChunkIri) {
        return this.decodeBoxId(textChunkIri);
    }

    @Override
    public IRI createSequenceURI(String name) {
        return this.factory.createIRI(NAMESPACE, "seq-" + name);
    }
}

