/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.impl.DefaultTag;
import cz.vutbr.fit.layout.model.Border;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TextStyle;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelTransformer;
import cz.vutbr.fit.layout.rdf.Serialization;
import cz.vutbr.fit.layout.rdf.model.RDFAreaTree;
import cz.vutbr.fit.layout.rdf.model.RDFPage;
import java.util.AbstractMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelLoaderBase
extends ModelTransformer {
    private static Logger log = LoggerFactory.getLogger(ModelLoaderBase.class);

    public ModelLoaderBase(IRIFactory iriFactory) {
        super(iriFactory);
    }

    protected IRI getPredicateIriValue(Model model, IRI subject, IRI predicate) {
        Iterable typeStatements = model.getStatements((Resource)subject, predicate, null, new Resource[0]);
        for (Statement st : typeStatements) {
            if (!(st.getObject() instanceof IRI)) continue;
            return (IRI)st.getObject();
        }
        return null;
    }

    protected Border createBorder(Model model, IRI uri) {
        Border ret = new Border();
        for (Statement st : model.filter((Resource)uri, null, null, new Resource[0])) {
            IRI pred = st.getPredicate();
            Value value = st.getObject();
            if (BOX.borderColor.equals((Object)pred)) {
                ret.setColor(Serialization.decodeHexColor(value.stringValue()));
                continue;
            }
            if (BOX.borderWidth.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                ret.setWidth(((Literal)value).intValue());
                continue;
            }
            if (!BOX.borderStyle.equals((Object)pred)) continue;
            String style = value.stringValue();
            try {
                ret.setStyle(Border.Style.valueOf((String)style));
            }
            catch (IllegalArgumentException r) {
                log.error("Invalid style value: {}", (Object)style);
            }
        }
        return ret;
    }

    protected Map.Entry<String, String> createAttribute(Model model, IRI uri) {
        String name = null;
        String avalue = null;
        for (Statement st : model.filter((Resource)uri, null, null, new Resource[0])) {
            IRI pred = st.getPredicate();
            Value value = st.getObject();
            if (RDFS.LABEL.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                name = ((Literal)value).stringValue();
                continue;
            }
            if (!RDF.VALUE.equals((Object)pred) || !(value instanceof Literal)) continue;
            avalue = ((Literal)value).stringValue();
        }
        if (name != null && avalue != null) {
            return new AbstractMap.SimpleEntry<Object, Object>(name, avalue);
        }
        return null;
    }

    protected Rectangular createBounds(Model model, IRI iri) {
        Integer x = null;
        Integer y = null;
        Integer width = null;
        Integer height = null;
        for (Statement st : model.filter((Resource)iri, null, null, new Resource[0])) {
            IRI pred = st.getPredicate();
            Value value = st.getObject();
            if (BOX.positionX.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                x = ((Literal)value).intValue();
                continue;
            }
            if (BOX.positionY.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                y = ((Literal)value).intValue();
                continue;
            }
            if (BOX.width.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                width = ((Literal)value).intValue();
                continue;
            }
            if (!BOX.height.equals((Object)pred) || !(value instanceof Literal)) continue;
            height = ((Literal)value).intValue();
        }
        if (x != null && y != null && width != null && height != null) {
            return new Rectangular(x.intValue(), y.intValue(), x + width - 1, y + height - 1);
        }
        return null;
    }

    protected IRI getSourcePageIri(Model model, IRI areaTreeIri) {
        return this.getPredicateIriValue(model, areaTreeIri, SEGM.hasSourcePage);
    }

    protected RDFPage getSourcePage(IRI pageIri, ArtifactRepository repo) {
        RDFPage page = (RDFPage)repo.getArtifact(pageIri);
        return page;
    }

    protected IRI getSourceAreaTreeIri(Model model, IRI logicalTreeIri) {
        return this.getPredicateIriValue(model, logicalTreeIri, SEGM.hasAreaTree);
    }

    protected RDFAreaTree getSourceAreaTree(IRI areaTreeIri, ArtifactRepository repo) {
        RDFAreaTree atree = (RDFAreaTree)repo.getArtifact(areaTreeIri);
        return atree;
    }

    protected Tag createTag(Model tagModel, IRI tagIri) throws RepositoryException {
        String name = null;
        String type = null;
        for (Statement st : tagModel.filter((Resource)tagIri, null, null, new Resource[0])) {
            IRI pred = st.getPredicate();
            if (SEGM.name.equals((Object)pred)) {
                name = st.getObject().stringValue();
                continue;
            }
            if (!SEGM.type.equals((Object)pred)) continue;
            type = st.getObject().stringValue();
        }
        if (name != null && type != null) {
            return new DefaultTag(type, name);
        }
        return null;
    }

    protected String getDataPropertyUnion(String[] dataObjectProperties) {
        StringBuilder ret = new StringBuilder();
        for (String p : dataObjectProperties) {
            if (ret.length() > 0) {
                ret.append(" UNION ");
            }
            ret.append("{?a ").append(p).append(" ?s}");
        }
        return ret.toString();
    }

    protected static class RDFTextStyle {
        public float fontSize = 0.0f;
        public float fontWeight = 0.0f;
        public float fontStyle = 0.0f;
        public float underline = 0.0f;
        public float lineThrough = 0.0f;
        public int contentLength = 1;

        protected RDFTextStyle() {
        }

        public TextStyle toTextStyle() {
            TextStyle ret = new TextStyle();
            ret.setFontSizeSum(this.fontSize * (float)this.contentLength);
            ret.setFontWeightSum(this.fontWeight * (float)this.contentLength);
            ret.setFontStyleSum(this.fontStyle * (float)this.contentLength);
            ret.setUnderlineSum(this.underline * (float)this.contentLength);
            ret.setLineThroughSum(this.lineThrough * (float)this.contentLength);
            ret.setContentLength(this.contentLength);
            return ret;
        }
    }
}

