/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.FL;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.ChunkSetInfo;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelLoader;
import cz.vutbr.fit.layout.rdf.ModelLoaderBase;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.Serialization;
import cz.vutbr.fit.layout.rdf.model.RDFArea;
import cz.vutbr.fit.layout.rdf.model.RDFAreaTree;
import cz.vutbr.fit.layout.rdf.model.RDFBox;
import cz.vutbr.fit.layout.rdf.model.RDFChunkSet;
import cz.vutbr.fit.layout.rdf.model.RDFPage;
import cz.vutbr.fit.layout.rdf.model.RDFTextChunk;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkSetModelLoader
extends ModelLoaderBase
implements ModelLoader {
    private static Logger log = LoggerFactory.getLogger(ChunkSetModelLoader.class);
    private static final String[] dataObjectProperties = new String[]{"segm:hasTag", "segm:tagSupport"};

    public ChunkSetModelLoader(IRIFactory iriFactory) {
        super(iriFactory);
    }

    @Override
    public Artifact loadArtifact(IRI artifactIri, RDFArtifactRepository artifactRepo) throws RepositoryException {
        return this.constructChunkSet(artifactRepo, artifactIri);
    }

    private RDFChunkSet constructChunkSet(RDFArtifactRepository artifactRepo, IRI csetIri) throws RepositoryException {
        Model artifactModel = artifactRepo.getStorage().getSubjectModel((Resource)csetIri);
        if (artifactModel.size() > 0) {
            ChunkSetInfo csetInfo = new ChunkSetInfo(artifactModel, csetIri);
            IRI parentIri = this.getPredicateIriValue(artifactModel, csetIri, FL.hasParentArtifact);
            RDFChunkSet cset = new RDFChunkSet(parentIri);
            csetInfo.applyToChunkSet(cset);
            Model chunkModel = this.getChunkModelForSet(artifactRepo, csetIri);
            Model tagModel = this.getChunkTagModelForSet(artifactRepo, csetIri);
            RDFAreaTree sourceAreaTree = null;
            RDFPage sourcePage = null;
            if (cset.getAreaTreeIri() != null) {
                sourceAreaTree = this.getSourceAreaTree(cset.getAreaTreeIri(), artifactRepo);
                if (sourceAreaTree != null) {
                    sourcePage = this.getSourcePage(sourceAreaTree.getPageIri(), artifactRepo);
                }
            } else {
                log.error("ChunkSet {} has no area tree IRI", (Object)csetIri.toString());
            }
            LinkedHashMap<IRI, RDFTextChunk> chunkUris = new LinkedHashMap<IRI, RDFTextChunk>();
            Set<TextChunk> chunks = this.loadChunks(artifactRepo, sourceAreaTree, sourcePage, csetIri, chunkModel, tagModel, chunkUris);
            cset.setTextChunks(chunks);
            return cset;
        }
        return null;
    }

    private Set<TextChunk> loadChunks(RDFArtifactRepository artifactRepo, RDFAreaTree sourceAreaTree, RDFPage sourcePage, IRI csetIri, Model model, Model tagModel, Map<IRI, RDFTextChunk> chunkUris) {
        for (Resource res : model.subjects()) {
            if (!(res instanceof IRI)) continue;
            RDFTextChunk area = this.createChunkFromModel(artifactRepo, sourceAreaTree, sourcePage, model, tagModel, csetIri, (IRI)res);
            chunkUris.put((IRI)res, area);
        }
        HashSet<TextChunk> ret = new HashSet<TextChunk>();
        ret.addAll(chunkUris.values());
        return ret;
    }

    private RDFTextChunk createChunkFromModel(RDFArtifactRepository artifactRepo, RDFAreaTree sourceAreaTree, RDFPage sourcePage, Model model, Model dataModel, IRI csetIri, IRI iri) throws RepositoryException {
        RDFTextChunk chunk = new RDFTextChunk(iri);
        HashMap tagSupport = new HashMap();
        for (Statement st : model.filter((Resource)iri, null, null, new Resource[0])) {
            Tag tag;
            IRI pred = st.getPredicate();
            Value value = st.getObject();
            if (SEGM.text.equals((Object)pred)) {
                chunk.setText(value.stringValue());
                continue;
            }
            if (BOX.documentOrder.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                chunk.setDocumentOrder(((Literal)value).intValue());
                continue;
            }
            if (BOX.backgroundColor.equals((Object)pred)) {
                String bgColor = value.stringValue();
                chunk.setEffectiveBackgroundColor(Serialization.decodeHexColor(bgColor));
                continue;
            }
            if (SEGM.hasSourceArea.equals((Object)pred)) {
                if (!(value instanceof IRI)) continue;
                RDFArea a = sourceAreaTree.findAreaByIri((IRI)value);
                if (a != null) {
                    chunk.setSourceArea((Area)a);
                    continue;
                }
                log.error("hasSourceArea points to a non-existent area {}", (Object)value.toString());
                continue;
            }
            if (SEGM.hasSourceBox.equals((Object)pred)) {
                if (!(value instanceof IRI)) continue;
                RDFBox b = sourcePage.findBoxByIri((IRI)value);
                if (b != null) {
                    chunk.setSourceBox((Box)b);
                    continue;
                }
                log.error("hasSourceBox points to a non-existent box {}", (Object)value.toString());
                continue;
            }
            if (BOX.bounds.equals((Object)pred)) {
                Rectangular rect;
                if (!(value instanceof IRI) || (rect = this.createBounds(dataModel, (IRI)value)) == null) continue;
                chunk.setBounds(rect);
                continue;
            }
            if (SEGM.hasTag.equals((Object)pred)) {
                Tag tag2;
                if (!(value instanceof IRI) || tagSupport.containsKey(value) || (tag2 = this.createTag(dataModel, (IRI)value)) == null) continue;
                chunk.addTag(tag2, 1.0f);
                continue;
            }
            if (!SEGM.tagSupport.equals((Object)pred) || !(value instanceof IRI)) continue;
            IRI tsUri = (IRI)value;
            IRI tagUri = null;
            Float support = null;
            for (Statement sst : dataModel.filter((Resource)tsUri, null, null, new Resource[0])) {
                if (SEGM.hasTag.equals((Object)sst.getPredicate()) && sst.getObject() instanceof IRI) {
                    tagUri = (IRI)sst.getObject();
                    continue;
                }
                if (!SEGM.support.equals((Object)sst.getPredicate()) || !(sst.getObject() instanceof Literal)) continue;
                support = Float.valueOf(((Literal)sst.getObject()).floatValue());
            }
            if (tagUri == null || support == null || (tag = this.createTag(dataModel, (IRI)value)) == null) continue;
            chunk.addTag(tag, support.floatValue());
        }
        return chunk;
    }

    private Model getChunkModelForSet(RDFArtifactRepository artifactRepo, IRI chunkSetIri) throws RepositoryException {
        String query = artifactRepo.getIriDecoder().declarePrefixes() + "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?s rdf:type segm:TextChunk . ?s segm:belongsToChunkSet <" + chunkSetIri.stringValue() + "> }";
        return artifactRepo.getStorage().executeSafeQuery(query);
    }

    private Model getChunkTagModelForSet(RDFArtifactRepository artifactRepo, IRI chunkSetIri) throws RepositoryException {
        String query = artifactRepo.getIriDecoder().declarePrefixes() + "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?a rdf:type segm:TextChunk . ?a segm:belongsToChunkSet <" + chunkSetIri.stringValue() + "> . " + this.getDataPropertyUnion(dataObjectProperties) + "}";
        return artifactRepo.getStorage().executeSafeQuery(query);
    }
}

