/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.FL;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelTransformer;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;

public class ModelBuilderBase
extends ModelTransformer {
    public ModelBuilderBase(IRIFactory iriFactory) {
        super(iriFactory);
    }

    public void addArtifactData(Model graph, Artifact a) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        IRI node = a.getIri();
        graph.add((Resource)node, RDF.TYPE, (Value)a.getArtifactType(), new Resource[0]);
        if (a.getParentIri() != null) {
            graph.add((Resource)node, FL.hasParentArtifact, (Value)a.getParentIri(), new Resource[0]);
        }
        if (a.getLabel() != null) {
            graph.add((Resource)node, RDFS.LABEL, (Value)vf.createLiteral(a.getLabel()), new Resource[0]);
        }
        if (a.getCreatedOn() != null) {
            graph.add((Resource)node, FL.createdOn, (Value)vf.createLiteral(a.getCreatedOn()), new Resource[0]);
        }
        if (a.getCreator() != null) {
            graph.add((Resource)node, FL.creator, (Value)vf.createLiteral(a.getCreator()), new Resource[0]);
        }
        if (a.getCreatorParams() != null) {
            graph.add((Resource)node, FL.creatorParams, (Value)vf.createLiteral(a.getCreatorParams()), new Resource[0]);
        }
    }

    public IRI insertBounds(IRI boxIri, IRI property, String type, Rectangular bounds, Model graph) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        IRI iri = this.getIriFactory().createBoundsURI(boxIri, type);
        graph.add((Resource)boxIri, property, (Value)iri, new Resource[0]);
        graph.add((Resource)iri, BOX.positionX, (Value)vf.createLiteral(bounds.getX1()), new Resource[0]);
        graph.add((Resource)iri, BOX.positionY, (Value)vf.createLiteral(bounds.getY1()), new Resource[0]);
        graph.add((Resource)iri, BOX.width, (Value)vf.createLiteral(bounds.getWidth()), new Resource[0]);
        graph.add((Resource)iri, BOX.height, (Value)vf.createLiteral(bounds.getHeight()), new Resource[0]);
        return iri;
    }
}

