/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.api.IRIDecoder;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.AreaModelBuilder;
import cz.vutbr.fit.layout.rdf.AreaModelLoader;
import cz.vutbr.fit.layout.rdf.BoxModelBuilder;
import cz.vutbr.fit.layout.rdf.BoxModelLoader;
import cz.vutbr.fit.layout.rdf.ChunkSetModelBuilder;
import cz.vutbr.fit.layout.rdf.ChunkSetModelLoader;
import cz.vutbr.fit.layout.rdf.DefaultIRIFactory;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.LogicalAreaModelBuilder;
import cz.vutbr.fit.layout.rdf.LogicalAreaModelLoader;
import cz.vutbr.fit.layout.rdf.ModelBuilder;
import cz.vutbr.fit.layout.rdf.ModelLoader;
import cz.vutbr.fit.layout.rdf.RDFArtifactInfo;
import cz.vutbr.fit.layout.rdf.RDFIRIDecoder;
import cz.vutbr.fit.layout.rdf.RDFStorage;
import cz.vutbr.fit.layout.rdf.StorageException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFArtifactRepository
implements ArtifactRepository {
    private static Logger log = LoggerFactory.getLogger(RDFArtifactRepository.class);
    private static String[] owls = new String[]{"render.owl", "segmentation.owl", "fitlayout.owl", "mapping.owl"};
    private RDFStorage storage;
    private IRIFactory iriFactory;
    private RDFIRIDecoder iriDecoder;
    private Map<IRI, ModelBuilder> modelBuilders;
    private Map<IRI, ModelLoader> modelLoaders;

    public RDFArtifactRepository(RDFStorage storage) {
        this.storage = storage;
        this.iriFactory = new DefaultIRIFactory();
        this.iriDecoder = new RDFIRIDecoder();
        this.initDefaultModelBuilders();
        this.init();
    }

    public static RDFArtifactRepository createMemory(String path) {
        return new RDFArtifactRepository(RDFStorage.createMemory(path));
    }

    public static RDFArtifactRepository createNative(String path) {
        return new RDFArtifactRepository(RDFStorage.createNative(path));
    }

    public static RDFArtifactRepository createHTTP(String serverUrl, String repositoryId) {
        return new RDFArtifactRepository(RDFStorage.createHTTP(serverUrl, repositoryId));
    }

    public void disconnect() {
        this.storage.close();
    }

    public RDFStorage getStorage() {
        return this.storage;
    }

    public IRIDecoder getIriDecoder() {
        return this.iriDecoder;
    }

    public IRIFactory getIriFactory() {
        return this.iriFactory;
    }

    public void setIriFactory(IRIFactory iriFactory) {
        this.iriFactory = iriFactory;
    }

    public void init() {
        if (!this.isInitialized() && System.getProperty("fitlayout.rdf.disableAutoInit") == null) {
            this.initMetadata();
            if (!this.isInitialized()) {
                log.error("Repository init failed");
            }
        }
    }

    public boolean isInitialized() {
        Value val = this.getStorage().getPropertyValue((Resource)BOX.Page, RDF.TYPE);
        return val != null;
    }

    public boolean initMetadata() {
        log.info("Initializing repository metadata");
        try {
            for (String owl : owls) {
                SimpleValueFactory vf = SimpleValueFactory.getInstance();
                IRI context = vf.createIRI("file://resources/rdf/" + owl);
                String owlFile = RDFArtifactRepository.loadResource("/rdf/" + owl);
                this.getStorage().importXML(owlFile, context);
            }
        }
        catch (Exception e) {
            log.error("Could import metadata: {}", (Throwable)e);
            return false;
        }
        return this.isInitialized();
    }

    private static String loadResource(String filePath) {
        try (Scanner scanner = new Scanner(RDFArtifactRepository.class.getResourceAsStream(filePath), "UTF-8");){
            scanner.useDelimiter("\\A");
            String string = scanner.next();
            return string;
        }
    }

    public Collection<IRI> getArtifactIRIs() throws StorageException {
        try {
            String query = this.iriDecoder.declarePrefixes() + "SELECT DISTINCT ?pg WHERE {  ?pg rdf:type ?type .   ?type rdfs:subClassOf fl:Artifact .   OPTIONAL { ?pg fl:createdOn ?time } } ORDER BY ?time";
            log.debug("QUERY: {}", (Object)query);
            List<BindingSet> data = this.storage.executeSafeTupleQuery(query);
            ArrayList<IRI> ret = new ArrayList<IRI>(data.size());
            for (BindingSet binding : data) {
                Binding b = binding.getBinding("pg");
                ret.add((IRI)b.getValue());
            }
            return ret;
        }
        catch (RDF4JException e) {
            throw new StorageException(e);
        }
    }

    public Collection<Artifact> getArtifactInfo() {
        Collection<IRI> iris = this.getArtifactIRIs();
        ArrayList<Artifact> ret = new ArrayList<Artifact>(iris.size());
        for (IRI iri : iris) {
            Model artifactModel = this.getStorage().getSubjectModel((Resource)iri);
            if (artifactModel.size() <= 0) continue;
            RDFArtifactInfo info = new RDFArtifactInfo(artifactModel, iri);
            ret.add((Artifact)info);
        }
        return ret;
    }

    public Artifact getArtifact(IRI artifactIri) {
        Model model = this.getArtifactModel(artifactIri);
        IRI type = this.getArtifactType(model, artifactIri);
        if (type != null) {
            ModelLoader loader = this.getModelLoader(type);
            if (loader != null) {
                Artifact artifact = loader.loadArtifact(artifactIri, this);
                return artifact;
            }
            log.warn("No loader available for type {}", (Object)type);
        } else {
            log.warn("Artifact {} has no type", (Object)artifactIri);
        }
        return null;
    }

    public Model getArtifactModel(IRI artifactIri) {
        return this.storage.getContextModel((Resource)artifactIri);
    }

    public void addArtifact(Artifact artifact) {
        if (artifact.getIri() == null) {
            artifact.setIri(this.createArtifactIri(artifact));
        }
        log.debug("STORING {}", (Object)artifact);
        ModelBuilder builder = this.getModelBuilder(artifact.getArtifactType());
        if (builder != null) {
            Model graph = builder.createGraph(artifact);
            this.storage.insertGraph(graph, artifact.getIri());
        } else {
            log.error("Could not find RDF model builder for artifact {}, type {}", (Object)artifact, (Object)artifact.getArtifactType());
        }
    }

    public IRI createArtifactIri(Artifact artifact) {
        long seq = this.storage.getNextSequenceValue(this.iriFactory.createSequenceURI("page"));
        IRI pageUri = this.iriFactory.createArtifactIri(seq);
        return pageUri;
    }

    public void removeArtifact(IRI artifactIri) {
        ArrayList<Artifact> derived = new ArrayList<Artifact>();
        this.findDerivedArtifacts(artifactIri, this.getArtifactInfo(), derived);
        for (Artifact a : derived) {
            this.storage.clear(a.getIri());
        }
        this.storage.clear(artifactIri);
    }

    private void findDerivedArtifacts(IRI artifactIri, Collection<Artifact> artifacts, List<Artifact> dest) {
        for (Artifact a : artifacts) {
            if (a.getParentIri() != artifactIri) continue;
            this.findDerivedArtifacts(a.getIri(), artifacts, dest);
            dest.add(a);
        }
    }

    public void clear() {
        this.storage.clear();
    }

    private IRI getArtifactType(Model model, IRI artifactIri) {
        Iterable typeStatements = model.getStatements((Resource)artifactIri, RDF.TYPE, null, new Resource[0]);
        for (Statement st : typeStatements) {
            if (!(st.getObject() instanceof IRI)) continue;
            return (IRI)st.getObject();
        }
        return null;
    }

    protected void initDefaultModelBuilders() {
        this.modelBuilders = new HashMap<IRI, ModelBuilder>();
        this.modelLoaders = new HashMap<IRI, ModelLoader>();
        this.addModelBuilder(BOX.Page, new BoxModelBuilder(this.iriFactory));
        this.addModelBuilder(SEGM.AreaTree, new AreaModelBuilder(this.iriFactory));
        this.addModelBuilder(SEGM.LogicalAreaTree, new LogicalAreaModelBuilder(this.iriFactory));
        this.addModelBuilder(SEGM.ChunkSet, new ChunkSetModelBuilder(this.iriFactory));
        this.addModelLoader(BOX.Page, new BoxModelLoader(this.iriFactory));
        this.addModelLoader(SEGM.AreaTree, new AreaModelLoader(this.iriFactory));
        this.addModelLoader(SEGM.LogicalAreaTree, new LogicalAreaModelLoader(this.iriFactory));
        this.addModelLoader(SEGM.ChunkSet, new ChunkSetModelLoader(this.iriFactory));
    }

    public void addModelBuilder(IRI artifactType, ModelBuilder builder) {
        this.modelBuilders.put(artifactType, builder);
    }

    public ModelBuilder getModelBuilder(IRI artifactType) {
        return this.modelBuilders.get(artifactType);
    }

    public void addModelLoader(IRI artifactType, ModelLoader builder) {
        this.modelLoaders.put(artifactType, builder);
    }

    public ModelLoader getModelLoader(IRI artifactType) {
        return this.modelLoaders.get(artifactType);
    }
}

