/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelBuilder;
import cz.vutbr.fit.layout.rdf.ModelBuilderBase;
import cz.vutbr.fit.layout.rdf.model.RDFAreaTree;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;

public class AreaModelBuilder
extends ModelBuilderBase
implements ModelBuilder {
    private ValueFactory vf = SimpleValueFactory.getInstance();
    private int next_order;

    public AreaModelBuilder(IRIFactory iriFactory) {
        super(iriFactory);
    }

    @Override
    public Model createGraph(Artifact artifact) {
        return this.createAreaTreeModel((AreaTree)artifact, artifact.getIri());
    }

    private Model createAreaTreeModel(AreaTree areaTree, IRI areaTreeNode) {
        Set<Statement> toadd;
        LinkedHashModel graph = new LinkedHashModel();
        IRI pageNode = areaTree.getPageIri();
        HashSet<Tag> usedTags = new HashSet<Tag>();
        this.addArtifactData((Model)graph, (Artifact)areaTree);
        graph.add((Resource)areaTreeNode, SEGM.hasSourcePage, (Value)pageNode, new Resource[0]);
        this.next_order = 0;
        this.addArea(areaTree.getRoot(), areaTreeNode, pageNode, usedTags, (Model)graph);
        this.insertAllAreas(areaTree.getRoot().getChildren(), areaTreeNode, pageNode, usedTags, (Model)graph);
        if (areaTree instanceof RDFAreaTree && (toadd = ((RDFAreaTree)areaTree).getAdditionalStatements()) != null) {
            graph.addAll(toadd);
        }
        return graph;
    }

    private void insertAllAreas(List<Area> areas, IRI areaTreeNode, IRI pageNode, Set<Tag> usedTags, Model graph) {
        for (Area area : areas) {
            this.addArea(area, areaTreeNode, pageNode, usedTags, graph);
            this.insertAllAreas(area.getChildren(), areaTreeNode, pageNode, usedTags, graph);
        }
    }

    private void addArea(Area area, IRI areaTreeNode, IRI pageNode, Set<Tag> usedTags, Model graph) {
        IRI individual = this.getAreaIri(areaTreeNode, area);
        graph.add((Resource)individual, RDF.TYPE, (Value)SEGM.Area, new Resource[0]);
        if (area.getName() != null) {
            graph.add((Resource)individual, RDFS.LABEL, (Value)this.vf.createLiteral(area.getName()), new Resource[0]);
        }
        graph.add((Resource)individual, BOX.documentOrder, (Value)this.vf.createLiteral(this.next_order++), new Resource[0]);
        graph.add((Resource)individual, SEGM.belongsTo, (Value)areaTreeNode, new Resource[0]);
        if (area.getParent() != null) {
            graph.add((Resource)individual, SEGM.isChildOf, (Value)this.getAreaIri(areaTreeNode, (Area)area.getParent()), new Resource[0]);
        }
        this.insertSameAs((ContentRect)area, individual, graph);
        this.insertBounds(individual, BOX.bounds, "b", area.getBounds(), graph);
        if (area.getTags().size() > 0) {
            Map tags = area.getTags();
            for (Tag t : tags.keySet()) {
                Float support = (Float)tags.get(t);
                if (support == null || !(support.floatValue() > 0.0f)) continue;
                usedTags.add(t);
                IRI tagUri = this.getIriFactory().createTagURI(t);
                graph.add((Resource)individual, SEGM.hasTag, (Value)tagUri, new Resource[0]);
                IRI supUri = this.getIriFactory().createTagSupportURI(individual, t);
                graph.add((Resource)individual, SEGM.tagSupport, (Value)supUri, new Resource[0]);
                graph.add((Resource)supUri, SEGM.support, (Value)this.vf.createLiteral(support.floatValue()), new Resource[0]);
                graph.add((Resource)supUri, SEGM.hasTag, (Value)tagUri, new Resource[0]);
            }
        }
        this.addContentRectData(graph, individual, (ContentRect)area);
        this.addTextStyle(graph, individual, (ContentRect)area);
        for (Box box : area.getBoxes()) {
            IRI boxUri = this.getBoxIri(pageNode, box);
            graph.add((Resource)individual, SEGM.containsBox, (Value)boxUri, new Resource[0]);
        }
    }
}

