/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.impl.DefaultTreeContentRect;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.FL;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.AreaTreeInfo;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelLoader;
import cz.vutbr.fit.layout.rdf.ModelLoaderBase;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.model.RDFArea;
import cz.vutbr.fit.layout.rdf.model.RDFAreaTree;
import cz.vutbr.fit.layout.rdf.model.RDFBox;
import cz.vutbr.fit.layout.rdf.model.RDFPage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaModelLoader
extends ModelLoaderBase
implements ModelLoader {
    private static Logger log = LoggerFactory.getLogger(AreaModelLoader.class);
    private static final String[] dataObjectProperties = new String[]{"box:hasTopBorder", "box:hasBottomBorder", "box:hasLeftBorder", "box:hasRightBorder", "box:hasAttribute", "box:bounds", "segm:hasTag", "segm:tagSupport"};
    private int next_id;

    public AreaModelLoader(IRIFactory iriFactory) {
        super(iriFactory);
    }

    @Override
    public Artifact loadArtifact(IRI artifactIri, RDFArtifactRepository artifactRepo) throws RepositoryException {
        this.loadTags(artifactRepo);
        return this.constructAreaTree(artifactRepo, artifactIri);
    }

    private RDFAreaTree constructAreaTree(RDFArtifactRepository artifactRepo, IRI areaTreeIri) throws RepositoryException {
        this.next_id = 0;
        Model artifactModel = artifactRepo.getStorage().getSubjectModel((Resource)areaTreeIri);
        if (artifactModel.size() > 0) {
            LinkedHashMap<IRI, RDFArea> areaUris;
            RDFArea root;
            AreaTreeInfo atreeInfo = new AreaTreeInfo(artifactModel, areaTreeIri);
            IRI pageIri = this.getSourcePageIri(artifactModel, areaTreeIri);
            IRI parentIri = this.getPredicateIriValue(artifactModel, areaTreeIri, FL.hasParentArtifact);
            RDFAreaTree atree = new RDFAreaTree(parentIri, pageIri);
            atreeInfo.applyToAreaTree(atree);
            Model areaModel = this.getAreaModelForAreaTree(artifactRepo, areaTreeIri);
            Model dataModel = this.getAreaDataModelForAreaTree(artifactRepo, areaTreeIri);
            RDFPage sourcePage = null;
            if (pageIri != null) {
                sourcePage = this.getSourcePage(pageIri, artifactRepo);
            }
            if ((root = this.constructVisualAreaTree(artifactRepo, sourcePage, atree, areaModel, dataModel, areaTreeIri, areaUris = new LinkedHashMap<IRI, RDFArea>(), atree.getAdditionalStatements())) != null) {
                this.recursiveUpdateTopologies((Area)root);
                atree.setRoot((Area)root);
                atree.setAreaIris(areaUris);
                return atree;
            }
            return null;
        }
        return null;
    }

    private RDFArea constructVisualAreaTree(RDFArtifactRepository artifactRepo, RDFPage sourcePage, RDFAreaTree atree, Model areaModel, Model dataModel, IRI areaTreeIri, Map<IRI, RDFArea> areas, Collection<Statement> additionalStatements) throws RepositoryException {
        for (Object res : areaModel.subjects()) {
            if (!(res instanceof IRI)) continue;
            RDFArea area = this.createAreaFromModel(artifactRepo, sourcePage, areaModel, dataModel, areaTreeIri, (IRI)res, additionalStatements);
            area.setAreaTree((AreaTree)atree);
            areas.put((IRI)res, area);
        }
        HashSet<RDFArea> rootAreas = new HashSet<RDFArea>(areas.values());
        for (Statement st : areaModel.filter(null, SEGM.isChildOf, null, new Resource[0])) {
            if (!(st.getSubject() instanceof IRI) || !(st.getObject() instanceof IRI)) continue;
            RDFArea parent = areas.get(st.getObject());
            RDFArea child = areas.get(st.getSubject());
            if (parent == null || child == null) continue;
            parent.appendChild((Area)child);
            rootAreas.remove(child);
        }
        if (rootAreas.size() == 1) {
            RDFArea root = (RDFArea)rootAreas.iterator().next();
            this.checkChildOrderValues(root);
            return root;
        }
        log.error("Strange number of root areas: {}", (Object)((Object)rootAreas).toString());
        return null;
    }

    private RDFArea createAreaFromModel(RDFArtifactRepository artifactRepo, RDFPage sourcePage, Model areaModel, Model dataModel, IRI areaTreeIri, IRI uri, Collection<Statement> additionalStatements) throws RepositoryException {
        RDFArea area = new RDFArea(new Rectangular(), uri);
        area.setId(this.next_id++);
        area.setDocumentOrder(-1);
        HashMap<IRI, Float> tagSupport = new HashMap<IRI, Float>();
        ModelLoaderBase.RDFTextStyle style = new ModelLoaderBase.RDFTextStyle();
        for (Statement st : areaModel.filter((Resource)uri, null, null, new Resource[0])) {
            Value value;
            IRI pred = st.getPredicate();
            if (this.processContentRectProperty(pred, value = st.getObject(), (DefaultTreeContentRect<?>)area, dataModel) || this.processStyleProperty(pred, value, style)) continue;
            if (RDFS.LABEL.equals((Object)pred)) {
                String name = value.stringValue();
                area.setName(name);
                continue;
            }
            if (BOX.documentOrder.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                area.setDocumentOrder(((Literal)value).intValue());
                continue;
            }
            if (BOX.bounds.equals((Object)pred)) {
                Rectangular rect;
                if (!(value instanceof IRI) || (rect = this.createBounds(dataModel, (IRI)value)) == null) continue;
                area.setBounds(rect);
                continue;
            }
            if (SEGM.containsBox.equals((Object)pred)) {
                RDFBox box;
                if (!(value instanceof IRI) || sourcePage == null || (box = sourcePage.findBoxByIri((IRI)value)) == null) continue;
                area.addBox((Box)box);
                continue;
            }
            if (SEGM.hasTag.equals((Object)pred)) {
                Tag tag;
                if (!(value instanceof IRI) || tagSupport.containsKey(value) || (tag = this.getTag((IRI)value)) == null) continue;
                area.addTag(tag, 1.0f);
                continue;
            }
            if (SEGM.tagSupport.equals((Object)pred)) {
                Tag tag;
                if (!(value instanceof IRI)) continue;
                IRI tsUri = (IRI)value;
                IRI tagUri = null;
                Float support = null;
                for (Statement sst : dataModel.filter((Resource)tsUri, null, null, new Resource[0])) {
                    if (SEGM.hasTag.equals((Object)sst.getPredicate()) && sst.getObject() instanceof IRI) {
                        tagUri = (IRI)sst.getObject();
                        continue;
                    }
                    if (!SEGM.support.equals((Object)sst.getPredicate()) || !(sst.getObject() instanceof Literal)) continue;
                    support = Float.valueOf(((Literal)sst.getObject()).floatValue());
                }
                if (tagUri == null || support == null || (tag = this.getTag(tagUri)) == null) continue;
                area.removeTag(tag);
                area.addTag(tag, support.floatValue());
                tagSupport.put(tagUri, support);
                continue;
            }
            additionalStatements.add(st);
        }
        area.setTextStyle(style.toTextStyle());
        area.sortBoxes();
        return area;
    }

    private void recursiveUpdateTopologies(Area root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveUpdateTopologies((Area)root.getChildAt(i));
        }
        root.updateTopologies();
    }

    private Model getAreaModelForAreaTree(RDFArtifactRepository artifactRepo, IRI areaTreeIri) throws RepositoryException {
        String query = artifactRepo.getIriDecoder().declarePrefixes() + "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?s rdf:type segm:Area . ?s segm:belongsTo <" + areaTreeIri.stringValue() + "> . OPTIONAL { ?s box:documentOrder ?ord } } ORDER BY ?ord";
        return artifactRepo.getStorage().executeSafeQuery(query);
    }

    private Model getAreaDataModelForAreaTree(RDFArtifactRepository artifactRepo, IRI areaTreeIri) throws RepositoryException {
        String query = artifactRepo.getIriDecoder().declarePrefixes() + "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?a rdf:type segm:Area . ?a segm:belongsTo <" + areaTreeIri.stringValue() + "> . " + this.getDataPropertyUnion(dataObjectProperties) + "}";
        return artifactRepo.getStorage().executeSafeQuery(query);
    }
}

