/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.impl.DefaultTreeContentRect;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelLoader;
import cz.vutbr.fit.layout.rdf.ModelLoaderBase;
import cz.vutbr.fit.layout.rdf.PageInfo;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.RDFStorage;
import cz.vutbr.fit.layout.rdf.Serialization;
import cz.vutbr.fit.layout.rdf.model.RDFBox;
import cz.vutbr.fit.layout.rdf.model.RDFContentImage;
import cz.vutbr.fit.layout.rdf.model.RDFContentObject;
import cz.vutbr.fit.layout.rdf.model.RDFPage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxModelLoader
extends ModelLoaderBase
implements ModelLoader {
    private static Logger log = LoggerFactory.getLogger(BoxModelLoader.class);
    private static final String[] dataObjectProperties = new String[]{"box:hasTopBorder", "box:hasBottomBorder", "box:hasLeftBorder", "box:hasRightBorder", "box:hasAttribute", "box:bounds", "box:visualBounds", "box:contentBounds"};
    private int next_id;

    public BoxModelLoader(IRIFactory iriFactory) {
        super(iriFactory);
    }

    @Override
    public Artifact loadArtifact(IRI artifactIri, RDFArtifactRepository artifactRepo) throws RepositoryException {
        return this.constructPage(artifactRepo, artifactIri);
    }

    private RDFPage constructPage(RDFArtifactRepository artifactRepo, IRI pageIri) throws RepositoryException {
        this.next_id = 0;
        Model pageModel = artifactRepo.getStorage().getSubjectModel((Resource)pageIri);
        if (pageModel.size() > 0) {
            URL srcURL;
            PageInfo info = new PageInfo(pageModel, pageIri);
            try {
                srcURL = new URL(info.getUrl());
            }
            catch (MalformedURLException e) {
                try {
                    srcURL = new URL("http://no/url");
                }
                catch (MalformedURLException e1) {
                    srcURL = null;
                }
            }
            RDFPage page = new RDFPage(srcURL);
            info.applyToPage(page);
            Model boxTreeModel = this.getBoxModelForPage(artifactRepo, pageIri);
            Model dataModel = this.getBoxDataModelForPage(artifactRepo, pageIri);
            LinkedHashMap<IRI, RDFBox> boxes = new LinkedHashMap<IRI, RDFBox>();
            RDFBox root = this.constructBoxTree(artifactRepo.getStorage(), boxTreeModel, dataModel, pageIri, boxes, page.getAdditionalStatements());
            if (root != null) {
                this.checkChildOrderValues(root);
                page.setRoot((Box)root);
                page.setBoxIris(boxes);
                if (page.getWidth() == -1 && page.getHeight() == -1) {
                    page.setWidth(root.getWidth());
                    page.setHeight(root.getHeight());
                }
                return page;
            }
            return null;
        }
        return null;
    }

    private RDFBox constructBoxTree(RDFStorage storage, Model boxTreeModel, Model dataModel, IRI pageIri, Map<IRI, RDFBox> boxes, Collection<Statement> additionalStatements) throws RepositoryException {
        for (Resource res : boxTreeModel.subjects()) {
            if (!(res instanceof IRI)) continue;
            RDFBox box = this.createBoxFromModel(storage, boxTreeModel, dataModel, pageIri, (IRI)res, additionalStatements);
            boxes.put((IRI)res, box);
        }
        ArrayList<RDFBox> rootBoxes = new ArrayList<RDFBox>(boxes.values());
        for (Statement st : boxTreeModel.filter(null, BOX.isChildOf, null, new Resource[0])) {
            if (!(st.getSubject() instanceof IRI) || !(st.getObject() instanceof IRI)) continue;
            RDFBox parent = boxes.get(st.getObject());
            RDFBox child = boxes.get(st.getSubject());
            if (parent == null || child == null) continue;
            parent.appendChild((GenericTreeNode)child);
            rootBoxes.remove(child);
        }
        if (rootBoxes.size() == 1) {
            return (RDFBox)rootBoxes.get(0);
        }
        log.error("Strange number of root boxes: {}", (Object)((Object)rootBoxes).toString());
        return null;
    }

    private RDFBox createBoxFromModel(RDFStorage storage, Model boxTreeModel, Model dataModel, IRI pageIri, IRI boxIri, Collection<Statement> additionalStatements) throws RepositoryException {
        RDFBox box = new RDFBox(boxIri);
        box.setId(this.next_id++);
        box.setOrder(-1);
        box.setTagName("");
        box.setType(Box.Type.ELEMENT);
        box.setDisplayType(Box.DisplayType.BLOCK);
        ModelLoaderBase.RDFTextStyle style = new ModelLoaderBase.RDFTextStyle();
        for (Statement st : boxTreeModel.filter((Resource)boxIri, null, null, new Resource[0])) {
            Rectangular rect;
            Value value;
            IRI pred = st.getPredicate();
            if (this.processContentRectProperty(pred, value = st.getObject(), (DefaultTreeContentRect<?>)box, dataModel) || this.processStyleProperty(pred, value, style)) continue;
            if (BOX.documentOrder.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                box.setOrder(((Literal)value).intValue());
                continue;
            }
            if (BOX.visible.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                box.setVisible(((Literal)value).booleanValue());
                continue;
            }
            if (BOX.hasBackgroundImage.equals((Object)pred)) {
                if (!(value instanceof IRI)) continue;
                RDFContentImage image = this.loadImage(storage, (IRI)value);
                box.setBackgroundImagePng(image.getPngData());
                continue;
            }
            if (BOX.color.equals((Object)pred)) {
                box.setColor(Serialization.decodeHexColor(value.stringValue()));
                continue;
            }
            if (BOX.fontFamily.equals((Object)pred)) {
                if (!(value instanceof Literal)) continue;
                box.setFontFamily(value.stringValue());
                continue;
            }
            if (BOX.text.equals((Object)pred)) {
                if (box.getType() != Box.Type.REPLACED_CONTENT) {
                    box.setType(Box.Type.TEXT_CONTENT);
                }
                box.setDisplayType(null);
                box.setOwnText(value.stringValue());
                continue;
            }
            if (BOX.containsObject.equals((Object)pred)) {
                RDFContentObject obj;
                box.setType(Box.Type.REPLACED_CONTENT);
                if (!(value instanceof IRI)) continue;
                Value valueType = storage.getPropertyValue((Resource)((IRI)value), RDF.TYPE);
                if (BOX.Image.equals((Object)valueType)) {
                    obj = this.loadImage(storage, (IRI)value);
                    box.setContentObject(obj);
                    continue;
                }
                obj = new RDFContentObject((IRI)value);
                box.setContentObject(obj);
                continue;
            }
            if (BOX.bounds.equals((Object)pred)) {
                if (!(value instanceof IRI) || (rect = this.createBounds(dataModel, (IRI)value)) == null) continue;
                box.setBounds(rect);
                continue;
            }
            if (BOX.visualBounds.equals((Object)pred)) {
                if (!(value instanceof IRI) || (rect = this.createBounds(dataModel, (IRI)value)) == null) continue;
                box.setVisualBounds(rect);
                continue;
            }
            if (BOX.contentBounds.equals((Object)pred)) {
                if (!(value instanceof IRI) || (rect = this.createBounds(dataModel, (IRI)value)) == null) continue;
                box.setContentBounds(rect);
                continue;
            }
            if (BOX.sourceXPath.equals((Object)pred)) {
                box.setSourceNodeId(value.stringValue());
                continue;
            }
            if (BOX.htmlTagName.equals((Object)pred)) {
                box.setTagName(value.stringValue());
                continue;
            }
            if (BOX.displayType.equals((Object)pred)) {
                Box.DisplayType type = Serialization.decodeDisplayType(value.stringValue());
                if (type == null) continue;
                box.setDisplayType(type);
                continue;
            }
            if (BOX.hasAttribute.equals((Object)pred)) {
                Map.Entry<String, String> attr;
                if (!(value instanceof IRI) || (attr = this.createAttribute(dataModel, (IRI)value)) == null) continue;
                box.setAttribute(attr.getKey(), attr.getValue());
                continue;
            }
            additionalStatements.add(st);
        }
        box.setTextStyle(style.toTextStyle());
        return box;
    }

    private RDFContentImage loadImage(RDFStorage storage, IRI imageIri) {
        Value dataVal;
        RDFContentImage obj = new RDFContentImage(imageIri);
        Value urlVal = storage.getPropertyValue((Resource)imageIri, BOX.imageUrl);
        if (urlVal != null && urlVal instanceof Literal) {
            try {
                obj.setUrl(((Literal)urlVal).stringValue());
            }
            catch (MalformedURLException e) {
                log.error(e.getMessage());
            }
        }
        if ((dataVal = storage.getPropertyValue((Resource)imageIri, BOX.imageData)) != null && dataVal instanceof Literal) {
            String dataStr = dataVal.stringValue();
            try {
                obj.setPngData(Base64.getDecoder().decode(dataStr));
            }
            catch (IllegalArgumentException e) {
                obj.setPngData(null);
            }
        }
        return obj;
    }

    private Model getBoxModelForPage(RDFArtifactRepository artifactRepo, IRI pageIri) throws RepositoryException {
        String query = artifactRepo.getIriDecoder().declarePrefixes() + "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?s rdf:type box:Box . ?s box:belongsTo <" + String.valueOf(pageIri) + "> . OPTIONAL { ?s box:documentOrder ?ord } } ORDER BY ?ord";
        return artifactRepo.getStorage().executeSafeQuery(query);
    }

    private Model getBoxDataModelForPage(RDFArtifactRepository artifactRepo, IRI pageIri) throws RepositoryException {
        String query = artifactRepo.getIriDecoder().declarePrefixes() + "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?b rdf:type box:Box . ?b box:belongsTo <" + String.valueOf(pageIri) + "> . " + this.getDataPropertyUnion() + "}";
        return artifactRepo.getStorage().executeSafeQuery(query);
    }

    private String getDataPropertyUnion() {
        StringBuilder ret = new StringBuilder();
        for (String p : dataObjectProperties) {
            if (ret.length() > 0) {
                ret.append(" UNION ");
            }
            ret.append("{?b ").append(p).append(" ?s}");
        }
        return ret.toString();
    }
}

