/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaConnection;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.ConnectionSet;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelBuilder;
import cz.vutbr.fit.layout.rdf.ModelBuilderBase;
import cz.vutbr.fit.layout.rdf.model.RDFConnectionSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;

public class ConnectionSetModelBuilder
extends ModelBuilderBase
implements ModelBuilder {
    public ConnectionSetModelBuilder(IRIFactory iriFactory) {
        super(iriFactory);
    }

    @Override
    public Model createGraph(Artifact artifact) {
        return this.createModel((ConnectionSet)artifact, artifact.getIri());
    }

    private Model createModel(ConnectionSet cset, IRI csetIri) {
        Set<Statement> toadd;
        LinkedHashModel graph = new LinkedHashModel();
        this.addArtifactData((Model)graph, (Artifact)cset);
        graph.add((Resource)csetIri, BOX.hasSource, (Value)cset.getSourceIri(), new Resource[0]);
        if (cset.getPageIri() != null) {
            graph.add((Resource)csetIri, SEGM.hasSourcePage, (Value)cset.getPageIri(), new Resource[0]);
        }
        this.addConnections(cset.getSourceIri(), cset.getAreaConnections(), (Model)graph);
        if (cset instanceof RDFConnectionSet && (toadd = ((RDFConnectionSet)cset).getAdditionalStatements()) != null) {
            graph.addAll(toadd);
        }
        return graph;
    }

    private void addConnections(IRI sourceIri, Set<AreaConnection> conns, Model graph) {
        for (AreaConnection con : conns) {
            this.addConnection(sourceIri, con, graph);
        }
    }

    private void addConnection(IRI artifactIri, AreaConnection con, Model graph) {
        IRI iri1 = this.getContentRectIRI(artifactIri, (ContentRect)con.getA1());
        IRI iri2 = this.getContentRectIRI(artifactIri, (ContentRect)con.getA2());
        if (iri1 != null && iri2 != null) {
            IRI relationIri = this.getIriFactory().createRelationURI(con.getRelation());
            graph.add((Resource)iri1, relationIri, (Value)iri2, new Resource[0]);
        }
    }

    private IRI getContentRectIRI(IRI artifactIri, ContentRect rect) {
        if (rect instanceof Area) {
            return this.getAreaIri(artifactIri, (Area)rect);
        }
        if (rect instanceof TextChunk) {
            return this.getTextChunkIri(artifactIri, (TextChunk)rect);
        }
        return null;
    }
}

