/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Relation;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.unbescape.uri.UriEscape;

public class DefaultIRIFactory
implements IRIFactory {
    public static final String NAMESPACE = "http://fitlayout.github.io/resource/";
    public static final String PREFIX = "r";
    private final ValueFactory factory = SimpleValueFactory.getInstance();

    @Override
    public IRI createPageSetURI(String name) {
        String res = name.replace(' ', '_');
        res = UriEscape.escapeUriPathSegment((String)res);
        return this.factory.createIRI(NAMESPACE, "pset-" + res);
    }

    @Override
    public IRI createArtifactIri(long seq) {
        return this.factory.createIRI(NAMESPACE, "art" + seq);
    }

    @Override
    public IRI createArtifactIri(String id) {
        return this.factory.createIRI(NAMESPACE, "art-" + id);
    }

    @Override
    public IRI createBoxURI(IRI pageUri, Box box) {
        return this.factory.createIRI(String.valueOf(pageUri) + "#b" + box.getId());
    }

    @Override
    public IRI createBoundsURI(IRI boxUri, String type) {
        String localName = boxUri.getLocalName() + "-rect-" + type;
        return this.factory.createIRI(boxUri.getNamespace(), localName);
    }

    @Override
    public IRI createBorderURI(IRI boxUri, String side) {
        String localName = boxUri.getLocalName() + "B" + side;
        return this.factory.createIRI(boxUri.getNamespace(), localName);
    }

    @Override
    public IRI createAttributeURI(IRI boxUri, String name) {
        String localName = boxUri.getLocalName() + "-attr-" + UriEscape.escapeUriPathSegment((String)name);
        return this.factory.createIRI(boxUri.getNamespace(), localName);
    }

    @Override
    public IRI createContentObjectURI(IRI pageUri, int seq) {
        return this.factory.createIRI(String.valueOf(pageUri) + "#o" + seq);
    }

    @Override
    public IRI createAreaURI(IRI areaTreeNode, Area area) {
        return this.factory.createIRI(String.valueOf(areaTreeNode) + "#a" + area.getId());
    }

    @Override
    public IRI createLogicalAreaURI(IRI areaTreeNode, int cnt) {
        return this.factory.createIRI(String.valueOf(areaTreeNode) + "#l" + cnt);
    }

    @Override
    public IRI createTagSupportURI(IRI areaUri, Tag tag) {
        return this.factory.createIRI(String.valueOf(areaUri) + "-" + this.getTagDesc(tag));
    }

    @Override
    public IRI createTagURI(Tag tag) {
        return this.factory.createIRI(NAMESPACE, "tag-" + this.getTagDesc(tag));
    }

    private String getTagDesc(Tag tag) {
        return tag.getType().replaceAll("\\.", "-") + "--" + tag.getName();
    }

    @Override
    public IRI createTextChunkURI(IRI chunkSetUri, TextChunk chunk) {
        return this.factory.createIRI(String.valueOf(chunkSetUri) + "#c" + chunk.getId());
    }

    @Override
    public IRI createRelationURI(Relation rel) {
        return this.factory.createIRI(NAMESPACE, "rel-" + rel.getName());
    }

    @Override
    public String decodeRelationURI(IRI iri) {
        String loc = iri.getLocalName();
        if (loc != null && loc.startsWith("rel-")) {
            return loc.substring(4);
        }
        return null;
    }

    @Override
    public IRI createSequenceURI(String name) {
        return this.factory.createIRI(NAMESPACE, "seq-" + name);
    }
}

