/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.LogicalArea;
import cz.vutbr.fit.layout.model.LogicalAreaTree;
import cz.vutbr.fit.layout.ontology.BOX;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelBuilder;
import cz.vutbr.fit.layout.rdf.ModelBuilderBase;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;

public class LogicalAreaModelBuilder
extends ModelBuilderBase
implements ModelBuilder {
    private ValueFactory vf = SimpleValueFactory.getInstance();
    private int next_order;

    public LogicalAreaModelBuilder(IRIFactory iriFactory) {
        super(iriFactory);
    }

    @Override
    public Model createGraph(Artifact artifact) {
        return this.createAreaTreeModel((LogicalAreaTree)artifact, artifact.getIri());
    }

    private Model createAreaTreeModel(LogicalAreaTree logicalTree, IRI logicalAreaTreeNode) {
        IRI areaTreeNode = logicalTree.getAreaTreeIri();
        LinkedHashModel graph = new LinkedHashModel();
        graph.add((Resource)logicalAreaTreeNode, RDF.TYPE, (Value)SEGM.LogicalAreaTree, new Resource[0]);
        graph.add((Resource)logicalAreaTreeNode, SEGM.hasAreaTree, (Value)areaTreeNode, new Resource[0]);
        this.next_order = 0;
        IRI lroot = this.addLogicalArea(logicalTree.getRoot(), null, areaTreeNode, (Model)graph);
        this.insertAllLogicalAreas(logicalTree.getRoot().getChildren(), lroot, areaTreeNode, (Model)graph);
        return graph;
    }

    private void insertAllLogicalAreas(List<LogicalArea> areas, IRI parent, IRI areaTreeNode, Model graph) {
        for (LogicalArea area : areas) {
            IRI p = this.addLogicalArea(area, parent, areaTreeNode, graph);
            this.insertAllLogicalAreas(area.getChildren(), p, areaTreeNode, graph);
        }
    }

    private IRI addLogicalArea(LogicalArea area, IRI parent, IRI areaTreeNode, Model graph) {
        IRI individual = this.getLogicalAreaIri(areaTreeNode, area, this.next_order++);
        graph.add((Resource)individual, RDF.TYPE, (Value)SEGM.LogicalArea, new Resource[0]);
        graph.add((Resource)individual, BOX.documentOrder, (Value)this.vf.createLiteral(this.next_order++), new Resource[0]);
        graph.add((Resource)individual, SEGM.belongsTo, (Value)areaTreeNode, new Resource[0]);
        graph.add((Resource)individual, SEGM.text, (Value)this.vf.createLiteral(area.getText()), new Resource[0]);
        if (parent != null) {
            graph.add((Resource)individual, SEGM.isSubordinateTo, (Value)parent, new Resource[0]);
        }
        if (area.getMainTag() != null) {
            graph.add((Resource)individual, SEGM.hasTag, (Value)this.getIriFactory().createTagURI(area.getMainTag()), new Resource[0]);
        }
        for (Area a : area.getAreas()) {
            IRI areaUri = this.getAreaIri(areaTreeNode, a);
            graph.add((Resource)individual, SEGM.containsArea, (Value)areaUri, new Resource[0]);
        }
        return individual;
    }
}

