/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.rdf;

import cz.vutbr.fit.layout.impl.DefaultLogicalAreaTree;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.model.LogicalArea;
import cz.vutbr.fit.layout.model.LogicalAreaTree;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.ontology.SEGM;
import cz.vutbr.fit.layout.rdf.IRIFactory;
import cz.vutbr.fit.layout.rdf.ModelLoader;
import cz.vutbr.fit.layout.rdf.ModelLoaderBase;
import cz.vutbr.fit.layout.rdf.RDFArtifactRepository;
import cz.vutbr.fit.layout.rdf.model.RDFArea;
import cz.vutbr.fit.layout.rdf.model.RDFAreaTree;
import cz.vutbr.fit.layout.rdf.model.RDFLogicalArea;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalAreaModelLoader
extends ModelLoaderBase
implements ModelLoader {
    private static Logger log = LoggerFactory.getLogger(LogicalAreaModelLoader.class);

    public LogicalAreaModelLoader(IRIFactory iriFactory) {
        super(iriFactory);
    }

    @Override
    public Artifact loadArtifact(IRI artifactIri, RDFArtifactRepository artifactRepo) throws RepositoryException {
        this.loadTags(artifactRepo);
        return this.constructLogicalAreaTree(artifactRepo, artifactIri);
    }

    private LogicalAreaTree constructLogicalAreaTree(RDFArtifactRepository artifactRepo, IRI logicalTreeIri) throws RepositoryException {
        Model model = this.getLogicalAreaModelForAreaTree(artifactRepo, logicalTreeIri);
        if (model.size() > 0) {
            IRI areaTreeIri = this.getSourceAreaTreeIri(model, logicalTreeIri);
            DefaultLogicalAreaTree atree = new DefaultLogicalAreaTree(areaTreeIri);
            LinkedHashMap<IRI, RDFLogicalArea> areaUris = new LinkedHashMap<IRI, RDFLogicalArea>();
            RDFLogicalArea root = this.constructLogicalAreaTree(artifactRepo, model, logicalTreeIri, areaUris);
            if (root != null) {
                atree.setRoot((LogicalArea)root);
                return atree;
            }
            return null;
        }
        return null;
    }

    private RDFLogicalArea constructLogicalAreaTree(RDFArtifactRepository artifactRepo, Model model, IRI logicalTreeIri, Map<IRI, RDFLogicalArea> areas) throws RepositoryException {
        for (Resource res : model.subjects()) {
            if (!(res instanceof IRI)) continue;
            RDFLogicalArea area = this.createLogicalAreaFromModel(artifactRepo, model, logicalTreeIri, (IRI)res);
            areas.put((IRI)res, area);
        }
        ArrayList<RDFLogicalArea> rootAreas = new ArrayList<RDFLogicalArea>(areas.values());
        for (Statement st : model.filter(null, SEGM.isSubordinateTo, null, new Resource[0])) {
            if (!(st.getSubject() instanceof IRI) || !(st.getObject() instanceof IRI)) continue;
            RDFLogicalArea parent = areas.get(st.getObject());
            RDFLogicalArea child = areas.get(st.getSubject());
            if (parent == null || child == null) continue;
            parent.appendChild((GenericTreeNode)child);
            rootAreas.remove(child);
        }
        if (rootAreas.size() == 1) {
            return (RDFLogicalArea)rootAreas.get(0);
        }
        log.error("Strange number of root logical areas: {}", (Object)((Object)rootAreas).toString());
        return null;
    }

    private RDFLogicalArea createLogicalAreaFromModel(RDFArtifactRepository artifactRepo, Model model, IRI treeIri, IRI iri) throws RepositoryException {
        RDFLogicalArea area = new RDFLogicalArea(iri);
        RDFAreaTree areaTree = null;
        for (Statement st : model.filter((Resource)iri, null, null, new Resource[0])) {
            RDFArea a;
            IRI areaTreeIri;
            IRI pred = st.getPredicate();
            Value value = st.getObject();
            if (SEGM.text.equals((Object)pred)) {
                area.setText(value.stringValue());
                continue;
            }
            if (SEGM.hasTag.equals((Object)pred)) {
                Tag tag;
                if (!(value instanceof IRI) || (tag = this.getTag((IRI)value)) == null) continue;
                area.setMainTag(tag);
                continue;
            }
            if (!SEGM.containsArea.equals((Object)pred) || !(value instanceof IRI)) continue;
            if (areaTree == null && (areaTreeIri = this.getSourceAreaTreeIri(model, treeIri)) != null) {
                areaTree = this.getSourceAreaTree(areaTreeIri, artifactRepo);
            }
            if (areaTree == null || (a = areaTree.findAreaByIri((IRI)value)) == null) continue;
            area.addArea((Area)a);
        }
        return area;
    }

    private Model getLogicalAreaModelForAreaTree(RDFArtifactRepository artifactRepo, IRI logicalTreeIri) throws RepositoryException {
        String query = artifactRepo.getIriDecoder().declarePrefixes() + "CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o . ?s rdf:type segm:LogicalArea . ?s segm:belongsTo <" + logicalTreeIri.stringValue() + "> OPTIONAL { ?s box:documentOrder ?ord } } ORDER BY ?ord";
        return artifactRepo.getStorage().executeSafeQuery(query);
    }
}

